/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.loaders.classfiles;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import software.amazon.disco.agent.inject.Injector;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.instrumentation.preprocess.cli.PreprocessConfig;
import software.amazon.disco.instrumentation.preprocess.export.ExportStrategy;
import software.amazon.disco.instrumentation.preprocess.export.JarExportStrategy;
import software.amazon.disco.instrumentation.preprocess.instrumentation.SignedJarHandlingStrategy;
import software.amazon.disco.instrumentation.preprocess.loaders.classfiles.ClassFileLoader;
import software.amazon.disco.instrumentation.preprocess.loaders.classfiles.SourceInfo;
import software.amazon.disco.instrumentation.preprocess.util.FileUtils;
import software.amazon.disco.instrumentation.preprocess.util.JarSigningVerificationOutcome;

public class JarLoader
implements ClassFileLoader {
    private static final Logger log = LogManager.getLogger(JarLoader.class);
    private static Instrumentation instrumentation = Injector.createInstrumentation();

    @Override
    public SourceInfo load(Path path, PreprocessConfig config) {
        log.debug("Disco(Instrumentation preprocess) - Loading Jar: " + path);
        SourceInfo info = this.loadJar(path.toFile(), new JarExportStrategy(), config.getSignedJarHandlingStrategy());
        if (info != null) {
            log.debug("Disco(Instrumentation preprocess) - Jar loaded: " + path);
        }
        return info;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SourceInfo loadJar(File file, ExportStrategy exportStrategy, SignedJarHandlingStrategy signedJarHandlingStrategy) {
        try (JarFile jarFile = new JarFile(file);){
            if (jarFile == null) {
                log.warn("Disco(Instrumentation preprocess) - Failed to load Jar: " + file.getAbsolutePath());
                SourceInfo sourceInfo = null;
                return sourceInfo;
            }
            JarSigningVerificationOutcome outcome = FileUtils.verifyJar(file);
            log.debug("Disco(Instrumentation preprocess) - Jar verification outcome: " + outcome.name());
            if (signedJarHandlingStrategy.skipJarLoading(outcome)) {
                log.info("Disco(Instrumentation preprocess) - " + signedJarHandlingStrategy.getClass().getName() + " determined to skip the loading of Jar: " + file.getName());
                SourceInfo sourceInfo = new SourceInfo(file, exportStrategy, Collections.emptyMap(), outcome);
                return sourceInfo;
            }
            this.injectFileToSystemClassPath(file);
            log.debug("Disco(Instrumentation preprocess) - Extracting class files from: " + file.getName());
            HashMap<String, byte[]> classFileData = new HashMap<String, byte[]>();
            for (JarEntry entry : this.extractEntries(jarFile)) {
                if (!entry.getName().endsWith(".class")) continue;
                String nameWithoutExtension = entry.getName().substring(0, entry.getName().lastIndexOf(".class")).replace('/', '.');
                classFileData.put(nameWithoutExtension, FileUtils.readEntryFromJar(jarFile, entry));
            }
            log.debug("Disco(Instrumentation preprocess) - Class files extracted: " + classFileData.size());
            SourceInfo sourceInfo = new SourceInfo(file, exportStrategy, classFileData, outcome);
            return sourceInfo;
        }
        catch (Throwable t) {
            log.warn("Disco(Instrumentation preprocess) - Failed to load Jar: " + file.getAbsolutePath(), t);
            return null;
        }
    }

    protected List<JarEntry> extractEntries(JarFile jarFile) {
        ArrayList<JarEntry> result = new ArrayList<JarEntry>();
        if (jarFile != null) {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry e = entries.nextElement();
                if (e.isDirectory() || !e.getName().endsWith(".class")) continue;
                result.add(e);
            }
        }
        return result;
    }

    protected void injectFileToSystemClassPath(File file) {
        log.debug("Disco(Instrumentation preprocess) - Injecting file to system class path: " + file.getName());
        Injector.addToSystemClasspath(instrumentation, file);
    }
}

