/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.loaders.agents;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import software.amazon.disco.agent.inject.Injector;

public class TransformerExtractor
implements Instrumentation {
    private final Instrumentation delegate;
    private static List<ClassFileTransformer> transformers = new ArrayList<ClassFileTransformer>();

    public TransformerExtractor(Instrumentation delegate) {
        this.delegate = delegate;
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer, boolean canRetransform) {
        transformers.add(transformer);
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer) {
        transformers.add(transformer);
    }

    @Override
    public boolean isRetransformClassesSupported() {
        return true;
    }

    @Override
    public boolean isRedefineClassesSupported() {
        return true;
    }

    @Override
    public void appendToBootstrapClassLoaderSearch(JarFile jarfile) {
        Injector.createInstrumentation().appendToBootstrapClassLoaderSearch(jarfile);
    }

    public static List<ClassFileTransformer> getTransformers() {
        return transformers;
    }

    @Override
    public boolean removeTransformer(ClassFileTransformer arg0) {
        return this.delegate.removeTransformer(arg0);
    }

    @Override
    public void retransformClasses(Class<?> ... arg0) throws UnmodifiableClassException {
        this.delegate.retransformClasses(arg0);
    }

    @Override
    public void redefineClasses(ClassDefinition ... arg0) throws ClassNotFoundException, UnmodifiableClassException {
        this.delegate.redefineClasses(arg0);
    }

    @Override
    public boolean isModifiableClass(Class<?> arg0) {
        return this.delegate.isModifiableClass(arg0);
    }

    @Override
    public Class[] getAllLoadedClasses() {
        return this.delegate.getAllLoadedClasses();
    }

    @Override
    public Class[] getInitiatedClasses(ClassLoader arg0) {
        return this.delegate.getInitiatedClasses(arg0);
    }

    @Override
    public long getObjectSize(Object arg0) {
        return this.delegate.getObjectSize(arg0);
    }

    @Override
    public void appendToSystemClassLoaderSearch(JarFile arg0) {
        this.delegate.appendToSystemClassLoaderSearch(arg0);
    }

    @Override
    public boolean isNativeMethodPrefixSupported() {
        return this.delegate.isNativeMethodPrefixSupported();
    }

    @Override
    public void setNativeMethodPrefix(ClassFileTransformer arg0, String arg1) {
        this.delegate.setNativeMethodPrefix(arg0, arg1);
    }

    private abstract class ExcludedListMethods {
        private ExcludedListMethods() {
        }

        public abstract void addTransformer(ClassFileTransformer var1, boolean var2);

        public abstract void appendToBootstrapClassLoaderSearch(JarFile var1);

        public abstract boolean isRedefineClassesSupported();

        public abstract boolean isRetransformClassesSupported();

        public abstract void addTransformer(ClassFileTransformer var1);
    }
}

