/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.instrumentation;

import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.agent.plugin.ResourcesClassInjector;
import software.amazon.disco.instrumentation.preprocess.cli.PreprocessConfig;
import software.amazon.disco.instrumentation.preprocess.exceptions.InstrumentationException;
import software.amazon.disco.instrumentation.preprocess.exceptions.PreprocessCacheException;
import software.amazon.disco.instrumentation.preprocess.instrumentation.InstrumentationArtifact;
import software.amazon.disco.instrumentation.preprocess.instrumentation.InstrumentationOutcome;
import software.amazon.disco.instrumentation.preprocess.instrumentation.TransformationListener;
import software.amazon.disco.instrumentation.preprocess.loaders.agents.TransformerExtractor;
import software.amazon.disco.instrumentation.preprocess.loaders.classfiles.ClassFileLoader;
import software.amazon.disco.instrumentation.preprocess.loaders.classfiles.SourceInfo;
import software.amazon.disco.instrumentation.preprocess.util.JarSigningVerificationOutcome;

public class InstrumentationTask {
    private static final Logger log = LogManager.getLogger(InstrumentationTask.class);
    private final ClassFileLoader loader;
    private final Path sourcePath;
    private final PreprocessConfig config;
    private final String relativeOutputPath;
    private final List<String> warnings = new ArrayList<String>();

    protected InstrumentationOutcome applyInstrumentation() throws PreprocessCacheException {
        SourceInfo sourceInfo = this.loader.load(this.sourcePath, this.config);
        InstrumentationOutcome.InstrumentationOutcomeBuilder builder = InstrumentationOutcome.builder().sourcePath(this.sourcePath.toString());
        if (sourceInfo != null && !sourceInfo.getClassByteCodeMap().isEmpty()) {
            File artifact;
            log.debug("Disco(Instrumentation preprocess) - Applying transformation on: " + sourceInfo.getSourceFile().getAbsolutePath());
            log.debug("Disco(Instrumentation preprocess) - Classes found: " + sourceInfo.getClassByteCodeMap().size());
            for (Map.Entry<String, byte[]> entry : sourceInfo.getClassByteCodeMap().entrySet()) {
                this.applyInstrumentationOnClass(entry.getKey(), entry.getValue());
            }
            log.debug("Disco(Instrumentation preprocess) - " + this.getInstrumentationArtifacts().size() + " classes transformed");
            if (!this.getInstrumentationArtifacts().isEmpty() && sourceInfo.getJarSigningVerificationOutcome() != null) {
                if (sourceInfo.getJarSigningVerificationOutcome().equals((Object)JarSigningVerificationOutcome.SIGNED)) {
                    log.debug("Disco(Instrumentation preprocess) - Signed jar " + sourceInfo.getSourceFile().getName() + " instrumented");
                } else if (sourceInfo.getJarSigningVerificationOutcome().equals((Object)JarSigningVerificationOutcome.INVALID)) {
                    log.warn("Disco(Instrumentation preprocess) - Invalidly signed jar " + sourceInfo.getSourceFile().getName() + " instrumented");
                }
            }
            builder.artifactPath((artifact = sourceInfo.getExportStrategy().export(sourceInfo, this.getInstrumentationArtifacts(), this.config, this.relativeOutputPath)) == null ? "" : artifact.getAbsolutePath());
        }
        builder.sourceInfo(sourceInfo);
        if (!this.warnings.isEmpty()) {
            builder.status(InstrumentationOutcome.Status.WARNING_OCCURRED).failedClasses(this.warnings);
            log.warn("Disco(Instrumentation preprocess) - Skipped caching due to unexpected errors/warnings taking place.");
        } else {
            builder.status(this.getInstrumentationArtifacts().isEmpty() ? InstrumentationOutcome.Status.NO_OP : InstrumentationOutcome.Status.COMPLETED);
            if (sourceInfo != null && sourceInfo.getSourceFile().exists()) {
                this.config.getCacheStrategy().cacheSource(sourceInfo.getSourceFile().toPath());
            } else {
                log.warn("Disco(Instrumentation preprocess) - Skipped caching due to unexpected errors/warnings taking place.");
            }
        }
        this.clearInstrumentationArtifacts();
        return builder.build();
    }

    protected void applyInstrumentationOnClass(String classFileName, byte[] bytecode) {
        try {
            String nameWithoutPrefix = classFileName.startsWith("classes.") ? classFileName.substring(8) : classFileName;
            String internalName = nameWithoutPrefix.replace('.', '/');
            log.trace("Disco(Instrumentation preprocess) - Applying transformation on class: " + internalName);
            for (ClassFileTransformer transformer : TransformerExtractor.getTransformers()) {
                byte[] bytecodeToTransform = this.getInstrumentationArtifacts().containsKey(internalName) ? this.getInstrumentationArtifacts().get(internalName).getClassBytes() : bytecode;
                transformer.transform(ClassLoader.getSystemClassLoader(), nameWithoutPrefix, null, null, bytecodeToTransform);
            }
        }
        catch (IllegalClassFormatException e) {
            throw new InstrumentationException("Failed to instrument : " + classFileName, e);
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof IllegalStateException && !this.config.isFailOnUnresolvableDependency()) {
                log.warn("Disco(Instrumentation preprocess) - Failed to resolve dependency when instrumenting : " + classFileName, e);
                this.warnings.add(classFileName);
            }
            throw e;
        }
    }

    protected Map<String, InstrumentationArtifact> getInstrumentationArtifacts() {
        HashMap<String, InstrumentationArtifact> mergedMap = new HashMap<String, InstrumentationArtifact>();
        mergedMap.putAll(TransformationListener.getInstrumentedTypes());
        mergedMap.putAll(ResourcesClassInjector.getInjectedDependencies().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new InstrumentationArtifact((byte[])e.getValue()))));
        return mergedMap;
    }

    protected void clearInstrumentationArtifacts() {
        log.debug("Disco(Instrumentation preprocess) - Clearing build artifacts after processing: " + this.sourcePath);
        TransformationListener.getInstrumentedTypes().clear();
        ResourcesClassInjector.getInjectedDependencies().clear();
    }

    public InstrumentationTask(ClassFileLoader loader, Path sourcePath, PreprocessConfig config, String relativeOutputPath) {
        this.loader = loader;
        this.sourcePath = sourcePath;
        this.config = config;
        this.relativeOutputPath = relativeOutputPath;
    }
}

