/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.reflect.logging;

import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.agent.logging.LoggerFactory;

public class StandardOutputLoggerFactory
implements LoggerFactory {
    @Override
    public Logger createLogger(String name) {
        return new NameAwareStandardOutputLogger(name);
    }

    private static class NameAwareStandardOutputLogger
    implements Logger {
        private final String name;

        public NameAwareStandardOutputLogger(String name) {
            this.name = "[" + name + "] ";
        }

        @Override
        public void log(Logger.Level level, String message) {
            System.out.println(this.name + message);
        }

        @Override
        public void log(Logger.Level level, Throwable t) {
            this.log(level, t.toString());
        }

        @Override
        public void log(Logger.Level level, String message, Throwable t) {
            this.log(level, message + "\t" + t.toString());
        }
    }
}

