/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.matchers;

import java.util.HashMap;
import software.amazon.disco.agent.jar.bytebuddy.description.NamedElement;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatcher;

public class TrieNameMatcher<T extends NamedElement>
extends ElementMatcher.Junction.AbstractBase<T> {
    final Trie nameMatcher = new Trie();

    public TrieNameMatcher(String[] prefixes) {
        for (String item : prefixes) {
            this.nameMatcher.insert(item);
        }
    }

    @Override
    public boolean matches(T target) {
        return this.nameMatcher.prefixMatch(target.getActualName());
    }

    static class Trie {
        private final TrieNode root = new TrieNode();

        Trie() {
        }

        void insert(String word) {
            char[] chars;
            if (word == null || word.isEmpty()) {
                return;
            }
            TrieNode node = this.root;
            for (char aChar : chars = word.toCharArray()) {
                if (!node.containsKey(aChar)) {
                    node.put(aChar, new TrieNode());
                }
                node = node.get(aChar);
            }
        }

        boolean prefixMatch(String word) {
            return this.match(word, MatchType.PREFIX);
        }

        boolean exactMatch(String word) {
            return this.match(word, MatchType.EXACT);
        }

        private boolean match(String word, MatchType matchType) {
            char[] chars;
            if (word == null || word.isEmpty()) {
                return false;
            }
            TrieNode node = this.root;
            for (char aChar : chars = word.toCharArray()) {
                if (matchType.equals((Object)MatchType.PREFIX) && node.isLeaf()) {
                    return true;
                }
                if (!node.containsKey(aChar)) {
                    return false;
                }
                node = node.get(aChar);
            }
            return node.isLeaf();
        }

        static enum MatchType {
            PREFIX,
            EXACT;

        }

        static class TrieNode {
            private HashMap<Character, TrieNode> children = new HashMap();

            TrieNode() {
            }

            boolean containsKey(char ch) {
                return this.children.containsKey(Character.valueOf(ch));
            }

            TrieNode get(char ch) {
                return this.children.get(Character.valueOf(ch));
            }

            void put(char ch, TrieNode node) {
                this.children.put(Character.valueOf(ch), node);
            }

            boolean isLeaf() {
                return this.children.isEmpty();
            }
        }
    }
}

