/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.event;

import software.amazon.disco.agent.event.ServiceDownstreamRequestEvent;
import software.amazon.disco.agent.event.ServiceDownstreamResponseEvent;

public class HttpServiceDownstreamResponseEvent
extends ServiceDownstreamResponseEvent {
    public HttpServiceDownstreamResponseEvent(String origin, String service, String operation, ServiceDownstreamRequestEvent requestEvent) {
        super(origin, service, operation, requestEvent);
    }

    public HttpServiceDownstreamResponseEvent withStatusCode(int statusCode) {
        this.withData(DataKey.STATUS_CODE.name(), statusCode);
        return this;
    }

    public HttpServiceDownstreamResponseEvent withContentLength(long contentLength) {
        this.withData(DataKey.CONTENT_LENGTH.name(), contentLength);
        return this;
    }

    public int getStatusCode() {
        Object statusCode = this.getData(DataKey.STATUS_CODE.name());
        return statusCode == null ? -1 : (Integer)statusCode;
    }

    public long getContentLength() {
        Object contentLength = this.getData(DataKey.CONTENT_LENGTH.name());
        return contentLength == null ? -1L : (Long)contentLength;
    }

    static enum DataKey {
        STATUS_CODE,
        CONTENT_LENGTH;

    }
}

