/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.awsv2;

import software.amazon.awssdk.core.client.builder.SdkClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.disco.agent.awsv2.DiscoExecutionInterceptor;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.jar.bytebuddy.agent.builder.AgentBuilder;
import software.amazon.disco.agent.jar.bytebuddy.asm.Advice;
import software.amazon.disco.agent.jar.bytebuddy.description.method.MethodDescription;
import software.amazon.disco.agent.jar.bytebuddy.description.type.TypeDescription;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatcher;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.agent.plugin.ResourcesClassInjector;

public class AWSClientBuilderInterceptor
implements Installable {
    public static final Logger log = LogManager.getLogger(AWSClientBuilderInterceptor.class);

    public AgentBuilder install(AgentBuilder agentBuilder) {
        return agentBuilder.type(AWSClientBuilderInterceptor.buildClassMatcher()).transform((builder, typeDescription, classLoader, module) -> {
            ResourcesClassInjector.injectAllClasses((ClassLoader)classLoader, (ClassLoader)AWSClientBuilderInterceptor.class.getClassLoader(), (String[])new String[]{"software.amazon.disco.agent.awsv2.DiscoExecutionInterceptor", "software.amazon.disco.agent.event.AwsServiceDownstreamRequestEventImpl", "software.amazon.disco.agent.event.AwsServiceDownstreamResponseEventImpl"});
            return new AgentBuilder.Transformer.ForAdvice().include(new ClassLoader[]{this.getClass().getClassLoader()}).advice(AWSClientBuilderInterceptor.buildMethodMatcher(), this.getClass().getClasses()[0].getName()).transform(builder, typeDescription, classLoader, module);
        });
    }

    static ElementMatcher<? super TypeDescription> buildClassMatcher() {
        return ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)"software.amazon.awssdk.core.client.builder.SdkClientBuilder")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isInterface()));
    }

    static ElementMatcher<? super MethodDescription> buildMethodMatcher() {
        return ElementMatchers.named((String)"build").and((ElementMatcher)ElementMatchers.takesArguments((int)0)).and((ElementMatcher)ElementMatchers.isFinal()).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract()));
    }

    public static class AWSClientBuilderInterceptorAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void enter(@Advice.This SdkClientBuilder invoker, @Advice.Origin String origin) {
            if (LogManager.isDebugEnabled()) {
                log.debug("DiSCo(AWSv2) method interception of " + origin);
            }
            ClientOverrideConfiguration configuration = (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().addExecutionInterceptor((ExecutionInterceptor)new DiscoExecutionInterceptor()).build();
            invoker.overrideConfiguration(configuration);
        }
    }
}

