/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.disco.agent.event.AbstractEvent;
import software.amazon.disco.agent.event.ProtocolEvent;

public abstract class AbstractProtocolEvent
extends AbstractEvent
implements ProtocolEvent {
    public AbstractProtocolEvent(String origin) {
        super(origin);
        this.withData(DataKey.HEADER_MAP.name(), new HashMap());
    }

    protected Map<String, List<String>> getHeaderMap() {
        Map headerMap = (Map)this.getData(DataKey.HEADER_MAP.name());
        return headerMap;
    }

    public AbstractProtocolEvent withHeaderMap(Map<String, String> inputMap) {
        HashMap<String, List<String>> transformedInputMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : inputMap.entrySet()) {
            transformedInputMap.put(entry.getKey(), Collections.singletonList(entry.getValue()));
        }
        this.getHeaderMap().putAll(transformedInputMap);
        return this;
    }

    public AbstractProtocolEvent withHeaderData(String key, String value) {
        if (this.data == null) {
            return this;
        }
        Map<String, List<String>> headerMap = this.getHeaderMap();
        headerMap.put(key, Collections.singletonList(value));
        return this;
    }

    @Override
    @Deprecated
    public String getHeaderData(String key) {
        List<String> headers = this.getHeaderMap().get(key);
        return headers != null && !headers.isEmpty() ? headers.get(0) : null;
    }

    static enum DataKey {
        HEADER_MAP;

    }
}

