/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.reflect.logging;

import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.agent.logging.LoggerFactory;
import software.amazon.disco.agent.reflect.ReflectiveCall;

public class Logger {
    private static final String LOGMANAGER_CLASSNAME = ".logging.LogManager";
    private static boolean suppressIfAgentNotPresent = false;
    private static final String prefix = "DiSCo(Reflect) ";
    static software.amazon.disco.agent.logging.Logger log = ReflectiveCall.returning(software.amazon.disco.agent.logging.Logger.class).ofClass(".logging.LogManager").ofMethod("getLogger").withArgTypes(Class.class).call(Logger.class);

    public static void installLoggerFactory(LoggerFactory loggerFactory) {
        ReflectiveCall.returningVoid().ofClass(LOGMANAGER_CLASSNAME).ofMethod("installLoggerFactory").withArgTypes(LoggerFactory.class).call(loggerFactory);
    }

    public static void debug(String s) {
        Logger.maybeAccept(Logger.Level.DEBUG, s);
    }

    public static void info(String s) {
        Logger.maybeAccept(Logger.Level.INFO, s);
    }

    public static void warn(String s) {
        Logger.maybeAccept(Logger.Level.WARN, s);
    }

    public static void error(String s) {
        Logger.maybeAccept(Logger.Level.ERROR, s);
    }

    public static void suppressIfAgentNotPresent(boolean suppress) {
        suppressIfAgentNotPresent = suppress;
    }

    static void maybeAccept(Logger.Level level, String s) {
        boolean suppress;
        boolean bl = suppress = !ReflectiveCall.isAgentPresent() && suppressIfAgentNotPresent;
        if (suppress) {
            return;
        }
        if (log != null) {
            log.log(level, prefix + s);
        }
    }
}

