/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.utils;

import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.dynamodb.model.InternalServerErrorException;
import software.amazon.dax.com.amazon.cbor.EndOfStreamException;
import software.amazon.dax.exceptions.DaxServiceException;
import software.amazon.dax.exceptions.DecoderException;
import software.amazon.dax.exceptions.MalformedResultException;

public final class Utils {
    private static final int[] ERROR_CODE_SEQUENCE_FOR_IO_TIMEOUT_EXCEPTION = new int[]{1, 37, 38, 53};
    private static final int[] ERROR_CODE_SEQUENCE_FOR_DYNAMO_RESPONSE_DECODER_EXCEPTION = new int[]{1, 37, 38, 55};
    private static final int[] ERROR_CODE_SEQUENCE_FOR_DAX_INTERNAL_SERVER_ERROR = new int[]{3, 37, 54};

    private Utils() {
    }

    public static boolean isWriteFailureAmbiguous(Throwable e) {
        DaxServiceException dse;
        if (e instanceof DecoderException || e instanceof MalformedResultException) {
            return true;
        }
        if (e instanceof DaxServiceException && (Arrays.equals(ERROR_CODE_SEQUENCE_FOR_IO_TIMEOUT_EXCEPTION, (dse = (DaxServiceException)((Object)e)).getCodeSeq()) || Arrays.equals(ERROR_CODE_SEQUENCE_FOR_DYNAMO_RESPONSE_DECODER_EXCEPTION, dse.getCodeSeq()) || Arrays.equals(ERROR_CODE_SEQUENCE_FOR_DAX_INTERNAL_SERVER_ERROR, dse.getCodeSeq()))) {
            return true;
        }
        if (e instanceof InternalServerErrorException) {
            return true;
        }
        if (e instanceof SdkException) {
            SdkException ace = (SdkException)e;
            Throwable causedBy = ace.getCause();
            if (causedBy instanceof EndOfStreamException || causedBy instanceof SocketTimeoutException || causedBy instanceof SocketException && !(causedBy instanceof ConnectException) || causedBy instanceof IllegalStateException) {
                return true;
            }
            if (causedBy instanceof SdkException) {
                return Utils.isWriteFailureAmbiguous(causedBy);
            }
        }
        return e instanceof RuntimeException && !(e instanceof SdkException);
    }
}

