/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;
import software.amazon.dax.com.amazon.dax.client.HostPort;

public final class Configuration
implements ToCopyableBuilder<Builder, Configuration> {
    private static final int DEFAULT_IDLE_TIMEOUT_MS = 30000;
    private static final int DEFAULT_CONNECTION_TTL_MS = 0;
    private static final int DEFAULT_CONNECT_TIMEOUT_MS = 1000;
    private static final int DEFAULT_REQUEST_TIMEOUT_MS = 1000;
    private static final int DEFAULT_WRITE_RETRIES = 2;
    private static final int DEFAULT_READ_RETRIES = 2;
    private static final int DEFAULT_MAX_CONCURRENCY = 1000;
    private static final int DEFAULT_MAX_CONNECTION_ACQUIRES = 10000;
    private static final int DEFAULT_CLUSTER_UPDATE_INTERVAL_MS = 4000;
    private static final int DEFAULT_ENDPOINT_REFRESH_TIMEOUT_MS = 6000;
    private static final AwsCredentialsProvider DEFAULT_AWS_CREDENTIALS_PROVIDER = DefaultCredentialsProvider.create();
    private int idleTimeoutMillis = 30000;
    private int connectionTtlMillis = 0;
    private int connectTimeoutMillis = 1000;
    private int requestTimeoutMillis = 1000;
    private int writeRetries = 2;
    private int readRetries = 2;
    private int clusterUpdateIntervalMillis = 4000;
    private int endpointRefreshTimeoutMillis = 6000;
    private int maxConcurrency = 1000;
    private int maxPendingConnectionAcquires = 10000;
    private AwsCredentialsProvider credentialsProvider;
    private EventLoopGroup eventLoopGroup;
    private boolean ssl;
    private boolean skipHostNameVerification;
    private Region region;
    private String url;
    private String host;
    private int port;
    private List<MetricPublisher> metricPublishers = new ArrayList<MetricPublisher>();

    private Configuration() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public int idleTimeoutMillis() {
        return this.idleTimeoutMillis;
    }

    public int connectionTtlMillis() {
        return this.connectionTtlMillis;
    }

    public int connectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public int requestTimeoutMillis() {
        return this.requestTimeoutMillis;
    }

    public int writeRetries() {
        return this.writeRetries;
    }

    public int readRetries() {
        return this.readRetries;
    }

    public int clusterUpdateIntervalMillis() {
        return this.clusterUpdateIntervalMillis;
    }

    public int endpointRefreshTimeoutMillis() {
        return this.endpointRefreshTimeoutMillis;
    }

    public int maxConcurrency() {
        return this.maxConcurrency;
    }

    public int maxPendingConnectionAcquires() {
        return this.maxPendingConnectionAcquires;
    }

    public EventLoopGroup eventLoopGroup() {
        return this.eventLoopGroup;
    }

    public boolean ssl() {
        return this.ssl;
    }

    public boolean skipHostNameVerification() {
        return this.skipHostNameVerification;
    }

    public AwsCredentialsProvider credentialsProvider() {
        return this.credentialsProvider;
    }

    public Region region() {
        return this.region;
    }

    public String url() {
        return this.url;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public List<MetricPublisher> metricPublishers() {
        return this.metricPublishers;
    }

    public Builder toBuilder() {
        Builder builder = new Builder().idleTimeoutMillis(this.idleTimeoutMillis).connectionTtlMillis(this.connectionTtlMillis).connectTimeoutMillis(this.connectTimeoutMillis).requestTimeoutMillis(this.requestTimeoutMillis).writeRetries(this.writeRetries).readRetries(this.readRetries).clusterUpdateIntervalMillis(this.clusterUpdateIntervalMillis).endpointRefreshTimeoutMillis(this.endpointRefreshTimeoutMillis).maxConcurrency(this.maxConcurrency).maxPendingConnectionAcquires(this.maxPendingConnectionAcquires).eventLoopGroup(this.eventLoopGroup).ssl(this.ssl).skipHostNameVerification(this.skipHostNameVerification).credentialsProvider(this.credentialsProvider).region(this.region).host(this.host).port(this.port).url(this.url);
        this.metricPublishers.forEach(builder::addMetricPublisher);
        return builder;
    }

    private static EventLoopGroup getInstance() {
        return EventLoopGroupHolder.INSTANCE;
    }

    private static class EventLoopGroupHolder {
        private static final EventLoopGroup INSTANCE = new NioEventLoopGroup(0, new ThreadFactoryBuilder().threadNamePrefix("dax-NettyEventLoop").build());

        private EventLoopGroupHolder() {
        }
    }

    public static class Builder
    implements CopyableBuilder<Builder, Configuration> {
        private Configuration configuration = new Configuration();

        public Builder idleTimeoutMillis(int idleTimeoutMillis) {
            this.configuration.idleTimeoutMillis = idleTimeoutMillis;
            return this;
        }

        public Builder connectionTtlMillis(int connectionTtlMillis) {
            this.configuration.connectionTtlMillis = connectionTtlMillis;
            return this;
        }

        public Builder connectTimeoutMillis(int connectTimeoutMillis) {
            this.configuration.connectTimeoutMillis = connectTimeoutMillis;
            return this;
        }

        public Builder requestTimeoutMillis(int requestTimeoutMillis) {
            this.configuration.requestTimeoutMillis = requestTimeoutMillis;
            return this;
        }

        public Builder writeRetries(int writeRetries) {
            this.configuration.writeRetries = writeRetries;
            return this;
        }

        public Builder readRetries(int readRetries) {
            this.configuration.readRetries = readRetries;
            return this;
        }

        public Builder clusterUpdateIntervalMillis(int clusterUpdateIntervalMillis) {
            this.configuration.clusterUpdateIntervalMillis = clusterUpdateIntervalMillis;
            return this;
        }

        public Builder endpointRefreshTimeoutMillis(int endpointRefreshTimeoutMillis) {
            this.configuration.endpointRefreshTimeoutMillis = endpointRefreshTimeoutMillis;
            return this;
        }

        public Builder maxPendingConnectionAcquires(int maxPendingConnectionAcquires) {
            this.configuration.maxPendingConnectionAcquires = maxPendingConnectionAcquires;
            return this;
        }

        public Builder maxConcurrency(int maxConcurrency) {
            this.configuration.maxConcurrency = maxConcurrency;
            return this;
        }

        public Builder eventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.configuration.eventLoopGroup = eventLoopGroup;
            return this;
        }

        Builder ssl(boolean ssl) {
            this.configuration.ssl = ssl;
            return this;
        }

        public Builder skipHostNameVerification(boolean skipHostNameVerification) {
            this.configuration.skipHostNameVerification = skipHostNameVerification;
            return this;
        }

        public Builder credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            this.configuration.credentialsProvider = credentialsProvider;
            return this;
        }

        public Builder region(Region region) {
            this.configuration.region = region;
            return this;
        }

        public Builder url(String url) {
            if (url != null) {
                this.configuration.url = url;
                HostPort hostPort = HostPort.parse(url);
                this.configuration.ssl = hostPort.scheme().equals("daxs");
                this.configuration.host = hostPort.host();
                this.configuration.port = hostPort.port();
            }
            return this;
        }

        Builder host(String host) {
            this.configuration.host = host;
            return this;
        }

        Builder port(int port) {
            this.configuration.port = port;
            return this;
        }

        public Builder addMetricPublisher(MetricPublisher metricPublisher) {
            this.configuration.metricPublishers.add(metricPublisher);
            return this;
        }

        public Configuration build() {
            this.resolveEventLoopGroup();
            this.resolveRegion();
            this.resolveCredential();
            this.configuration.metricPublishers = Collections.unmodifiableList(this.configuration.metricPublishers);
            return this.configuration;
        }

        private void resolveRegion() {
            if (this.configuration.region == null) {
                this.configuration.region = DefaultAwsRegionProviderChain.builder().build().getRegion();
            }
        }

        private void resolveCredential() {
            if (this.configuration.credentialsProvider == null) {
                this.configuration.credentialsProvider = DEFAULT_AWS_CREDENTIALS_PROVIDER;
            }
            if (this.configuration.credentialsProvider.resolveCredentials() == null) {
                throw SdkClientException.create((String)"Couldn't resolve credential");
            }
        }

        private void resolveEventLoopGroup() {
            if (this.configuration.eventLoopGroup == null) {
                this.configuration.eventLoopGroup = Configuration.getInstance();
            }
        }
    }
}

