/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.model.AttributeAction;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.dax.dynamodb.AttributeValueUtil;
import software.amazon.dax.dynamodb.DynamoDBExpressionInfo;
import software.amazon.dax.dynamodb.RequestValidator;
import software.amazon.dax.exceptions.ExceptionTranslator;

public final class DynamoDBV1Converter {
    private static final String VALUE_PREFIX = ":val";
    private static final String NAME_PREFIX = "#key";

    private DynamoDBV1Converter() {
    }

    public static boolean isV1Request(UpdateItemRequest updateRequest) {
        return !DynamoDBV1Converter.isMapEmpty(updateRequest.expected()) || !DynamoDBV1Converter.isMapEmpty(updateRequest.attributeUpdates());
    }

    public static boolean isV1Request(QueryRequest queryRequest) {
        return !CollectionUtils.isNullOrEmpty((Collection)queryRequest.attributesToGet()) || !DynamoDBV1Converter.isMapEmpty(queryRequest.queryFilter()) || !DynamoDBV1Converter.isMapEmpty(queryRequest.keyConditions());
    }

    public static boolean isV1Request(ScanRequest scanRequest) {
        return !CollectionUtils.isNullOrEmpty((Collection)scanRequest.attributesToGet()) || !DynamoDBV1Converter.isMapEmpty(scanRequest.scanFilter());
    }

    public static boolean isV1Request(PutItemRequest putItemRequest) {
        return !DynamoDBV1Converter.isMapEmpty(putItemRequest.expected());
    }

    public static boolean isV1Request(DeleteItemRequest deleteItemRequest) {
        return !DynamoDBV1Converter.isMapEmpty(deleteItemRequest.expected());
    }

    public static boolean isV1Request(GetItemRequest getItemRequest) {
        return !CollectionUtils.isNullOrEmpty((Collection)getItemRequest.attributesToGet());
    }

    public static boolean isV1Request(KeysAndAttributes keysAndAttributes) {
        return !CollectionUtils.isNullOrEmpty((Collection)keysAndAttributes.attributesToGet());
    }

    public static DynamoDBExpressionInfo convertV1RequestToV2(GetItemRequest request) {
        HashMap<String, String> exprAttrName = new HashMap<String, String>();
        String projectionExpression = DynamoDBV1Converter.convertAttrToGetToProjExpr(request.hasAttributesToGet() ? request.attributesToGet() : null, exprAttrName);
        return new DynamoDBExpressionInfo.DynamoDBExpressionInfoBuilder().setProjectionExpression(projectionExpression).setExpressionAttributeNames(exprAttrName).createDynamoDBExpressionInfo();
    }

    public static DynamoDBExpressionInfo convertV1RequestToV2(UpdateItemRequest request) {
        HashMap<String, AttributeValue> exprAttrVal = new HashMap<String, AttributeValue>();
        HashMap<String, String> exprAttrName = new HashMap<String, String>();
        String updateExpression = null;
        String conditionExpression = null;
        if (!DynamoDBV1Converter.isMapEmpty(request.expected())) {
            conditionExpression = DynamoDBV1Converter.convertExpectedToCondExpr(request.expected(), request.conditionalOperatorAsString(), exprAttrVal, exprAttrName);
        }
        if (!DynamoDBV1Converter.isMapEmpty(request.attributeUpdates())) {
            updateExpression = DynamoDBV1Converter.convertUpdateAttributesToUpdateExpr(request.attributeUpdates(), exprAttrVal, exprAttrName);
        }
        return new DynamoDBExpressionInfo.DynamoDBExpressionInfoBuilder().setConditionExpression(conditionExpression).setUpdateExpression(updateExpression).setExpressionAttributeValues(exprAttrVal).setExpressionAttributeNames(exprAttrName).createDynamoDBExpressionInfo();
    }

    public static DynamoDBExpressionInfo convertV1RequestToV2(DeleteItemRequest request) {
        HashMap<String, AttributeValue> exprAttrVal = new HashMap<String, AttributeValue>();
        HashMap<String, String> exprAttrName = new HashMap<String, String>();
        String condExpr = DynamoDBV1Converter.convertExpectedToCondExpr(request.expected(), request.conditionalOperatorAsString(), exprAttrVal, exprAttrName);
        return new DynamoDBExpressionInfo.DynamoDBExpressionInfoBuilder().setConditionExpression(condExpr).setExpressionAttributeValues(exprAttrVal).setExpressionAttributeNames(exprAttrName).createDynamoDBExpressionInfo();
    }

    public static DynamoDBExpressionInfo convertV1RequestToV2(QueryRequest request) {
        HashMap<String, AttributeValue> exprAttrVal;
        HashMap<String, String> exprAttrName;
        String projectionExpression = request.projectionExpression();
        String keyConditionsExpression = request.keyConditionExpression();
        String filterExpression = request.filterExpression();
        HashMap<String, String> hashMap = exprAttrName = request.hasExpressionAttributeNames() ? request.expressionAttributeNames() : null;
        if (!(exprAttrName != null || CollectionUtils.isNullOrEmpty((Collection)request.attributesToGet()) && DynamoDBV1Converter.isMapEmpty(request.queryFilter()) && DynamoDBV1Converter.isMapEmpty(request.keyConditions()))) {
            exprAttrName = new HashMap();
        } else if (exprAttrName != null) {
            exprAttrName = new HashMap<String, String>(exprAttrName);
        }
        if (request.hasAttributesToGet()) {
            projectionExpression = DynamoDBV1Converter.convertAttrToGetToProjExpr(request.attributesToGet(), exprAttrName);
        }
        HashMap<String, AttributeValue> hashMap2 = exprAttrVal = request.hasExpressionAttributeValues() ? request.expressionAttributeValues() : null;
        if (!(exprAttrVal != null || DynamoDBV1Converter.isMapEmpty(request.keyConditions()) && DynamoDBV1Converter.isMapEmpty(request.queryFilter()))) {
            exprAttrVal = new HashMap();
        } else if (exprAttrVal != null) {
            exprAttrVal = new HashMap<String, AttributeValue>(exprAttrVal);
        }
        if (request.hasKeyConditions()) {
            keyConditionsExpression = DynamoDBV1Converter.convertKeyCondToExpr(request.keyConditions(), exprAttrVal, exprAttrName);
        }
        if (request.hasQueryFilter()) {
            filterExpression = DynamoDBV1Converter.convertFilterToExpression(request.queryFilter(), request.conditionalOperatorAsString(), exprAttrVal, exprAttrName);
        }
        return new DynamoDBExpressionInfo.DynamoDBExpressionInfoBuilder().setProjectionExpression(projectionExpression).setKeyConditionExpression(keyConditionsExpression).setFilterExpression(filterExpression).setExpressionAttributeValues(exprAttrVal).setExpressionAttributeNames(exprAttrName).createDynamoDBExpressionInfo();
    }

    public static DynamoDBExpressionInfo convertV1RequestToV2(ScanRequest request) {
        HashMap<String, String> exprAttrName = new HashMap<String, String>();
        HashMap<String, AttributeValue> exprAttrVal = new HashMap<String, AttributeValue>();
        String projectionExpression = null;
        String filterExpression = null;
        if (request.hasAttributesToGet()) {
            projectionExpression = DynamoDBV1Converter.convertAttrToGetToProjExpr(request.attributesToGet(), exprAttrName);
        }
        if (!DynamoDBV1Converter.isMapEmpty(request.scanFilter())) {
            filterExpression = DynamoDBV1Converter.convertFilterToExpression(request.scanFilter(), request.conditionalOperatorAsString(), exprAttrVal, exprAttrName);
        }
        return new DynamoDBExpressionInfo.DynamoDBExpressionInfoBuilder().setProjectionExpression(projectionExpression).setFilterExpression(filterExpression).setExpressionAttributeValues(exprAttrVal).setExpressionAttributeNames(exprAttrName).createDynamoDBExpressionInfo();
    }

    public static DynamoDBExpressionInfo convertV1RequestToV2(PutItemRequest request) {
        HashMap<String, AttributeValue> exprAttrVal = new HashMap<String, AttributeValue>();
        HashMap<String, String> exprAttrName = new HashMap<String, String>();
        String condExpr = DynamoDBV1Converter.convertExpectedToCondExpr(request.expected(), request.conditionalOperatorAsString(), exprAttrVal, exprAttrName);
        return new DynamoDBExpressionInfo.DynamoDBExpressionInfoBuilder().setConditionExpression(condExpr).setExpressionAttributeValues(exprAttrVal).setExpressionAttributeNames(exprAttrName).createDynamoDBExpressionInfo();
    }

    public static DynamoDBExpressionInfo convertV1RequestToV2(KeysAndAttributes request) {
        HashMap<String, String> exprAttrName = new HashMap<String, String>();
        String projectionExpression = DynamoDBV1Converter.convertAttrToGetToProjExpr(request.hasAttributesToGet() ? request.attributesToGet() : null, exprAttrName);
        return new DynamoDBExpressionInfo.DynamoDBExpressionInfoBuilder().setProjectionExpression(projectionExpression).setExpressionAttributeNames(exprAttrName).createDynamoDBExpressionInfo();
    }

    private static <T, V> boolean isMapEmpty(Map<T, V> map) {
        return null == map || map.isEmpty();
    }

    private static <T> void convertToExpressionAttributeString(StringBuilder sb, Iterable<T> attrs, String prefix, String delimiter, Map<String, T> eans) {
        boolean addDelimiter = false;
        for (T attr : attrs) {
            String exprName = DynamoDBV1Converter.appendToExpAttrMap(attr, eans, prefix);
            if (addDelimiter) {
                sb.append(delimiter);
            } else {
                addDelimiter = true;
            }
            sb.append(exprName);
        }
    }

    public static String convertAttrToGetToProjExpr(List<String> attrToGet, Map<String, String> newExpressionAttributeNames) {
        if (attrToGet == null) {
            throw new IllegalArgumentException("attrToGet cannot be null");
        }
        StringBuilder sb = new StringBuilder();
        DynamoDBV1Converter.convertToExpressionAttributeString(sb, attrToGet, NAME_PREFIX, ",", newExpressionAttributeNames);
        return sb.toString();
    }

    private static String getOrDefaultCondition(String condOperator) {
        if (condOperator == null) {
            return "AND";
        }
        return condOperator;
    }

    public static String convertFilterToExpression(Map<String, Condition> filter, String condOperator, Map<String, AttributeValue> eAttrVal, Map<String, String> eAttrName) {
        StringBuilder sb = new StringBuilder();
        boolean b = false;
        condOperator = DynamoDBV1Converter.getOrDefaultCondition(condOperator);
        for (Map.Entry<String, Condition> entry : filter.entrySet()) {
            if (entry.getValue() == null) continue;
            if (b) {
                sb.append(' ').append(condOperator).append(' ');
            } else {
                b = true;
            }
            DynamoDBV1Converter.encodeToFilterExpression(sb, entry.getKey(), entry.getValue(), eAttrVal, eAttrName);
        }
        if (sb.toString().isEmpty()) {
            return null;
        }
        return sb.toString();
    }

    private static void encodeToFilterExpression(StringBuilder sb, String keyName, Condition condition, Map<String, AttributeValue> eAttrVal, Map<String, String> eAttrName) {
        String eName = DynamoDBV1Converter.appendToExpAttrMap(keyName, eAttrName, NAME_PREFIX);
        String compOp = condition.comparisonOperatorAsString();
        RequestValidator.validateComparisonOperator(compOp, keyName);
        List avl = condition.hasAttributeValueList() ? condition.attributeValueList() : null;
        DynamoDBV1Converter.constructFilterOrExpectedCompOpExpression(sb, compOp, eName, keyName, avl, eAttrVal, "Unsupported operator on ExpectedAttributeValue: " + condition);
    }

    private static void constructFilterOrExpectedCompOpExpression(StringBuilder sb, String compOp, String eName, String keyName, List<AttributeValue> avl, Map<String, AttributeValue> eAttrVal, String errorMessage) {
        String op;
        switch (ComparisonOperator.fromValue((String)compOp)) {
            case BETWEEN: {
                DynamoDBV1Converter.handleBetweenCondition(sb, compOp, eName, avl, eAttrVal, keyName);
                return;
            }
            case BEGINS_WITH: {
                DynamoDBV1Converter.handleBeginsWithCondition(sb, compOp, eName, avl, eAttrVal, keyName);
                return;
            }
            case NOT_CONTAINS: {
                sb.append("attribute_exists(").append(eName).append(") AND NOT ");
                DynamoDBV1Converter.handleContainsCondition(sb, compOp, eName, avl, eAttrVal, keyName);
                return;
            }
            case CONTAINS: {
                DynamoDBV1Converter.handleContainsCondition(sb, compOp, eName, avl, eAttrVal, keyName);
                return;
            }
            case NOT_NULL: {
                DynamoDBV1Converter.checkNumArguments(compOp, 0, avl, keyName);
                sb.append("attribute_exists(").append(eName).append(")");
                return;
            }
            case NULL: {
                DynamoDBV1Converter.checkNumArguments(compOp, 0, avl, keyName);
                sb.append("attribute_not_exists(").append(eName).append(")");
                return;
            }
            case IN: {
                DynamoDBV1Converter.handleInCondition(sb, compOp, eName, keyName, avl, eAttrVal);
                return;
            }
            case EQ: {
                op = "=";
                break;
            }
            case LE: {
                op = "<=";
                break;
            }
            case LT: {
                op = "<";
                break;
            }
            case GE: {
                op = ">=";
                break;
            }
            case GT: {
                op = ">";
                break;
            }
            case NE: {
                op = "<>";
                break;
            }
            default: {
                throw new IllegalArgumentException(errorMessage);
            }
        }
        DynamoDBV1Converter.checkNumArguments(compOp, 1, avl, keyName);
        AttributeValue av1 = avl.get(0);
        DynamoDBV1Converter.checkValidBSNType(compOp, av1);
        String eav0 = DynamoDBV1Converter.appendToExpAttrMap(av1, eAttrVal, VALUE_PREFIX);
        sb.append(eName).append(' ').append(op).append(' ').append(eav0);
    }

    public static String convertExpectedToCondExpr(Map<String, ExpectedAttributeValue> expected, String condOperator, Map<String, AttributeValue> eAttrVal, Map<String, String> eAttrName) {
        StringBuilder sb = new StringBuilder();
        boolean b = false;
        condOperator = DynamoDBV1Converter.getOrDefaultCondition(condOperator);
        for (Map.Entry<String, ExpectedAttributeValue> entry : expected.entrySet()) {
            if (b) {
                sb.append(' ').append(condOperator).append(' ');
            } else {
                b = true;
            }
            DynamoDBV1Converter.encodeConditionExpression(sb, entry.getKey(), entry.getValue(), eAttrVal, eAttrName);
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    private static void encodeConditionExpression(StringBuilder sb, String keyName, ExpectedAttributeValue eav, Map<String, AttributeValue> eAttrVal, Map<String, String> eAttrName) {
        List<AttributeValue> avl;
        if (eav == null) {
            return;
        }
        String eName = DynamoDBV1Converter.appendToExpAttrMap(keyName, eAttrName, NAME_PREFIX);
        String compOp = eav.comparisonOperatorAsString();
        if (compOp == null) {
            DynamoDBV1Converter.handleExistsCriteria(sb, keyName, eav, eName, eAttrVal, eAttrName);
            return;
        }
        if (eav.exists() != null) {
            throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: Exists and ComparisonOperator cannot be used together for Attribute: " + keyName);
        }
        List<AttributeValue> list = avl = eav.hasAttributeValueList() ? eav.attributeValueList() : null;
        if (avl == null) {
            if (eav.value() != null) {
                avl = Arrays.asList(eav.value());
            }
        } else if (eav.value() != null) {
            throw ExceptionTranslator.createValidationException("Value and AttributeValueList cannot be used together for Attribute: " + keyName);
        }
        DynamoDBV1Converter.constructFilterOrExpectedCompOpExpression(sb, compOp, eName, keyName, avl, eAttrVal, "Unsupported operator on ExpectedAttributeValue: " + eav);
    }

    public static String convertUpdateAttributesToUpdateExpr(Map<String, AttributeValueUpdate> attrValUpdates, Map<String, AttributeValue> exprAttrValues, Map<String, String> exprAttrNames) {
        ArrayList<String> sets = new ArrayList<String>();
        ArrayList<String> adds = new ArrayList<String>();
        ArrayList<String> deletes = new ArrayList<String>();
        ArrayList<String> removes = new ArrayList<String>();
        block7: for (Map.Entry<String, AttributeValueUpdate> entry : attrValUpdates.entrySet()) {
            String attributeName = entry.getKey();
            AttributeValueUpdate update = entry.getValue();
            if (update == null) continue;
            String actionString = update.actionAsString() != null ? update.actionAsString() : "PUT";
            AttributeAction action = null;
            try {
                action = AttributeAction.fromValue((String)actionString);
                if (action == AttributeAction.UNKNOWN_TO_SDK_VERSION) {
                    throw new IllegalArgumentException("Cannot create enum belonging to [ADD, DELETE, PUT] from " + actionString + " value!");
                }
            }
            catch (IllegalArgumentException e) {
                throw ExceptionTranslator.createValidationException("Member must satisfy enum value set: [ADD, DELETE, PUT]");
            }
            if (update.value() == null && action != AttributeAction.DELETE) {
                throw ExceptionTranslator.createValidationException("Only DELETE action is allowed when no attribute value is specified");
            }
            switch (action) {
                case PUT: {
                    String putExpression = DynamoDBV1Converter.appendToExpAttrMap(attributeName, exprAttrNames, NAME_PREFIX) + " = " + DynamoDBV1Converter.appendToExpAttrMap(update.value(), exprAttrValues, VALUE_PREFIX);
                    sets.add(putExpression);
                    continue block7;
                }
                case ADD: {
                    String addExpression = DynamoDBV1Converter.appendToExpAttrMap(attributeName, exprAttrNames, NAME_PREFIX) + " " + DynamoDBV1Converter.appendToExpAttrMap(update.value(), exprAttrValues, VALUE_PREFIX);
                    adds.add(addExpression);
                    continue block7;
                }
                case DELETE: {
                    String deleteExpression;
                    if (update.value() != null) {
                        deleteExpression = DynamoDBV1Converter.appendToExpAttrMap(attributeName, exprAttrNames, NAME_PREFIX) + " " + DynamoDBV1Converter.appendToExpAttrMap(update.value(), exprAttrValues, VALUE_PREFIX);
                        deletes.add(deleteExpression);
                        continue block7;
                    }
                    deleteExpression = DynamoDBV1Converter.appendToExpAttrMap(attributeName, exprAttrNames, NAME_PREFIX);
                    removes.add(deleteExpression);
                    continue block7;
                }
            }
            throw ExceptionTranslator.createValidationException("Invalid action passed : " + actionString);
        }
        StringBuilder updateExpression = new StringBuilder();
        if (!sets.isEmpty()) {
            DynamoDBV1Converter.generateAndAppendUpdateExpression(sets, "SET", updateExpression);
        }
        if (!adds.isEmpty()) {
            if (updateExpression.length() != 0) {
                updateExpression.append(" ");
            }
            DynamoDBV1Converter.generateAndAppendUpdateExpression(adds, "ADD", updateExpression);
        }
        if (!deletes.isEmpty()) {
            if (updateExpression.length() != 0) {
                updateExpression.append(" ");
            }
            DynamoDBV1Converter.generateAndAppendUpdateExpression(deletes, "DELETE", updateExpression);
        }
        if (!removes.isEmpty()) {
            if (updateExpression.length() != 0) {
                updateExpression.append(" ");
            }
            DynamoDBV1Converter.generateAndAppendUpdateExpression(removes, "REMOVE", updateExpression);
        }
        return updateExpression.toString();
    }

    private static void generateAndAppendUpdateExpression(List<String> list, String operation, StringBuilder updateExpression) {
        updateExpression.append(operation).append(" ").append(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            updateExpression.append(", ").append(list.get(i));
        }
    }

    public static String convertKeyCondToExpr(Map<String, Condition> keyConds, Map<String, AttributeValue> eAttrVal, Map<String, String> eAttrNames) {
        StringBuilder sb = new StringBuilder();
        boolean b = false;
        for (Map.Entry<String, Condition> entry : keyConds.entrySet()) {
            if (b) {
                sb.append(' ').append("AND").append(' ');
            } else {
                b = true;
            }
            DynamoDBV1Converter.encodeKeyConditions(sb, entry.getKey(), entry.getValue(), eAttrVal, eAttrNames);
        }
        return sb.toString();
    }

    private static void encodeKeyConditions(StringBuilder sb, String keyName, Condition cond, Map<String, AttributeValue> eAttrVal, Map<String, String> eAttrNames) {
        String op;
        if (null == cond) {
            throw ExceptionTranslator.createValidationException("KeyCondition cannot be null for key: " + keyName);
        }
        String compOp = cond.comparisonOperatorAsString();
        if (null == compOp || compOp.trim().length() == 0) {
            throw ExceptionTranslator.createValidationException("ComparisonOperator cannot be empty for KeyCondition: " + cond);
        }
        List avl = cond.hasAttributeValueList() ? cond.attributeValueList() : null;
        String ean0 = DynamoDBV1Converter.appendToExpAttrMap(keyName, eAttrNames, NAME_PREFIX);
        switch (ComparisonOperator.fromValue((String)compOp)) {
            case BETWEEN: {
                DynamoDBV1Converter.handleBetweenCondition(sb, compOp, ean0, avl, eAttrVal, keyName);
                return;
            }
            case BEGINS_WITH: {
                DynamoDBV1Converter.handleBeginsWithCondition(sb, compOp, ean0, avl, eAttrVal, keyName);
                return;
            }
            case EQ: {
                op = "=";
                break;
            }
            case LE: {
                op = "<=";
                break;
            }
            case LT: {
                op = "<";
                break;
            }
            case GE: {
                op = ">=";
                break;
            }
            case GT: {
                op = ">";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operator on KeyCondition: " + cond);
            }
        }
        DynamoDBV1Converter.checkNumArguments(compOp, 1, avl, keyName);
        String eav0 = DynamoDBV1Converter.appendToExpAttrMap((AttributeValue)avl.get(0), eAttrVal, VALUE_PREFIX);
        sb.append(ean0).append(' ').append(op).append(' ').append(eav0);
    }

    private static void handleBetweenCondition(StringBuilder sb, String compOp, String eName, List<AttributeValue> avl, Map<String, AttributeValue> eAttrVal, String keyName) {
        DynamoDBV1Converter.checkNumArguments(compOp, 2, avl, keyName);
        AttributeValue av1 = avl.get(0);
        AttributeValue av2 = avl.get(1);
        DynamoDBV1Converter.checkValidBSNType(compOp, av1, av2);
        DynamoDBV1Converter.checkValidBounds(av1, av2);
        String eav0 = DynamoDBV1Converter.appendToExpAttrMap(av1, eAttrVal, VALUE_PREFIX);
        String eav1 = DynamoDBV1Converter.appendToExpAttrMap(av2, eAttrVal, VALUE_PREFIX);
        sb.append(eName).append(" between ").append(eav0).append(" AND ").append(eav1);
    }

    private static void handleBeginsWithCondition(StringBuilder sb, String compOp, String eName, List<AttributeValue> avl, Map<String, AttributeValue> eAttrVal, String keyName) {
        DynamoDBV1Converter.checkNumArguments(compOp, 1, avl, keyName);
        AttributeValue av1 = avl.get(0);
        if (av1.b() == null && av1.s() == null) {
            throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: ComparisonOperator " + compOp + " is not valid for " + DynamoDBV1Converter.getAttributeValueType(av1) + " AttributeValue type");
        }
        String eav0 = DynamoDBV1Converter.appendToExpAttrMap(avl.get(0), eAttrVal, VALUE_PREFIX);
        sb.append("begins_with(").append(eName).append(", ").append(eav0).append(")");
    }

    private static void handleContainsCondition(StringBuilder sb, String compOp, String eName, List<AttributeValue> avl, Map<String, AttributeValue> eAttrVal, String keyName) {
        DynamoDBV1Converter.checkNumArguments(compOp, 1, avl, keyName);
        AttributeValue av1 = avl.get(0);
        DynamoDBV1Converter.checkValidBSNBoolNullTypes(compOp, av1);
        String eav0 = DynamoDBV1Converter.appendToExpAttrMap(avl.get(0), eAttrVal, VALUE_PREFIX);
        sb.append("contains(").append(eName).append(", ").append(eav0).append(")");
    }

    private static void handleInCondition(StringBuilder sb, String compOp, String eName, String keyName, List<AttributeValue> avl, Map<String, AttributeValue> eAttrVal) {
        if (avl == null) {
            throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: Value or AttributeValueList must be used with ComparisonOperator: IN for Attribute: " + keyName);
        }
        if (avl.isEmpty()) {
            throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: Invalid number of argument(s) for the IN ComparisonOperator");
        }
        DynamoDBV1Converter.checkValidBSNType(compOp, avl.toArray(new AttributeValue[avl.size()]));
        sb.append(eName).append(" IN (");
        DynamoDBV1Converter.convertToExpressionAttributeString(sb, avl, VALUE_PREFIX, ",", eAttrVal);
        sb.append(")");
    }

    private static void handleExistsCriteria(StringBuilder sb, String keyName, ExpectedAttributeValue eav, String eName, Map<String, AttributeValue> eAttrVal, Map<String, String> eAttrName) {
        if (eav.exists() != null || eav.value() != null) {
            if (eav.exists() == null || eav.exists().booleanValue()) {
                if (eav.hasAttributeValueList()) {
                    throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: AttributeValueList can only be used with a ComparisonOperator for Attribute: " + keyName);
                }
                if (eav.value() == null) {
                    throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: Value must be provided when Exists is true for Attribute: " + keyName);
                }
                String eav0 = DynamoDBV1Converter.appendToExpAttrMap(eav.value(), eAttrVal, VALUE_PREFIX);
                sb.append(eName).append(" = ").append(eav0);
            } else {
                if (eav.value() != null) {
                    throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: Value cannot be used when Exists is false for Attribute: " + keyName);
                }
                if (eav.hasAttributeValueList()) {
                    throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: AttributeValueList can only be used with a ComparisonOperator for Attribute: " + keyName);
                }
                sb.append("attribute_not_exists(").append(eName).append(")");
            }
            return;
        }
        if (eav.hasAttributeValueList()) {
            throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: AttributeValueList can only be used with a ComparisonOperator for Attribute: " + keyName);
        }
        throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: Value must be provided when Exists is null for Attribute: " + keyName);
    }

    private static void checkNumArguments(String compOp, int expectedArgs, List<AttributeValue> avl, String keyName) {
        int size;
        int n = size = avl == null ? 0 : avl.size();
        if (avl == null && expectedArgs > 0) {
            throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: Value or AttributeValueList must be used with ComparisonOperator: " + compOp + " for Attribute: " + keyName);
        }
        if (size != expectedArgs) {
            throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: Invalid number of argument(s) for the " + compOp + " ComparisonOperator");
        }
    }

    private static void checkValidBSNBoolNullTypes(String compOp, AttributeValue ... avs) {
        for (AttributeValue av : avs) {
            if (av.bool() != null || av.nul() != null) continue;
            DynamoDBV1Converter.checkValidBSNType(compOp, av);
        }
    }

    private static void checkValidBSNType(String compOp, AttributeValue ... avs) {
        if (compOp.equals("EQ") || compOp.equals("NE")) {
            return;
        }
        for (AttributeValue av : avs) {
            if (av.b() != null || av.s() != null || av.n() != null) continue;
            throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: ComparisonOperator " + compOp + " is not valid for " + DynamoDBV1Converter.getAttributeValueType(av) + " AttributeValue type");
        }
    }

    private static void checkValidBounds(AttributeValue lowerBound, AttributeValue upperBound) {
        Double doubleUpperBound;
        Double doubleLowerBound;
        software.amazon.dax.com.amazon.dax.bits.dynamodb.AttributeValue lb = AttributeValueUtil.from(lowerBound);
        software.amazon.dax.com.amazon.dax.bits.dynamodb.AttributeValue ub = AttributeValueUtil.from(upperBound);
        if (!lb.getType().equals(ub.getType())) {
            throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: AttributeValues inside AttributeValueList must be of same type");
        }
        if (lb.type == 1 ? lowerBound.s().compareTo(upperBound.s()) > 0 : lb.type == 2 && (doubleLowerBound = Double.valueOf(lowerBound.n())).compareTo(doubleUpperBound = Double.valueOf(upperBound.n())) > 0) {
            throw ExceptionTranslator.createValidationException("The BETWEEN condition was provided a range where the lower bound is greater than the upper bound");
        }
    }

    private static <T> String appendToExpAttrMap(T strVal, Map<String, T> exprAttributeMap, String prefix) {
        int suffix = exprAttributeMap.size();
        while (exprAttributeMap.containsKey(prefix + suffix)) {
            ++suffix;
        }
        exprAttributeMap.put(prefix + suffix, strVal);
        return prefix + suffix;
    }

    private static String getAttributeValueType(AttributeValue value) {
        return AttributeValueUtil.from(value).getType();
    }
}

