/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.services.dynamodb.model.Select;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;
import software.amazon.dax.com.amazon.dax.bits.dynamodb.DynamoNumerals;
import software.amazon.dax.exceptions.ExceptionTranslator;
import software.amazon.dax.expr.ExpressionValidationModel;

final class RequestValidator {
    private static final int MAX_EXPRESSION_SIZE = 4096;
    private static final int MAX_PARAMETER_MAP_KEY_SIZE = 255;
    private static final int MAX_PARAMETER_MAP_ENTRIES = 0x200000;
    private static final int MAX_READ_BATCH_SIZE = 100;
    private static final int BATCH_WRITE_MAX_ITEM_SIZE = 409600;
    private static final int MAX_ATTRIBUTENAME_SIZE = 65535;

    private RequestValidator() {
    }

    static void validateExpression(ExpressionValidationModel em) {
        int attrNameMapSize = 0;
        if (em.expressionAttributeNames() != null) {
            if (em.conditionExpression() == null && em.updateExpression() == null && em.projectionExpression() == null && em.filterExpression() == null && em.keyConditionExpression() == null) {
                throw RequestValidator.newValidationException("ExpressionAttributeNames can only be specified when using expressions");
            }
            attrNameMapSize = RequestValidator.validateExprAttrNames(em.expressionAttributeNames());
            if (attrNameMapSize > 0x200000) {
                throw RequestValidator.newValidationException("ExpressionAttributeNames exceeds max size");
            }
        }
        int attrValuesMapSize = 0;
        if (em.expressionAttributeValues() != null) {
            if (em.conditionExpression() == null && em.updateExpression() == null && em.filterExpression() == null && em.keyConditionExpression() == null) {
                throw RequestValidator.newValidationException("ExpressionAttributeValues can only be specified when using expressions");
            }
            attrValuesMapSize = RequestValidator.validateExprAttrValues(em.expressionAttributeValues());
            if (attrValuesMapSize > 0x200000) {
                throw RequestValidator.newValidationException("ExpressionAttributeValues exceeds max size");
            }
        }
        if (attrNameMapSize + attrValuesMapSize > 0x200000) {
            throw RequestValidator.newValidationException("Combined size of ExpressionAttributeNames and ExpressionAttributeValues exceeds max size");
        }
        if (em.expected() != null) {
            for (Map.Entry<String, ExpectedAttributeValue> e : em.expected().entrySet()) {
                String k = e.getKey();
                ExpectedAttributeValue v = e.getValue();
                if (v == null || v.value() == null || !v.hasAttributeValueList()) continue;
                throw RequestValidator.newValidationException("One or more parameter values were invalid: Value and AttributeValueList cannot be used together for Attribute: " + k);
            }
        }
        if (em.conditionExpression() != null || em.updateExpression() != null) {
            if (em.attributeUpdates() != null || em.conditionalOperator() != null || em.expected() != null) {
                throw ExceptionTranslator.createValidationException("Can not use both expression and non-expression parameters in the same request");
            }
            if (em.conditionExpression() != null) {
                if (em.conditionExpression().isEmpty()) {
                    throw RequestValidator.newValidationException("Invalid ConditionExpression: The expression can not be empty");
                }
                if (em.conditionExpression().length() > 4096) {
                    throw RequestValidator.newValidationException("Invalid ConditionExpression: Expression size has exceeded the maximum allowed size (4096)");
                }
            }
            if (em.updateExpression() != null) {
                if (em.updateExpression().isEmpty()) {
                    throw RequestValidator.newValidationException("Invalid UpdateExpression: The expression can not be empty");
                }
                if (em.updateExpression().length() > 4096) {
                    throw RequestValidator.newValidationException("Invalid UpdateExpression: Expression size has exceeded the maximum allowed size (4096)");
                }
            }
        }
        if (em.keyConditionExpression() != null) {
            if (em.keyConditionExpression().isEmpty()) {
                throw RequestValidator.newValidationException("Invalid KeyConditionExpression: The expression can not be empty");
            }
            if (em.keyConditionExpression().length() > 4096) {
                throw RequestValidator.newValidationException("Invalid KeyConditionExpression: Expression size has exceeded the maximum allowed size (4096)");
            }
        }
        if (em.projectionExpression() != null) {
            if (em.projectionExpression().isEmpty()) {
                throw RequestValidator.newValidationException("Invalid ProjectionExpression: The expression can not be empty");
            }
            if (RequestValidator.expressionLength(em.projectionExpression(), em.expressionAttributeNames()) > 4096) {
                throw RequestValidator.newValidationException("Invalid ProjectionExpression: Expression size has exceeded the maximum allowed size (4096)");
            }
        }
        if (em.filterExpression() != null) {
            if (em.filterExpression().isEmpty()) {
                throw RequestValidator.newValidationException("Invalid FilterExpression: The expression can not be empty");
            }
            if (em.filterExpression().length() > 4096) {
                throw RequestValidator.newValidationException("Invalid FilterExpression: Expression size has exceeded the maximum allowed size (4096)");
            }
        }
        if (em.projectionExpression() != null || em.filterExpression() != null || em.keyConditionExpression() != null) {
            String nonExprParams = null;
            String exprParams = null;
            if (em.projectionExpression() != null) {
                exprParams = RequestValidator.appendParameterName(exprParams, "ProjectionExpression");
            }
            if (em.filterExpression() != null) {
                exprParams = RequestValidator.appendParameterName(exprParams, "FilterExpression");
            }
            if (em.keyConditionExpression() != null) {
                exprParams = RequestValidator.appendParameterName(exprParams, "KeyConditionExpression");
            }
            if (em.attributesToGet() != null) {
                nonExprParams = RequestValidator.appendParameterName(nonExprParams, "AttributesToGet");
            }
            if (em.scanFilter() != null) {
                nonExprParams = RequestValidator.appendParameterName(nonExprParams, "ScanFilter");
            }
            if (em.queryFilter() != null) {
                nonExprParams = RequestValidator.appendParameterName(nonExprParams, "QueryFilter");
            }
            if (em.conditionalOperator() != null) {
                nonExprParams = RequestValidator.appendParameterName(nonExprParams, "ConditionalOperator");
            }
            if (em.keyConditionExpression() != null && em.keyConditions() != null) {
                nonExprParams = RequestValidator.appendParameterName(nonExprParams, "KeyConditions");
            }
            if (nonExprParams != null) {
                throw RequestValidator.newValidationException("Can not use both expression and non-expression parameters in the same request: Non-expression parameters: {" + nonExprParams + "} Expression parameters: {" + exprParams + "}");
            }
        }
        if (em.conditionalOperator() != null) {
            if (em.expected() == null && em.queryFilter() == null && em.scanFilter() == null) {
                throw ExceptionTranslator.createValidationException("ConditionalOperator cannot be used without Filter or Expected");
            }
            if (em.expected() != null && em.expected().size() <= 1 || em.queryFilter() != null && em.queryFilter().size() <= 1 || em.scanFilter() != null && em.scanFilter().size() <= 1) {
                throw ExceptionTranslator.createValidationException("ConditionalOperator can only be used when Filter or Expected has two or more elements");
            }
        }
    }

    private static int expressionLength(String expr, Map<String, String> subs) {
        if (expr == null) {
            return 0;
        }
        if (subs == null) {
            return expr.length();
        }
        int length = expr.length();
        for (Map.Entry<String, String> sub : subs.entrySet()) {
            String from = sub.getKey();
            String to = sub.getValue();
            if (from.isEmpty()) continue;
            String reduced = expr.replaceAll(from, "");
            int times = (expr.length() - reduced.length()) / from.length();
            length -= times * from.length();
            length += times * (to == null ? 0 : to.length());
            expr = reduced;
        }
        return length;
    }

    private static String appendParameterName(String params, String name) {
        return params == null ? name : params + ", " + name;
    }

    public static void validateCreateTableKeySchema(List<KeySchemaElement> keySchema) {
        if (keySchema == null) {
            throw ExceptionTranslator.createValidationException("No defined key schema.  A key schema containing at least a hash key must be defined for all tables");
        }
        if (keySchema.isEmpty()) {
            throw ExceptionTranslator.createValidationException("No Hash Key specified in schema.  All Dynamo DB tables must have exactly one hash key");
        }
        if (keySchema.size() == 1) {
            RequestValidator.validateNotNull(keySchema.get(0), "keySchema[0]");
            RequestValidator.validateNotNull(keySchema.get(0).keyTypeAsString(), "keySchema[0].keyType");
            if (!keySchema.get(0).keyTypeAsString().equals("HASH")) {
                throw ExceptionTranslator.createValidationException("1 validation error detected: Value 'hash' at 'keySchema.1.member.keyType' failed to satisfy constraint: Member must satisfy enum value set: [HASH, RANGE]");
            }
        } else if (keySchema.size() == 2) {
            String rangeKeyType;
            String hashKeyType;
            RequestValidator.validateNotNull(keySchema.get(0), "keySchema[0]");
            RequestValidator.validateNotNull(keySchema.get(1), "keySchema[1]");
            RequestValidator.validateNotNull(keySchema.get(0).keyTypeAsString(), "keySchema[0].keyType");
            RequestValidator.validateNotNull(keySchema.get(1).keyTypeAsString(), "keySchema[1].keyType");
            if (keySchema.get(0).keyTypeAsString().equals("HASH")) {
                hashKeyType = keySchema.get(0).keyTypeAsString();
                rangeKeyType = keySchema.get(1).keyTypeAsString();
            } else if (keySchema.get(0).keyTypeAsString().equals("RANGE")) {
                hashKeyType = keySchema.get(1).keyTypeAsString();
                rangeKeyType = keySchema.get(0).keyTypeAsString();
            } else {
                hashKeyType = keySchema.get(0).keyTypeAsString();
                rangeKeyType = keySchema.get(1).keyTypeAsString();
            }
            if (!hashKeyType.equals("HASH") && !rangeKeyType.equals("RANGE")) {
                throw ExceptionTranslator.createValidationException("2 validation errors detected: Value '" + hashKeyType + "' at 'keySchema.1.member.keyType' failed to satisfy constraint: Member must satisfy enum value set: [HASH, RANGE]; Value '" + rangeKeyType + "' at 'keySchema.2.member.keyType' failed to satisfy constraint: Member must satisfy enum value set: [HASH, RANGE]");
            }
            if (!hashKeyType.equals("HASH")) {
                throw ExceptionTranslator.createValidationException("1 validation error detected: Value '" + hashKeyType + "' at 'keySchema.1.member.keyType' failed to satisfy constraint: Member must satisfy enum value set: [HASH, RANGE]");
            }
            if (!rangeKeyType.equals("RANGE")) {
                throw ExceptionTranslator.createValidationException("1 validation error detected: Value '" + rangeKeyType + "' at 'keySchema.2.member.keyType' failed to satisfy constraint: Member must satisfy enum value set: [HASH, RANGE]");
            }
        } else {
            throw ExceptionTranslator.createValidationException(keySchema.size() + " validation errors detected: Value 'keySchema' failed to satisfy constraint: Member must have length less than or equal to 2");
        }
    }

    public static void validate(BatchGetItemRequest request) {
        Map requestItems = request.requestItems();
        if (!request.hasRequestItems()) {
            throw RequestValidator.newValidationException("1 validation error detected: Value null at 'requestItems' failed to satisfy constraint: Member must not be null");
        }
        boolean foundAttrsToGet = false;
        boolean foundProjExpr = false;
        boolean foundAttrNames = false;
        boolean isEmpty = true;
        int attrNamesMapSize = 0;
        int batchSize = 0;
        for (Map.Entry tableAndRequest : requestItems.entrySet()) {
            String tableName = (String)tableAndRequest.getKey();
            RequestValidator.validateTableName(tableName);
            KeysAndAttributes kaas = (KeysAndAttributes)tableAndRequest.getValue();
            if (kaas == null) {
                throw RequestValidator.newValidationException("Request can not be null for table " + tableName);
            }
            if (!kaas.hasKeys()) {
                throw RequestValidator.newValidationException("Keys can not be null for table " + tableName);
            }
            if (kaas.keys().isEmpty()) {
                throw RequestValidator.newValidationException("Keys can not be empty for table " + tableName);
            }
            if ((batchSize += kaas.keys().size()) > 100) {
                throw RequestValidator.newValidationException("Batch size should be less than 100");
            }
            List attrsToGet = kaas.hasAttributesToGet() ? kaas.attributesToGet() : null;
            String projExpr = kaas.projectionExpression();
            Map attrNames = kaas.hasExpressionAttributeNames() ? kaas.expressionAttributeNames() : null;
            RequestValidator.validateExpression(new ExpressionValidationModel().projectionExpression(projExpr).attributesToGet(attrsToGet).expressionAttributeNames(attrNames));
            isEmpty = false;
            foundAttrsToGet |= attrsToGet != null;
            foundProjExpr |= projExpr != null;
            if (attrNames != null) {
                foundAttrNames = true;
                if ((attrNamesMapSize += RequestValidator.validateExprAttrNames(attrNames)) > 0x200000) {
                    throw RequestValidator.newValidationException("ExpressionAttributeNames exceeds max size");
                }
            }
            if (!foundAttrsToGet || !foundProjExpr && !foundAttrNames) continue;
            throw RequestValidator.newValidationException("Can not use both expression and non-expression parameters in the same request");
        }
        if (isEmpty) {
            throw RequestValidator.newValidationException("1 validation error detected: Value null at 'requestItems' failed to satisfy constraint: Member must not be null");
        }
    }

    public static void checkAndThrowIfSelectIsInvalidForProjectionExpression(String projectionExpression, String select) {
        if (projectionExpression != null && select != null && !Select.SPECIFIC_ATTRIBUTES.equals((Object)Select.valueOf((String)select.trim()))) {
            throw ExceptionTranslator.createValidationException("Cannot specify the ProjectionExpression when selecet is not SPECIFIC_ATTRIBUTES");
        }
    }

    public static void validateComparisonOperator(String compOp, String keyName) {
        if (null == compOp) {
            throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: AttributeValueList can only be used with a ComparisonOperator for Attribute: " + keyName);
        }
    }

    public static void checkAndThrowIfSelectIsInvalidForAttributestoGet(List<String> attributesToGet, String select, String projectionExpression) {
        if (null != select) {
            if (Select.SPECIFIC_ATTRIBUTES.equals((Object)Select.valueOf((String)select.trim()))) {
                if (!(null != projectionExpression && projectionExpression.trim().length() >= 1 || null != attributesToGet && attributesToGet.size() >= 1)) {
                    throw ExceptionTranslator.createValidationException("Must specify the AttributesToGet or ProjectionExpression when choosing to get SPECIFIC_ATTRIBUTES");
                }
            } else if (null != attributesToGet) {
                throw ExceptionTranslator.createValidationException("Cannot specify the AttributesToGet when choosing to get " + select);
            }
        }
    }

    public static void validateCreateTableRequest(CreateTableRequest request) {
        RequestValidator.validateTableName(request.tableName());
        RequestValidator.validateCreateTableKeySchema(request.hasKeySchema() ? request.keySchema() : null);
        RequestValidator.validateAttributeDefinitions(request.hasAttributeDefinitions() ? request.attributeDefinitions() : null);
        RequestValidator.validateListNotEmpty(request.hasLocalSecondaryIndexes() ? request.localSecondaryIndexes() : null, "localSecondaryIndexList");
        RequestValidator.validate(request.provisionedThroughput());
    }

    public static void validateLocalSecondaryIndex(LocalSecondaryIndex lsi) {
        RequestValidator.validateNotNull(lsi, "localSecondaryIndex");
        RequestValidator.validateNotNull(lsi.projection(), "projection");
    }

    public static void validateGlobalSecondaryIndex(GlobalSecondaryIndex gsi) {
        RequestValidator.validateNotNull(gsi, "globalSecondaryIndex");
        RequestValidator.validate(gsi.provisionedThroughput());
        RequestValidator.validateNotNull(gsi.projection(), "projection");
    }

    public static void validateTableName(String tableName) {
        RequestValidator.validateTableName(tableName, "tableName");
    }

    public static void validateTableName(String tableName, String key) {
        if (tableName == null || tableName.isEmpty()) {
            throw RequestValidator.newValidationException("Value null at '" + key + "' failed to satisfy constraint: Member must not be null");
        }
    }

    public static void validateTableNameString(String tableName) {
        if (tableName == null) {
            throw ExceptionTranslator.createValidationException("Invalid table/index name. Table/index names must be between 3 and 255 characters long, and may contain only the characters a-z, A-Z, 0-9, '_', '-', and '.'");
        }
        int sz = (tableName = tableName.trim()).length();
        if (sz < 3 || sz > 255) {
            throw ExceptionTranslator.createValidationException("Invalid table/index name. Table/index names must be between 3 and 255 characters long, and may contain only the characters a-z, A-Z, 0-9, '_', '-', and '.'");
        }
        for (int i = 0; i < sz; ++i) {
            if (RequestValidator.isValid(tableName.charAt(i))) continue;
            throw ExceptionTranslator.createValidationException("Invalid table/index name. Table/index names must be between 3 and 255 characters long, and may contain only the characters a-z, A-Z, 0-9, '_', '-', and '.'");
        }
    }

    private static boolean isValid(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '.' || ch == '-';
    }

    public static void validate(ProvisionedThroughput pt) {
        if (pt != null) {
            RequestValidator.validateProvisionedThroughputValue("read", pt.readCapacityUnits());
            RequestValidator.validateProvisionedThroughputValue("write", pt.writeCapacityUnits());
        }
    }

    public static void validateLimit(Integer limit) {
        if (limit != null && limit <= 0) {
            throw ExceptionTranslator.createValidationException("Limit must be a positive integer");
        }
    }

    public static void validate(WriteRequest writeRequest) {
        if (writeRequest.putRequest() != null && writeRequest.deleteRequest() != null) {
            throw RequestValidator.newValidationException("Both delete and put request cannot be set");
        }
        if (writeRequest.putRequest() == null && writeRequest.deleteRequest() == null) {
            throw RequestValidator.newValidationException("Both delete and put request cannot be empty");
        }
    }

    private static void validateProvisionedThroughputValue(String direction, Long throughPut) {
        if (throughPut == null) {
            throw RequestValidator.newValidationException("1 validation error detected: Value null at 'provisionedThroughput' failed to satisfy constraint: Member must not be null");
        }
        if (throughPut < 1L) {
            throw RequestValidator.newValidationException("1 validation error detected: Value '" + throughPut + "' at 'provisionedThroughput." + direction + "CapacityUnits' failed to satisfy constraint: Member must have value greater than or equal to 1 ");
        }
    }

    static void validateReturnValue(ReturnValue rv, DynamoNumerals.Operation op) {
        if (rv != ReturnValue.NONE && rv != ReturnValue.ALL_OLD) {
            switch (op) {
                case CHECK: {
                    throw RequestValidator.newValidationException("ReturnValues can only be ALL_OLD or NONE: Check");
                }
                case PUT: {
                    throw RequestValidator.newValidationException("ReturnValues can only be ALL_OLD or NONE: Put");
                }
                case DELETE: {
                    throw RequestValidator.newValidationException("ReturnValues can only be ALL_OLD or NONE: Delete");
                }
            }
        }
    }

    static void validateKey(Map<String, AttributeValue> item, List<AttributeDefinition> keys) {
        if (item == null) {
            throw ExceptionTranslator.createValidationException("Value null at 'item' failed to satisfy constraint: Member must not be null");
        }
        int itemSize = item.size();
        if (itemSize != keys.size()) {
            throw ExceptionTranslator.createValidationException("The number of conditions on the keys is invalid");
        }
    }

    public static void validateTransactItem(Map<String, AttributeValue> item, String key) {
        if (item == null) {
            throw RequestValidator.newValidationException("1 validation error detected: Value " + null + " at '" + key + "' failed to satisfy constraint: Member must not be null");
        }
        if (item.isEmpty()) {
            throw RequestValidator.newValidationException("One or more parameter values were invalid: Missing the key id in the item");
        }
        RequestValidator.validateItem(item);
    }

    private static void validateItem(Map<String, AttributeValue> item) {
        for (Map.Entry<String, AttributeValue> entry : item.entrySet()) {
            if (entry.getKey() == null) {
                if (entry.getValue() != null) {
                    throw SdkClientException.builder().message("Unable to marshall request to JSON: Unable to marshall request to JSON: Unable to marshall request to JSON: Unable to marshall request to JSON").build();
                }
                item.remove(null);
            }
            RequestValidator.validateAttributeValue(entry.getValue());
        }
    }

    private static void validateAttributeValue(AttributeValue attr) {
        block7: {
            block10: {
                block9: {
                    block8: {
                        block6: {
                            if (attr == null) {
                                return;
                            }
                            if (!attr.hasSs()) break block6;
                            if (attr.ss().size() == 0) {
                                throw RequestValidator.newValidationException("One or more parameter values were invalid: An string set  may not be empty");
                            }
                            for (String s : attr.ss()) {
                                if (s != null) continue;
                                throw RequestValidator.newValidationException("One or more parameter values were invalid: An string set may not have a null string as a member");
                            }
                            break block7;
                        }
                        if (!attr.hasBs()) break block8;
                        if (attr.bs().size() == 0) {
                            throw RequestValidator.newValidationException("One or more parameter values were invalid: Binary sets should not be empty");
                        }
                        break block7;
                    }
                    if (!attr.hasNs()) break block9;
                    if (attr.ns().size() == 0) {
                        throw RequestValidator.newValidationException("One or more parameter values were invalid: An number set  may not be empty");
                    }
                    break block7;
                }
                if (!attr.hasM()) break block10;
                RequestValidator.validateItem(attr.m());
                break block7;
            }
            if (!attr.hasL()) break block7;
            for (AttributeValue av : attr.l()) {
                RequestValidator.validateAttributeValue(av);
            }
        }
    }

    public static void validateBatchWriteItem(Map<String, AttributeValue> item) {
        if (item == null || item.isEmpty()) {
            throw RequestValidator.newValidationException("1 validation error detected. Value " + item + " at 'item' failed to satisfy constraint: Item must not be null");
        }
        for (Map.Entry<String, AttributeValue> e : item.entrySet()) {
            int size = RequestValidator.simpleAttrValLength(e.getValue());
            if (size <= 409600) continue;
            throw RequestValidator.newValidationException("Item size has exceeded the maximum allowed size");
        }
    }

    public static void validateAttributeDefinitions(List<AttributeDefinition> attributeDefinitions) {
        if (attributeDefinitions == null || attributeDefinitions.isEmpty()) {
            throw RequestValidator.newValidationException("1 validation error detected. Value " + attributeDefinitions + " at 'attributeDefinitions' failed to satisfy constraint: The list must not be null or empty.");
        }
        for (AttributeDefinition attributeDefinition : attributeDefinitions) {
            RequestValidator.validateNotNull(attributeDefinition, "attributeDefinition");
            RequestValidator.validateStringNotNullOrEmpty(attributeDefinition.attributeName(), "attributeDefinition.attributeName");
            RequestValidator.validateNotNull(attributeDefinition.attributeType(), "attributeDefinition.attributeType");
        }
    }

    private static <T> void validateListNotEmpty(List<T> list, String listName) {
        if (list != null && list.isEmpty()) {
            throw RequestValidator.newValidationException("1 validation error detected. The list " + listName + "is empty. Failed to satisfy constraint: List must not be empty.");
        }
    }

    public static void validateNotNull(Object obj, String itemName) {
        if (obj == null) {
            throw RequestValidator.newValidationException("1 validation error detected. Value null at '" + itemName + "'. Failed to satisfy constraint: Item must not be null.");
        }
    }

    private static void validateStringNotNullOrEmpty(String str, String itemName) {
        if (str == null || str.isEmpty()) {
            throw RequestValidator.newValidationException("1 validation error detected. Value " + str + " at '" + itemName + "'. Failed to satisfy constraint: Item must not be null or empty.");
        }
    }

    private static int validateExprAttrNames(Map<String, String> attrNames) {
        int attrNameMapSize = 0;
        if (attrNames.isEmpty()) {
            throw RequestValidator.newValidationException("ExpressionAttributeNames must not be empty");
        }
        if (attrNames.size() >= 0x200000) {
            throw RequestValidator.newValidationException("ExpressionAttributeNames exceeds max size");
        }
        HashSet<String> attrs = new HashSet<String>();
        for (Map.Entry<String, String> e : attrNames.entrySet()) {
            String k = e.getKey();
            if (k == null) {
                throw SdkException.builder().message("ExpressionAttributeNames contains invalid key: null").build();
            }
            String v = e.getValue();
            if (!attrs.add(v)) {
                throw RequestValidator.newValidationException("Two document paths overlap with each other; must remove or rewrite one of these paths " + v);
            }
            attrNameMapSize += k.length();
            if (v == null) {
                attrNameMapSize += 0;
            } else {
                if (v.isEmpty()) {
                    throw RequestValidator.newValidationException("ExpressionAttributeNames contains invalid value: for key " + k);
                }
                if (v.length() > 65535) {
                    throw RequestValidator.newValidationException("Member must have length less than or equal to 65535, Member must have length greater than or equal to 0");
                }
                attrNameMapSize += v.length();
            }
            if (k.isEmpty()) {
                throw RequestValidator.newValidationException("ExpressionAttributeNames contains invalid key: The expression attribute map contains an empty key");
            }
            if (k.charAt(0) != '#') {
                throw RequestValidator.newValidationException("Syntax error, ExpressionAttributeNames contains invalid key: \"" + k + "\"");
            }
            if (k.length() > 255) {
                throw RequestValidator.newValidationException("ExpressionAttributeNames contains invalid key: The expression attribute map contains a key that is too long");
            }
            if (v != null && !v.isEmpty()) continue;
            throw RequestValidator.newValidationException("ExpressionAttributeNames must not be empty");
        }
        return attrNameMapSize;
    }

    private static int validateExprAttrValues(Map<String, AttributeValue> attrVals) {
        int attrValuesMapSize = 0;
        if (attrVals.isEmpty()) {
            throw RequestValidator.newValidationException("ExpressionAttributeValues must not be empty");
        }
        if (attrVals.size() >= 0x200000) {
            throw RequestValidator.newValidationException("ExpressionAttributeValues exceeds max size");
        }
        for (Map.Entry<String, AttributeValue> e : attrVals.entrySet()) {
            String k = e.getKey();
            if (k == null) {
                throw SdkException.builder().message("ExpressionAttributeValues contains invalid key: null").build();
            }
            attrValuesMapSize += k.length();
            attrValuesMapSize += RequestValidator.simpleAttrValLength(e.getValue());
            if (k.isEmpty()) {
                throw RequestValidator.newValidationException("ExpressionAttributeValues contains invalid key: The expression attribute map contains an empty key");
            }
            if (!k.startsWith(":")) {
                throw RequestValidator.newValidationException("Syntax error, ExpressionAttributeValues contains invalid key: \"" + k + "\"");
            }
            if (k.length() > 255) {
                throw RequestValidator.newValidationException("ExpressionAttributeValues contains invalid key: The expression attribute map contains a key that is too long");
            }
            RequestValidator.validateAttributeValue(e.getValue());
        }
        return attrValuesMapSize;
    }

    private static AwsServiceException newValidationException(String message) {
        return ExceptionTranslator.createValidationException(message);
    }

    private static int simpleAttrValLength(AttributeValue v) {
        if (v == null) {
            return 0;
        }
        if (v.s() != null) {
            return v.s().length();
        }
        if (v.b() != null) {
            return v.b().asByteArray().length;
        }
        if (v.n() != null) {
            return v.n().length();
        }
        if (v.hasBs()) {
            int size = 0;
            for (SdkBytes bb : v.bs()) {
                size += bb.asByteBuffer().limit();
            }
            return size;
        }
        return 0;
    }
}

