/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives;

import dafny.DafnySequence;
import java.nio.ByteBuffer;
import software.amazon.cryptography.primitives.AtomicPrimitives;
import software.amazon.cryptography.primitives.internaldafny.types.AESEncryptInput;
import software.amazon.cryptography.primitives.internaldafny.types.AES__CTR;
import software.amazon.cryptography.primitives.internaldafny.types.AES__GCM;
import software.amazon.cryptography.primitives.internaldafny.types.CompressPublicKeyInput;
import software.amazon.cryptography.primitives.internaldafny.types.CompressPublicKeyOutput;
import software.amazon.cryptography.primitives.internaldafny.types.CryptoConfig;
import software.amazon.cryptography.primitives.internaldafny.types.DecompressPublicKeyInput;
import software.amazon.cryptography.primitives.internaldafny.types.DeriveSharedSecretInput;
import software.amazon.cryptography.primitives.internaldafny.types.DigestInput;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPrivateKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPublicKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec;
import software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.ECDSAVerifyInput;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.types.Error_AwsCryptographicPrimitivesError;
import software.amazon.cryptography.primitives.internaldafny.types.Error_CollectionOfErrors;
import software.amazon.cryptography.primitives.internaldafny.types.Error_Opaque;
import software.amazon.cryptography.primitives.internaldafny.types.GenerateRSAKeyPairInput;
import software.amazon.cryptography.primitives.internaldafny.types.GenerateRSAKeyPairOutput;
import software.amazon.cryptography.primitives.internaldafny.types.GenerateRandomBytesInput;
import software.amazon.cryptography.primitives.internaldafny.types.GetPublicKeyFromPrivateKeyInput;
import software.amazon.cryptography.primitives.internaldafny.types.GetPublicKeyFromPrivateKeyOutput;
import software.amazon.cryptography.primitives.internaldafny.types.HMacInput;
import software.amazon.cryptography.primitives.internaldafny.types.HkdfExtractInput;
import software.amazon.cryptography.primitives.internaldafny.types.IAwsCryptographicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.ParsePublicKeyInput;
import software.amazon.cryptography.primitives.internaldafny.types.RSADecryptInput;
import software.amazon.cryptography.primitives.internaldafny.types.RSAPaddingMode;
import software.amazon.cryptography.primitives.internaldafny.types.ValidatePublicKeyInput;
import software.amazon.cryptography.primitives.model.AESDecryptInput;
import software.amazon.cryptography.primitives.model.AESEncryptInput;
import software.amazon.cryptography.primitives.model.AESEncryptOutput;
import software.amazon.cryptography.primitives.model.AES_CTR;
import software.amazon.cryptography.primitives.model.AES_GCM;
import software.amazon.cryptography.primitives.model.AesKdfCtrInput;
import software.amazon.cryptography.primitives.model.AwsCryptographicPrimitivesError;
import software.amazon.cryptography.primitives.model.CollectionOfErrors;
import software.amazon.cryptography.primitives.model.CompressPublicKeyInput;
import software.amazon.cryptography.primitives.model.CompressPublicKeyOutput;
import software.amazon.cryptography.primitives.model.CryptoConfig;
import software.amazon.cryptography.primitives.model.DecompressPublicKeyInput;
import software.amazon.cryptography.primitives.model.DecompressPublicKeyOutput;
import software.amazon.cryptography.primitives.model.DeriveSharedSecretInput;
import software.amazon.cryptography.primitives.model.DeriveSharedSecretOutput;
import software.amazon.cryptography.primitives.model.DigestAlgorithm;
import software.amazon.cryptography.primitives.model.DigestInput;
import software.amazon.cryptography.primitives.model.ECCPrivateKey;
import software.amazon.cryptography.primitives.model.ECCPublicKey;
import software.amazon.cryptography.primitives.model.ECDSASignInput;
import software.amazon.cryptography.primitives.model.ECDSAVerifyInput;
import software.amazon.cryptography.primitives.model.GenerateECCKeyPairInput;
import software.amazon.cryptography.primitives.model.GenerateECCKeyPairOutput;
import software.amazon.cryptography.primitives.model.GenerateECDSASignatureKeyInput;
import software.amazon.cryptography.primitives.model.GenerateECDSASignatureKeyOutput;
import software.amazon.cryptography.primitives.model.GenerateRSAKeyPairInput;
import software.amazon.cryptography.primitives.model.GenerateRSAKeyPairOutput;
import software.amazon.cryptography.primitives.model.GenerateRandomBytesInput;
import software.amazon.cryptography.primitives.model.GetPublicKeyFromPrivateKeyInput;
import software.amazon.cryptography.primitives.model.GetPublicKeyFromPrivateKeyOutput;
import software.amazon.cryptography.primitives.model.GetRSAKeyModulusLengthInput;
import software.amazon.cryptography.primitives.model.GetRSAKeyModulusLengthOutput;
import software.amazon.cryptography.primitives.model.HMacInput;
import software.amazon.cryptography.primitives.model.HkdfExpandInput;
import software.amazon.cryptography.primitives.model.HkdfExtractInput;
import software.amazon.cryptography.primitives.model.HkdfInput;
import software.amazon.cryptography.primitives.model.KdfCtrInput;
import software.amazon.cryptography.primitives.model.OpaqueError;
import software.amazon.cryptography.primitives.model.ParsePublicKeyInput;
import software.amazon.cryptography.primitives.model.ParsePublicKeyOutput;
import software.amazon.cryptography.primitives.model.RSADecryptInput;
import software.amazon.cryptography.primitives.model.RSAEncryptInput;
import software.amazon.cryptography.primitives.model.RSAPrivateKey;
import software.amazon.cryptography.primitives.model.RSAPublicKey;
import software.amazon.cryptography.primitives.model.ValidatePublicKeyInput;
import software.amazon.cryptography.primitives.model.ValidatePublicKeyOutput;
import software.amazon.smithy.dafny.conversion.ToNative;

public class ToNative {
    public static OpaqueError Error(Error_Opaque dafnyValue) {
        OpaqueError.Builder nativeBuilder = OpaqueError.builder();
        nativeBuilder.obj(dafnyValue.dtor_obj());
        return nativeBuilder.build();
    }

    public static CollectionOfErrors Error(Error_CollectionOfErrors dafnyValue) {
        CollectionOfErrors.Builder nativeBuilder = CollectionOfErrors.builder();
        nativeBuilder.list(ToNative.Aggregate.GenericToList(dafnyValue.dtor_list(), ToNative::Error));
        nativeBuilder.message(ToNative.Simple.String(dafnyValue.dtor_message()));
        return nativeBuilder.build();
    }

    public static AwsCryptographicPrimitivesError Error(Error_AwsCryptographicPrimitivesError dafnyValue) {
        AwsCryptographicPrimitivesError.Builder nativeBuilder = AwsCryptographicPrimitivesError.builder();
        nativeBuilder.message(ToNative.Simple.String(dafnyValue.dtor_message()));
        return nativeBuilder.build();
    }

    public static RuntimeException Error(Error dafnyValue) {
        if (dafnyValue.is_AwsCryptographicPrimitivesError()) {
            return ToNative.Error((Error_AwsCryptographicPrimitivesError)dafnyValue);
        }
        if (dafnyValue.is_Opaque()) {
            return ToNative.Error((Error_Opaque)dafnyValue);
        }
        if (dafnyValue.is_CollectionOfErrors()) {
            return ToNative.Error((Error_CollectionOfErrors)dafnyValue);
        }
        OpaqueError.Builder nativeBuilder = OpaqueError.builder();
        nativeBuilder.obj(dafnyValue);
        return nativeBuilder.build();
    }

    public static AES_CTR AES_CTR(AES__CTR dafnyValue) {
        AES_CTR.Builder nativeBuilder = AES_CTR.builder();
        nativeBuilder.keyLength(dafnyValue.dtor_keyLength());
        nativeBuilder.nonceLength(dafnyValue.dtor_nonceLength());
        return nativeBuilder.build();
    }

    public static AES_GCM AES_GCM(AES__GCM dafnyValue) {
        AES_GCM.Builder nativeBuilder = AES_GCM.builder();
        nativeBuilder.keyLength(dafnyValue.dtor_keyLength());
        nativeBuilder.tagLength(dafnyValue.dtor_tagLength());
        nativeBuilder.ivLength(dafnyValue.dtor_ivLength());
        return nativeBuilder.build();
    }

    public static AESDecryptInput AESDecryptInput(software.amazon.cryptography.primitives.internaldafny.types.AESDecryptInput dafnyValue) {
        AESDecryptInput.Builder nativeBuilder = AESDecryptInput.builder();
        nativeBuilder.encAlg(ToNative.AES_GCM(dafnyValue.dtor_encAlg()));
        nativeBuilder.key(ToNative.Simple.ByteBuffer(dafnyValue.dtor_key()));
        nativeBuilder.cipherTxt(ToNative.Simple.ByteBuffer(dafnyValue.dtor_cipherTxt()));
        nativeBuilder.authTag(ToNative.Simple.ByteBuffer(dafnyValue.dtor_authTag()));
        nativeBuilder.iv(ToNative.Simple.ByteBuffer(dafnyValue.dtor_iv()));
        nativeBuilder.aad(ToNative.Simple.ByteBuffer(dafnyValue.dtor_aad()));
        return nativeBuilder.build();
    }

    public static ByteBuffer AESDecryptOutput(DafnySequence<? extends Byte> dafnyValue) {
        return ToNative.Simple.ByteBuffer(dafnyValue);
    }

    public static software.amazon.cryptography.primitives.model.AESEncryptInput AESEncryptInput(AESEncryptInput dafnyValue) {
        AESEncryptInput.Builder nativeBuilder = software.amazon.cryptography.primitives.model.AESEncryptInput.builder();
        nativeBuilder.encAlg(ToNative.AES_GCM(dafnyValue.dtor_encAlg()));
        nativeBuilder.iv(ToNative.Simple.ByteBuffer(dafnyValue.dtor_iv()));
        nativeBuilder.key(ToNative.Simple.ByteBuffer(dafnyValue.dtor_key()));
        nativeBuilder.msg(ToNative.Simple.ByteBuffer(dafnyValue.dtor_msg()));
        nativeBuilder.aad(ToNative.Simple.ByteBuffer(dafnyValue.dtor_aad()));
        return nativeBuilder.build();
    }

    public static AESEncryptOutput AESEncryptOutput(software.amazon.cryptography.primitives.internaldafny.types.AESEncryptOutput dafnyValue) {
        AESEncryptOutput.Builder nativeBuilder = AESEncryptOutput.builder();
        nativeBuilder.cipherText(ToNative.Simple.ByteBuffer(dafnyValue.dtor_cipherText()));
        nativeBuilder.authTag(ToNative.Simple.ByteBuffer(dafnyValue.dtor_authTag()));
        return nativeBuilder.build();
    }

    public static AesKdfCtrInput AesKdfCtrInput(software.amazon.cryptography.primitives.internaldafny.types.AesKdfCtrInput dafnyValue) {
        AesKdfCtrInput.Builder nativeBuilder = AesKdfCtrInput.builder();
        nativeBuilder.ikm(ToNative.Simple.ByteBuffer(dafnyValue.dtor_ikm()));
        nativeBuilder.expectedLength(dafnyValue.dtor_expectedLength());
        if (dafnyValue.dtor_nonce().is_Some()) {
            nativeBuilder.nonce(ToNative.Simple.ByteBuffer(dafnyValue.dtor_nonce().dtor_value()));
        }
        return nativeBuilder.build();
    }

    public static ByteBuffer AesKdfCtrOutput(DafnySequence<? extends Byte> dafnyValue) {
        return ToNative.Simple.ByteBuffer(dafnyValue);
    }

    public static software.amazon.cryptography.primitives.model.CompressPublicKeyInput CompressPublicKeyInput(CompressPublicKeyInput dafnyValue) {
        CompressPublicKeyInput.Builder nativeBuilder = software.amazon.cryptography.primitives.model.CompressPublicKeyInput.builder();
        nativeBuilder.publicKey(ToNative.ECCPublicKey(dafnyValue.dtor_publicKey()));
        nativeBuilder.eccCurve(ToNative.ECDHCurveSpec(dafnyValue.dtor_eccCurve()));
        return nativeBuilder.build();
    }

    public static software.amazon.cryptography.primitives.model.CompressPublicKeyOutput CompressPublicKeyOutput(CompressPublicKeyOutput dafnyValue) {
        CompressPublicKeyOutput.Builder nativeBuilder = software.amazon.cryptography.primitives.model.CompressPublicKeyOutput.builder();
        nativeBuilder.compressedPublicKey(ToNative.Simple.ByteBuffer(dafnyValue.dtor_compressedPublicKey()));
        return nativeBuilder.build();
    }

    public static software.amazon.cryptography.primitives.model.CryptoConfig CryptoConfig(CryptoConfig dafnyValue) {
        CryptoConfig.Builder nativeBuilder = software.amazon.cryptography.primitives.model.CryptoConfig.builder();
        return nativeBuilder.build();
    }

    public static software.amazon.cryptography.primitives.model.DecompressPublicKeyInput DecompressPublicKeyInput(DecompressPublicKeyInput dafnyValue) {
        DecompressPublicKeyInput.Builder nativeBuilder = software.amazon.cryptography.primitives.model.DecompressPublicKeyInput.builder();
        nativeBuilder.compressedPublicKey(ToNative.Simple.ByteBuffer(dafnyValue.dtor_compressedPublicKey()));
        nativeBuilder.eccCurve(ToNative.ECDHCurveSpec(dafnyValue.dtor_eccCurve()));
        return nativeBuilder.build();
    }

    public static DecompressPublicKeyOutput DecompressPublicKeyOutput(software.amazon.cryptography.primitives.internaldafny.types.DecompressPublicKeyOutput dafnyValue) {
        DecompressPublicKeyOutput.Builder nativeBuilder = DecompressPublicKeyOutput.builder();
        nativeBuilder.publicKey(ToNative.ECCPublicKey(dafnyValue.dtor_publicKey()));
        return nativeBuilder.build();
    }

    public static software.amazon.cryptography.primitives.model.DeriveSharedSecretInput DeriveSharedSecretInput(DeriveSharedSecretInput dafnyValue) {
        DeriveSharedSecretInput.Builder nativeBuilder = software.amazon.cryptography.primitives.model.DeriveSharedSecretInput.builder();
        nativeBuilder.eccCurve(ToNative.ECDHCurveSpec(dafnyValue.dtor_eccCurve()));
        nativeBuilder.privateKey(ToNative.ECCPrivateKey(dafnyValue.dtor_privateKey()));
        nativeBuilder.publicKey(ToNative.ECCPublicKey(dafnyValue.dtor_publicKey()));
        return nativeBuilder.build();
    }

    public static DeriveSharedSecretOutput DeriveSharedSecretOutput(software.amazon.cryptography.primitives.internaldafny.types.DeriveSharedSecretOutput dafnyValue) {
        DeriveSharedSecretOutput.Builder nativeBuilder = DeriveSharedSecretOutput.builder();
        nativeBuilder.sharedSecret(ToNative.Simple.ByteBuffer(dafnyValue.dtor_sharedSecret()));
        return nativeBuilder.build();
    }

    public static software.amazon.cryptography.primitives.model.DigestInput DigestInput(DigestInput dafnyValue) {
        DigestInput.Builder nativeBuilder = software.amazon.cryptography.primitives.model.DigestInput.builder();
        nativeBuilder.digestAlgorithm(ToNative.DigestAlgorithm(dafnyValue.dtor_digestAlgorithm()));
        nativeBuilder.message(ToNative.Simple.ByteBuffer(dafnyValue.dtor_message()));
        return nativeBuilder.build();
    }

    public static ByteBuffer DigestOutput(DafnySequence<? extends Byte> dafnyValue) {
        return ToNative.Simple.ByteBuffer(dafnyValue);
    }

    public static software.amazon.cryptography.primitives.model.ECCPrivateKey ECCPrivateKey(ECCPrivateKey dafnyValue) {
        ECCPrivateKey.Builder nativeBuilder = software.amazon.cryptography.primitives.model.ECCPrivateKey.builder();
        nativeBuilder.pem(ToNative.Simple.ByteBuffer(dafnyValue.dtor_pem()));
        return nativeBuilder.build();
    }

    public static software.amazon.cryptography.primitives.model.ECCPublicKey ECCPublicKey(ECCPublicKey dafnyValue) {
        ECCPublicKey.Builder nativeBuilder = software.amazon.cryptography.primitives.model.ECCPublicKey.builder();
        nativeBuilder.der(ToNative.Simple.ByteBuffer(dafnyValue.dtor_der()));
        return nativeBuilder.build();
    }

    public static ECDSASignInput ECDSASignInput(software.amazon.cryptography.primitives.internaldafny.types.ECDSASignInput dafnyValue) {
        ECDSASignInput.Builder nativeBuilder = ECDSASignInput.builder();
        nativeBuilder.signatureAlgorithm(ToNative.ECDSASignatureAlgorithm(dafnyValue.dtor_signatureAlgorithm()));
        nativeBuilder.signingKey(ToNative.Simple.ByteBuffer(dafnyValue.dtor_signingKey()));
        nativeBuilder.message(ToNative.Simple.ByteBuffer(dafnyValue.dtor_message()));
        return nativeBuilder.build();
    }

    public static ByteBuffer ECDSASignOutput(DafnySequence<? extends Byte> dafnyValue) {
        return ToNative.Simple.ByteBuffer(dafnyValue);
    }

    public static software.amazon.cryptography.primitives.model.ECDSAVerifyInput ECDSAVerifyInput(ECDSAVerifyInput dafnyValue) {
        ECDSAVerifyInput.Builder nativeBuilder = software.amazon.cryptography.primitives.model.ECDSAVerifyInput.builder();
        nativeBuilder.signatureAlgorithm(ToNative.ECDSASignatureAlgorithm(dafnyValue.dtor_signatureAlgorithm()));
        nativeBuilder.verificationKey(ToNative.Simple.ByteBuffer(dafnyValue.dtor_verificationKey()));
        nativeBuilder.message(ToNative.Simple.ByteBuffer(dafnyValue.dtor_message()));
        nativeBuilder.signature(ToNative.Simple.ByteBuffer(dafnyValue.dtor_signature()));
        return nativeBuilder.build();
    }

    public static Boolean ECDSAVerifyOutput(Boolean dafnyValue) {
        return dafnyValue;
    }

    public static GenerateECCKeyPairInput GenerateECCKeyPairInput(software.amazon.cryptography.primitives.internaldafny.types.GenerateECCKeyPairInput dafnyValue) {
        GenerateECCKeyPairInput.Builder nativeBuilder = GenerateECCKeyPairInput.builder();
        nativeBuilder.eccCurve(ToNative.ECDHCurveSpec(dafnyValue.dtor_eccCurve()));
        return nativeBuilder.build();
    }

    public static GenerateECCKeyPairOutput GenerateECCKeyPairOutput(software.amazon.cryptography.primitives.internaldafny.types.GenerateECCKeyPairOutput dafnyValue) {
        GenerateECCKeyPairOutput.Builder nativeBuilder = GenerateECCKeyPairOutput.builder();
        nativeBuilder.eccCurve(ToNative.ECDHCurveSpec(dafnyValue.dtor_eccCurve()));
        nativeBuilder.privateKey(ToNative.ECCPrivateKey(dafnyValue.dtor_privateKey()));
        nativeBuilder.publicKey(ToNative.ECCPublicKey(dafnyValue.dtor_publicKey()));
        return nativeBuilder.build();
    }

    public static GenerateECDSASignatureKeyInput GenerateECDSASignatureKeyInput(software.amazon.cryptography.primitives.internaldafny.types.GenerateECDSASignatureKeyInput dafnyValue) {
        GenerateECDSASignatureKeyInput.Builder nativeBuilder = GenerateECDSASignatureKeyInput.builder();
        nativeBuilder.signatureAlgorithm(ToNative.ECDSASignatureAlgorithm(dafnyValue.dtor_signatureAlgorithm()));
        return nativeBuilder.build();
    }

    public static GenerateECDSASignatureKeyOutput GenerateECDSASignatureKeyOutput(software.amazon.cryptography.primitives.internaldafny.types.GenerateECDSASignatureKeyOutput dafnyValue) {
        GenerateECDSASignatureKeyOutput.Builder nativeBuilder = GenerateECDSASignatureKeyOutput.builder();
        nativeBuilder.signatureAlgorithm(ToNative.ECDSASignatureAlgorithm(dafnyValue.dtor_signatureAlgorithm()));
        nativeBuilder.verificationKey(ToNative.Simple.ByteBuffer(dafnyValue.dtor_verificationKey()));
        nativeBuilder.signingKey(ToNative.Simple.ByteBuffer(dafnyValue.dtor_signingKey()));
        return nativeBuilder.build();
    }

    public static software.amazon.cryptography.primitives.model.GenerateRandomBytesInput GenerateRandomBytesInput(GenerateRandomBytesInput dafnyValue) {
        GenerateRandomBytesInput.Builder nativeBuilder = software.amazon.cryptography.primitives.model.GenerateRandomBytesInput.builder();
        nativeBuilder.length(dafnyValue.dtor_length());
        return nativeBuilder.build();
    }

    public static ByteBuffer GenerateRandomBytesOutput(DafnySequence<? extends Byte> dafnyValue) {
        return ToNative.Simple.ByteBuffer(dafnyValue);
    }

    public static software.amazon.cryptography.primitives.model.GenerateRSAKeyPairInput GenerateRSAKeyPairInput(GenerateRSAKeyPairInput dafnyValue) {
        GenerateRSAKeyPairInput.Builder nativeBuilder = software.amazon.cryptography.primitives.model.GenerateRSAKeyPairInput.builder();
        nativeBuilder.lengthBits(dafnyValue.dtor_lengthBits());
        return nativeBuilder.build();
    }

    public static software.amazon.cryptography.primitives.model.GenerateRSAKeyPairOutput GenerateRSAKeyPairOutput(GenerateRSAKeyPairOutput dafnyValue) {
        GenerateRSAKeyPairOutput.Builder nativeBuilder = software.amazon.cryptography.primitives.model.GenerateRSAKeyPairOutput.builder();
        nativeBuilder.publicKey(ToNative.RSAPublicKey(dafnyValue.dtor_publicKey()));
        nativeBuilder.privateKey(ToNative.RSAPrivateKey(dafnyValue.dtor_privateKey()));
        return nativeBuilder.build();
    }

    public static software.amazon.cryptography.primitives.model.GetPublicKeyFromPrivateKeyInput GetPublicKeyFromPrivateKeyInput(GetPublicKeyFromPrivateKeyInput dafnyValue) {
        GetPublicKeyFromPrivateKeyInput.Builder nativeBuilder = software.amazon.cryptography.primitives.model.GetPublicKeyFromPrivateKeyInput.builder();
        nativeBuilder.eccCurve(ToNative.ECDHCurveSpec(dafnyValue.dtor_eccCurve()));
        nativeBuilder.privateKey(ToNative.ECCPrivateKey(dafnyValue.dtor_privateKey()));
        return nativeBuilder.build();
    }

    public static software.amazon.cryptography.primitives.model.GetPublicKeyFromPrivateKeyOutput GetPublicKeyFromPrivateKeyOutput(GetPublicKeyFromPrivateKeyOutput dafnyValue) {
        GetPublicKeyFromPrivateKeyOutput.Builder nativeBuilder = software.amazon.cryptography.primitives.model.GetPublicKeyFromPrivateKeyOutput.builder();
        nativeBuilder.eccCurve(ToNative.ECDHCurveSpec(dafnyValue.dtor_eccCurve()));
        nativeBuilder.privateKey(ToNative.ECCPrivateKey(dafnyValue.dtor_privateKey()));
        nativeBuilder.publicKey(ToNative.Simple.ByteBuffer(dafnyValue.dtor_publicKey()));
        return nativeBuilder.build();
    }

    public static GetRSAKeyModulusLengthInput GetRSAKeyModulusLengthInput(software.amazon.cryptography.primitives.internaldafny.types.GetRSAKeyModulusLengthInput dafnyValue) {
        GetRSAKeyModulusLengthInput.Builder nativeBuilder = GetRSAKeyModulusLengthInput.builder();
        nativeBuilder.publicKey(ToNative.Simple.ByteBuffer(dafnyValue.dtor_publicKey()));
        return nativeBuilder.build();
    }

    public static GetRSAKeyModulusLengthOutput GetRSAKeyModulusLengthOutput(software.amazon.cryptography.primitives.internaldafny.types.GetRSAKeyModulusLengthOutput dafnyValue) {
        GetRSAKeyModulusLengthOutput.Builder nativeBuilder = GetRSAKeyModulusLengthOutput.builder();
        nativeBuilder.length(dafnyValue.dtor_length());
        return nativeBuilder.build();
    }

    public static HkdfExpandInput HkdfExpandInput(software.amazon.cryptography.primitives.internaldafny.types.HkdfExpandInput dafnyValue) {
        HkdfExpandInput.Builder nativeBuilder = HkdfExpandInput.builder();
        nativeBuilder.digestAlgorithm(ToNative.DigestAlgorithm(dafnyValue.dtor_digestAlgorithm()));
        nativeBuilder.prk(ToNative.Simple.ByteBuffer(dafnyValue.dtor_prk()));
        nativeBuilder.info(ToNative.Simple.ByteBuffer(dafnyValue.dtor_info()));
        nativeBuilder.expectedLength(dafnyValue.dtor_expectedLength());
        return nativeBuilder.build();
    }

    public static ByteBuffer HkdfExpandOutput(DafnySequence<? extends Byte> dafnyValue) {
        return ToNative.Simple.ByteBuffer(dafnyValue);
    }

    public static software.amazon.cryptography.primitives.model.HkdfExtractInput HkdfExtractInput(HkdfExtractInput dafnyValue) {
        HkdfExtractInput.Builder nativeBuilder = software.amazon.cryptography.primitives.model.HkdfExtractInput.builder();
        nativeBuilder.digestAlgorithm(ToNative.DigestAlgorithm(dafnyValue.dtor_digestAlgorithm()));
        if (dafnyValue.dtor_salt().is_Some()) {
            nativeBuilder.salt(ToNative.Simple.ByteBuffer(dafnyValue.dtor_salt().dtor_value()));
        }
        nativeBuilder.ikm(ToNative.Simple.ByteBuffer(dafnyValue.dtor_ikm()));
        return nativeBuilder.build();
    }

    public static ByteBuffer HkdfExtractOutput(DafnySequence<? extends Byte> dafnyValue) {
        return ToNative.Simple.ByteBuffer(dafnyValue);
    }

    public static HkdfInput HkdfInput(software.amazon.cryptography.primitives.internaldafny.types.HkdfInput dafnyValue) {
        HkdfInput.Builder nativeBuilder = HkdfInput.builder();
        nativeBuilder.digestAlgorithm(ToNative.DigestAlgorithm(dafnyValue.dtor_digestAlgorithm()));
        if (dafnyValue.dtor_salt().is_Some()) {
            nativeBuilder.salt(ToNative.Simple.ByteBuffer(dafnyValue.dtor_salt().dtor_value()));
        }
        nativeBuilder.ikm(ToNative.Simple.ByteBuffer(dafnyValue.dtor_ikm()));
        nativeBuilder.info(ToNative.Simple.ByteBuffer(dafnyValue.dtor_info()));
        nativeBuilder.expectedLength(dafnyValue.dtor_expectedLength());
        return nativeBuilder.build();
    }

    public static ByteBuffer HkdfOutput(DafnySequence<? extends Byte> dafnyValue) {
        return ToNative.Simple.ByteBuffer(dafnyValue);
    }

    public static software.amazon.cryptography.primitives.model.HMacInput HMacInput(HMacInput dafnyValue) {
        HMacInput.Builder nativeBuilder = software.amazon.cryptography.primitives.model.HMacInput.builder();
        nativeBuilder.digestAlgorithm(ToNative.DigestAlgorithm(dafnyValue.dtor_digestAlgorithm()));
        nativeBuilder.key(ToNative.Simple.ByteBuffer(dafnyValue.dtor_key()));
        nativeBuilder.message(ToNative.Simple.ByteBuffer(dafnyValue.dtor_message()));
        return nativeBuilder.build();
    }

    public static ByteBuffer HMacOutput(DafnySequence<? extends Byte> dafnyValue) {
        return ToNative.Simple.ByteBuffer(dafnyValue);
    }

    public static KdfCtrInput KdfCtrInput(software.amazon.cryptography.primitives.internaldafny.types.KdfCtrInput dafnyValue) {
        KdfCtrInput.Builder nativeBuilder = KdfCtrInput.builder();
        nativeBuilder.digestAlgorithm(ToNative.DigestAlgorithm(dafnyValue.dtor_digestAlgorithm()));
        nativeBuilder.ikm(ToNative.Simple.ByteBuffer(dafnyValue.dtor_ikm()));
        nativeBuilder.expectedLength(dafnyValue.dtor_expectedLength());
        if (dafnyValue.dtor_purpose().is_Some()) {
            nativeBuilder.purpose(ToNative.Simple.ByteBuffer(dafnyValue.dtor_purpose().dtor_value()));
        }
        if (dafnyValue.dtor_nonce().is_Some()) {
            nativeBuilder.nonce(ToNative.Simple.ByteBuffer(dafnyValue.dtor_nonce().dtor_value()));
        }
        return nativeBuilder.build();
    }

    public static ByteBuffer KdfCtrOutput(DafnySequence<? extends Byte> dafnyValue) {
        return ToNative.Simple.ByteBuffer(dafnyValue);
    }

    public static software.amazon.cryptography.primitives.model.ParsePublicKeyInput ParsePublicKeyInput(ParsePublicKeyInput dafnyValue) {
        ParsePublicKeyInput.Builder nativeBuilder = software.amazon.cryptography.primitives.model.ParsePublicKeyInput.builder();
        nativeBuilder.publicKey(ToNative.Simple.ByteBuffer(dafnyValue.dtor_publicKey()));
        return nativeBuilder.build();
    }

    public static ParsePublicKeyOutput ParsePublicKeyOutput(software.amazon.cryptography.primitives.internaldafny.types.ParsePublicKeyOutput dafnyValue) {
        ParsePublicKeyOutput.Builder nativeBuilder = ParsePublicKeyOutput.builder();
        nativeBuilder.publicKey(ToNative.ECCPublicKey(dafnyValue.dtor_publicKey()));
        return nativeBuilder.build();
    }

    public static software.amazon.cryptography.primitives.model.RSADecryptInput RSADecryptInput(RSADecryptInput dafnyValue) {
        RSADecryptInput.Builder nativeBuilder = software.amazon.cryptography.primitives.model.RSADecryptInput.builder();
        nativeBuilder.padding(ToNative.RSAPaddingMode(dafnyValue.dtor_padding()));
        nativeBuilder.privateKey(ToNative.Simple.ByteBuffer(dafnyValue.dtor_privateKey()));
        nativeBuilder.cipherText(ToNative.Simple.ByteBuffer(dafnyValue.dtor_cipherText()));
        return nativeBuilder.build();
    }

    public static ByteBuffer RSADecryptOutput(DafnySequence<? extends Byte> dafnyValue) {
        return ToNative.Simple.ByteBuffer(dafnyValue);
    }

    public static RSAEncryptInput RSAEncryptInput(software.amazon.cryptography.primitives.internaldafny.types.RSAEncryptInput dafnyValue) {
        RSAEncryptInput.Builder nativeBuilder = RSAEncryptInput.builder();
        nativeBuilder.padding(ToNative.RSAPaddingMode(dafnyValue.dtor_padding()));
        nativeBuilder.publicKey(ToNative.Simple.ByteBuffer(dafnyValue.dtor_publicKey()));
        nativeBuilder.plaintext(ToNative.Simple.ByteBuffer(dafnyValue.dtor_plaintext()));
        return nativeBuilder.build();
    }

    public static ByteBuffer RSAEncryptOutput(DafnySequence<? extends Byte> dafnyValue) {
        return ToNative.Simple.ByteBuffer(dafnyValue);
    }

    public static RSAPrivateKey RSAPrivateKey(software.amazon.cryptography.primitives.internaldafny.types.RSAPrivateKey dafnyValue) {
        RSAPrivateKey.Builder nativeBuilder = RSAPrivateKey.builder();
        nativeBuilder.lengthBits(dafnyValue.dtor_lengthBits());
        nativeBuilder.pem(ToNative.Simple.ByteBuffer(dafnyValue.dtor_pem()));
        return nativeBuilder.build();
    }

    public static RSAPublicKey RSAPublicKey(software.amazon.cryptography.primitives.internaldafny.types.RSAPublicKey dafnyValue) {
        RSAPublicKey.Builder nativeBuilder = RSAPublicKey.builder();
        nativeBuilder.lengthBits(dafnyValue.dtor_lengthBits());
        nativeBuilder.pem(ToNative.Simple.ByteBuffer(dafnyValue.dtor_pem()));
        return nativeBuilder.build();
    }

    public static software.amazon.cryptography.primitives.model.ValidatePublicKeyInput ValidatePublicKeyInput(ValidatePublicKeyInput dafnyValue) {
        ValidatePublicKeyInput.Builder nativeBuilder = software.amazon.cryptography.primitives.model.ValidatePublicKeyInput.builder();
        nativeBuilder.eccCurve(ToNative.ECDHCurveSpec(dafnyValue.dtor_eccCurve()));
        nativeBuilder.publicKey(ToNative.Simple.ByteBuffer(dafnyValue.dtor_publicKey()));
        return nativeBuilder.build();
    }

    public static ValidatePublicKeyOutput ValidatePublicKeyOutput(software.amazon.cryptography.primitives.internaldafny.types.ValidatePublicKeyOutput dafnyValue) {
        ValidatePublicKeyOutput.Builder nativeBuilder = ValidatePublicKeyOutput.builder();
        nativeBuilder.success(dafnyValue.dtor_success());
        return nativeBuilder.build();
    }

    public static DigestAlgorithm DigestAlgorithm(software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm dafnyValue) {
        if (dafnyValue.is_SHA__512()) {
            return DigestAlgorithm.SHA_512;
        }
        if (dafnyValue.is_SHA__384()) {
            return DigestAlgorithm.SHA_384;
        }
        if (dafnyValue.is_SHA__256()) {
            return DigestAlgorithm.SHA_256;
        }
        throw new IllegalArgumentException("No entry of software.amazon.cryptography.primitives.model.DigestAlgorithm matches the input : " + dafnyValue);
    }

    public static software.amazon.cryptography.primitives.model.ECDHCurveSpec ECDHCurveSpec(ECDHCurveSpec dafnyValue) {
        if (dafnyValue.is_ECC__NIST__P256()) {
            return software.amazon.cryptography.primitives.model.ECDHCurveSpec.ECC_NIST_P256;
        }
        if (dafnyValue.is_ECC__NIST__P384()) {
            return software.amazon.cryptography.primitives.model.ECDHCurveSpec.ECC_NIST_P384;
        }
        if (dafnyValue.is_ECC__NIST__P521()) {
            return software.amazon.cryptography.primitives.model.ECDHCurveSpec.ECC_NIST_P521;
        }
        if (dafnyValue.is_SM2()) {
            return software.amazon.cryptography.primitives.model.ECDHCurveSpec.SM2;
        }
        throw new IllegalArgumentException("No entry of software.amazon.cryptography.primitives.model.ECDHCurveSpec matches the input : " + dafnyValue);
    }

    public static software.amazon.cryptography.primitives.model.ECDSASignatureAlgorithm ECDSASignatureAlgorithm(ECDSASignatureAlgorithm dafnyValue) {
        if (dafnyValue.is_ECDSA__P384()) {
            return software.amazon.cryptography.primitives.model.ECDSASignatureAlgorithm.ECDSA_P384;
        }
        if (dafnyValue.is_ECDSA__P256()) {
            return software.amazon.cryptography.primitives.model.ECDSASignatureAlgorithm.ECDSA_P256;
        }
        throw new IllegalArgumentException("No entry of software.amazon.cryptography.primitives.model.ECDSASignatureAlgorithm matches the input : " + dafnyValue);
    }

    public static software.amazon.cryptography.primitives.model.RSAPaddingMode RSAPaddingMode(RSAPaddingMode dafnyValue) {
        if (dafnyValue.is_PKCS1()) {
            return software.amazon.cryptography.primitives.model.RSAPaddingMode.PKCS1;
        }
        if (dafnyValue.is_OAEP__SHA1()) {
            return software.amazon.cryptography.primitives.model.RSAPaddingMode.OAEP_SHA1;
        }
        if (dafnyValue.is_OAEP__SHA256()) {
            return software.amazon.cryptography.primitives.model.RSAPaddingMode.OAEP_SHA256;
        }
        if (dafnyValue.is_OAEP__SHA384()) {
            return software.amazon.cryptography.primitives.model.RSAPaddingMode.OAEP_SHA384;
        }
        if (dafnyValue.is_OAEP__SHA512()) {
            return software.amazon.cryptography.primitives.model.RSAPaddingMode.OAEP_SHA512;
        }
        throw new IllegalArgumentException("No entry of software.amazon.cryptography.primitives.model.RSAPaddingMode matches the input : " + dafnyValue);
    }

    public static AtomicPrimitives AwsCryptographicPrimitives(IAwsCryptographicPrimitivesClient dafnyValue) {
        return new AtomicPrimitives(dafnyValue);
    }
}

