/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.internaldafny.types;

import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPrivateKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPublicKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec;

public class DeriveSharedSecretInput {
    public ECDHCurveSpec _eccCurve;
    public ECCPrivateKey _privateKey;
    public ECCPublicKey _publicKey;
    private static final DeriveSharedSecretInput theDefault = DeriveSharedSecretInput.create(ECDHCurveSpec.Default(), ECCPrivateKey.Default(), ECCPublicKey.Default());
    private static final TypeDescriptor<DeriveSharedSecretInput> _TYPE = TypeDescriptor.referenceWithInitializer(DeriveSharedSecretInput.class, () -> DeriveSharedSecretInput.Default());

    public DeriveSharedSecretInput(ECDHCurveSpec eccCurve, ECCPrivateKey privateKey, ECCPublicKey publicKey) {
        this._eccCurve = eccCurve;
        this._privateKey = privateKey;
        this._publicKey = publicKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        DeriveSharedSecretInput o = (DeriveSharedSecretInput)other;
        return Objects.equals(this._eccCurve, o._eccCurve) && Objects.equals(this._privateKey, o._privateKey) && Objects.equals(this._publicKey, o._publicKey);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._eccCurve);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._privateKey);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._publicKey);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("AwsCryptographyPrimitivesTypes.DeriveSharedSecretInput.DeriveSharedSecretInput");
        s.append("(");
        s.append(Helpers.toString((Object)this._eccCurve));
        s.append(", ");
        s.append(Helpers.toString((Object)this._privateKey));
        s.append(", ");
        s.append(Helpers.toString((Object)this._publicKey));
        s.append(")");
        return s.toString();
    }

    public static DeriveSharedSecretInput Default() {
        return theDefault;
    }

    public static TypeDescriptor<DeriveSharedSecretInput> _typeDescriptor() {
        return _TYPE;
    }

    public static DeriveSharedSecretInput create(ECDHCurveSpec eccCurve, ECCPrivateKey privateKey, ECCPublicKey publicKey) {
        return new DeriveSharedSecretInput(eccCurve, privateKey, publicKey);
    }

    public static DeriveSharedSecretInput create_DeriveSharedSecretInput(ECDHCurveSpec eccCurve, ECCPrivateKey privateKey, ECCPublicKey publicKey) {
        return DeriveSharedSecretInput.create(eccCurve, privateKey, publicKey);
    }

    public boolean is_DeriveSharedSecretInput() {
        return true;
    }

    public ECDHCurveSpec dtor_eccCurve() {
        return this._eccCurve;
    }

    public ECCPrivateKey dtor_privateKey() {
        return this._privateKey;
    }

    public ECCPublicKey dtor_publicKey() {
        return this._publicKey;
    }
}

