/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.internaldafny.types;

import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPublicKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec;

public class CompressPublicKeyInput {
    public ECCPublicKey _publicKey;
    public ECDHCurveSpec _eccCurve;
    private static final CompressPublicKeyInput theDefault = CompressPublicKeyInput.create(ECCPublicKey.Default(), ECDHCurveSpec.Default());
    private static final TypeDescriptor<CompressPublicKeyInput> _TYPE = TypeDescriptor.referenceWithInitializer(CompressPublicKeyInput.class, () -> CompressPublicKeyInput.Default());

    public CompressPublicKeyInput(ECCPublicKey publicKey, ECDHCurveSpec eccCurve) {
        this._publicKey = publicKey;
        this._eccCurve = eccCurve;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        CompressPublicKeyInput o = (CompressPublicKeyInput)other;
        return Objects.equals(this._publicKey, o._publicKey) && Objects.equals(this._eccCurve, o._eccCurve);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._publicKey);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._eccCurve);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("AwsCryptographyPrimitivesTypes.CompressPublicKeyInput.CompressPublicKeyInput");
        s.append("(");
        s.append(Helpers.toString((Object)this._publicKey));
        s.append(", ");
        s.append(Helpers.toString((Object)this._eccCurve));
        s.append(")");
        return s.toString();
    }

    public static CompressPublicKeyInput Default() {
        return theDefault;
    }

    public static TypeDescriptor<CompressPublicKeyInput> _typeDescriptor() {
        return _TYPE;
    }

    public static CompressPublicKeyInput create(ECCPublicKey publicKey, ECDHCurveSpec eccCurve) {
        return new CompressPublicKeyInput(publicKey, eccCurve);
    }

    public static CompressPublicKeyInput create_CompressPublicKeyInput(ECCPublicKey publicKey, ECDHCurveSpec eccCurve) {
        return CompressPublicKeyInput.create(publicKey, eccCurve);
    }

    public boolean is_CompressPublicKeyInput() {
        return true;
    }

    public ECCPublicKey dtor_publicKey() {
        return this._publicKey;
    }

    public ECDHCurveSpec dtor_eccCurve() {
        return this._eccCurve;
    }
}

