/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.EphemeralSenderToStaticRecipientInput;
import software.amazon.cryptography.materialproviders.model.StaticDiscoveryRecipientInput;
import software.amazon.cryptography.materialproviders.model.StaticSenderStaticRecipientInput;

public class RawEcdhConfigurations {
    private final StaticDiscoveryRecipientInput StaticDiscoveryRecipient;
    private final StaticSenderStaticRecipientInput StaticSenderStaticRecipient;
    private final EphemeralSenderToStaticRecipientInput EphemeralSenderToStaticKmsRecipient;

    protected RawEcdhConfigurations(BuilderImpl builder) {
        this.StaticDiscoveryRecipient = builder.StaticDiscoveryRecipient();
        this.StaticSenderStaticRecipient = builder.StaticSenderStaticRecipient();
        this.EphemeralSenderToStaticKmsRecipient = builder.EphemeralSenderToStaticKmsRecipient();
    }

    public StaticDiscoveryRecipientInput StaticDiscoveryRecipient() {
        return this.StaticDiscoveryRecipient;
    }

    public StaticSenderStaticRecipientInput StaticSenderStaticRecipient() {
        return this.StaticSenderStaticRecipient;
    }

    public EphemeralSenderToStaticRecipientInput EphemeralSenderToStaticKmsRecipient() {
        return this.EphemeralSenderToStaticKmsRecipient;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected StaticDiscoveryRecipientInput StaticDiscoveryRecipient;
        protected StaticSenderStaticRecipientInput StaticSenderStaticRecipient;
        protected EphemeralSenderToStaticRecipientInput EphemeralSenderToStaticKmsRecipient;

        protected BuilderImpl() {
        }

        protected BuilderImpl(RawEcdhConfigurations model) {
            this.StaticDiscoveryRecipient = model.StaticDiscoveryRecipient();
            this.StaticSenderStaticRecipient = model.StaticSenderStaticRecipient();
            this.EphemeralSenderToStaticKmsRecipient = model.EphemeralSenderToStaticKmsRecipient();
        }

        @Override
        public Builder StaticDiscoveryRecipient(StaticDiscoveryRecipientInput StaticDiscoveryRecipient) {
            this.StaticDiscoveryRecipient = StaticDiscoveryRecipient;
            return this;
        }

        @Override
        public StaticDiscoveryRecipientInput StaticDiscoveryRecipient() {
            return this.StaticDiscoveryRecipient;
        }

        @Override
        public Builder StaticSenderStaticRecipient(StaticSenderStaticRecipientInput StaticSenderStaticRecipient) {
            this.StaticSenderStaticRecipient = StaticSenderStaticRecipient;
            return this;
        }

        @Override
        public StaticSenderStaticRecipientInput StaticSenderStaticRecipient() {
            return this.StaticSenderStaticRecipient;
        }

        @Override
        public Builder EphemeralSenderToStaticKmsRecipient(EphemeralSenderToStaticRecipientInput EphemeralSenderToStaticKmsRecipient) {
            this.EphemeralSenderToStaticKmsRecipient = EphemeralSenderToStaticKmsRecipient;
            return this;
        }

        @Override
        public EphemeralSenderToStaticRecipientInput EphemeralSenderToStaticKmsRecipient() {
            return this.EphemeralSenderToStaticKmsRecipient;
        }

        @Override
        public RawEcdhConfigurations build() {
            if (!this.onlyOneNonNull()) {
                throw new IllegalArgumentException("`RawEcdhConfigurations` is a Union. A Union MUST have one and only one value set.");
            }
            return new RawEcdhConfigurations(this);
        }

        private boolean onlyOneNonNull() {
            Object[] allValues = new Object[]{this.StaticDiscoveryRecipient, this.StaticSenderStaticRecipient, this.EphemeralSenderToStaticKmsRecipient};
            boolean haveOneNonNull = false;
            for (Object o : allValues) {
                if (!Objects.nonNull(o)) continue;
                if (haveOneNonNull) {
                    return false;
                }
                haveOneNonNull = true;
            }
            return haveOneNonNull;
        }
    }

    public static interface Builder {
        public Builder StaticDiscoveryRecipient(StaticDiscoveryRecipientInput var1);

        public StaticDiscoveryRecipientInput StaticDiscoveryRecipient();

        public Builder StaticSenderStaticRecipient(StaticSenderStaticRecipientInput var1);

        public StaticSenderStaticRecipientInput StaticSenderStaticRecipient();

        public Builder EphemeralSenderToStaticKmsRecipient(EphemeralSenderToStaticRecipientInput var1);

        public EphemeralSenderToStaticRecipientInput EphemeralSenderToStaticKmsRecipient();

        public RawEcdhConfigurations build();
    }
}

