/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.KmsRecipientConfiguration;

public class KmsSenderToStaticRecipientInput {
    private final String senderKmsIdentifier;
    private final KmsRecipientConfiguration recipientConfiguration;

    protected KmsSenderToStaticRecipientInput(BuilderImpl builder) {
        this.senderKmsIdentifier = builder.senderKmsIdentifier();
        this.recipientConfiguration = builder.recipientConfiguration();
    }

    public String senderKmsIdentifier() {
        return this.senderKmsIdentifier;
    }

    public KmsRecipientConfiguration recipientConfiguration() {
        return this.recipientConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String senderKmsIdentifier;
        protected KmsRecipientConfiguration recipientConfiguration;

        protected BuilderImpl() {
        }

        protected BuilderImpl(KmsSenderToStaticRecipientInput model) {
            this.senderKmsIdentifier = model.senderKmsIdentifier();
            this.recipientConfiguration = model.recipientConfiguration();
        }

        @Override
        public Builder senderKmsIdentifier(String senderKmsIdentifier) {
            this.senderKmsIdentifier = senderKmsIdentifier;
            return this;
        }

        @Override
        public String senderKmsIdentifier() {
            return this.senderKmsIdentifier;
        }

        @Override
        public Builder recipientConfiguration(KmsRecipientConfiguration recipientConfiguration) {
            this.recipientConfiguration = recipientConfiguration;
            return this;
        }

        @Override
        public KmsRecipientConfiguration recipientConfiguration() {
            return this.recipientConfiguration;
        }

        @Override
        public KmsSenderToStaticRecipientInput build() {
            if (Objects.isNull(this.senderKmsIdentifier())) {
                throw new IllegalArgumentException("Missing value for required field `senderKmsIdentifier`");
            }
            if (Objects.isNull(this.recipientConfiguration())) {
                throw new IllegalArgumentException("Missing value for required field `recipientConfiguration`");
            }
            return new KmsSenderToStaticRecipientInput(this);
        }
    }

    public static interface Builder {
        public Builder senderKmsIdentifier(String var1);

        public String senderKmsIdentifier();

        public Builder recipientConfiguration(KmsRecipientConfiguration var1);

        public KmsRecipientConfiguration recipientConfiguration();

        public KmsSenderToStaticRecipientInput build();
    }
}

