/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders;

import Wrappers_Compile.Result;
import dafny.Tuple0;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.ICryptographicMaterialsCache;
import software.amazon.cryptography.materialproviders.ToDafny;
import software.amazon.cryptography.materialproviders.ToNative;
import software.amazon.cryptography.materialproviders.internaldafny.types.DeleteCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.UpdateUsageMetadataInput;
import software.amazon.cryptography.materialproviders.model.GetCacheEntryOutput;
import software.amazon.cryptography.materialproviders.model.PutCacheEntryInput;

public final class CryptographicMaterialsCache
implements ICryptographicMaterialsCache {
    private final software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache _impl;

    private CryptographicMaterialsCache(software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache iCryptographicMaterialsCache) {
        Objects.requireNonNull(iCryptographicMaterialsCache, "Missing value for required argument `iCryptographicMaterialsCache`");
        this._impl = iCryptographicMaterialsCache;
    }

    public static CryptographicMaterialsCache wrap(software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache iCryptographicMaterialsCache) {
        return new CryptographicMaterialsCache(iCryptographicMaterialsCache);
    }

    public static <I extends ICryptographicMaterialsCache> CryptographicMaterialsCache wrap(I iCryptographicMaterialsCache) {
        Objects.requireNonNull(iCryptographicMaterialsCache, "Missing value for required argument `iCryptographicMaterialsCache`");
        if (iCryptographicMaterialsCache instanceof CryptographicMaterialsCache) {
            return (CryptographicMaterialsCache)iCryptographicMaterialsCache;
        }
        return CryptographicMaterialsCache.wrap(new NativeWrapper(iCryptographicMaterialsCache));
    }

    public software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache impl() {
        return this._impl;
    }

    @Override
    public void DeleteCacheEntry(software.amazon.cryptography.materialproviders.model.DeleteCacheEntryInput input) {
        DeleteCacheEntryInput dafnyValue = ToDafny.DeleteCacheEntryInput(input);
        Result<Tuple0, Error> result = this._impl.DeleteCacheEntry(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
    }

    @Override
    public GetCacheEntryOutput GetCacheEntry(software.amazon.cryptography.materialproviders.model.GetCacheEntryInput input) {
        GetCacheEntryInput dafnyValue = ToDafny.GetCacheEntryInput(input);
        Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, Error> result = this._impl.GetCacheEntry(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.GetCacheEntryOutput(result.dtor_value());
    }

    @Override
    public void PutCacheEntry(PutCacheEntryInput input) {
        software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput dafnyValue = ToDafny.PutCacheEntryInput(input);
        Result<Tuple0, Error> result = this._impl.PutCacheEntry(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
    }

    @Override
    public void UpdateUsageMetadata(software.amazon.cryptography.materialproviders.model.UpdateUsageMetadataInput input) {
        UpdateUsageMetadataInput dafnyValue = ToDafny.UpdateUsageMetadataInput(input);
        Result<Tuple0, Error> result = this._impl.UpdateUsageMetadata(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
    }

    protected static final class NativeWrapper
    implements software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache {
        protected final ICryptographicMaterialsCache _impl;

        NativeWrapper(ICryptographicMaterialsCache nativeImpl) {
            if (nativeImpl instanceof CryptographicMaterialsCache) {
                throw new IllegalArgumentException("Recursive wrapping is strictly forbidden.");
            }
            this._impl = nativeImpl;
        }

        @Override
        public Result<Tuple0, Error> DeleteCacheEntry(DeleteCacheEntryInput dafnyInput) {
            try {
                software.amazon.cryptography.materialproviders.model.DeleteCacheEntryInput nativeInput = ToNative.DeleteCacheEntryInput(dafnyInput);
                this._impl.DeleteCacheEntry(nativeInput);
                return Result.create_Success(Tuple0.create());
            }
            catch (RuntimeException ex) {
                return Result.create_Failure(ToDafny.Error(ex));
            }
        }

        @Override
        public Result<Tuple0, Error> DeleteCacheEntry_k(DeleteCacheEntryInput dafnyInput) {
            throw new RuntimeException("Not supported at this time.");
        }

        @Override
        public Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, Error> GetCacheEntry(GetCacheEntryInput dafnyInput) {
            try {
                software.amazon.cryptography.materialproviders.model.GetCacheEntryInput nativeInput = ToNative.GetCacheEntryInput(dafnyInput);
                GetCacheEntryOutput nativeOutput = this._impl.GetCacheEntry(nativeInput);
                software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput dafnyOutput = ToDafny.GetCacheEntryOutput(nativeOutput);
                return Result.create_Success(dafnyOutput);
            }
            catch (RuntimeException ex) {
                return Result.create_Failure(ToDafny.Error(ex));
            }
        }

        @Override
        public Result<software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput, Error> GetCacheEntry_k(GetCacheEntryInput dafnyInput) {
            throw new RuntimeException("Not supported at this time.");
        }

        @Override
        public Result<Tuple0, Error> PutCacheEntry(software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput dafnyInput) {
            try {
                PutCacheEntryInput nativeInput = ToNative.PutCacheEntryInput(dafnyInput);
                this._impl.PutCacheEntry(nativeInput);
                return Result.create_Success(Tuple0.create());
            }
            catch (RuntimeException ex) {
                return Result.create_Failure(ToDafny.Error(ex));
            }
        }

        @Override
        public Result<Tuple0, Error> PutCacheEntry_k(software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput dafnyInput) {
            throw new RuntimeException("Not supported at this time.");
        }

        @Override
        public Result<Tuple0, Error> UpdateUsageMetadata(UpdateUsageMetadataInput dafnyInput) {
            try {
                software.amazon.cryptography.materialproviders.model.UpdateUsageMetadataInput nativeInput = ToNative.UpdateUsageMetadataInput(dafnyInput);
                this._impl.UpdateUsageMetadata(nativeInput);
                return Result.create_Success(Tuple0.create());
            }
            catch (RuntimeException ex) {
                return Result.create_Failure(ToDafny.Error(ex));
            }
        }

        @Override
        public Result<Tuple0, Error> UpdateUsageMetadata_k(UpdateUsageMetadataInput dafnyInput) {
            throw new RuntimeException("Not supported at this time.");
        }
    }
}

