/*
 * Decompiled with CFR 0.152.
 */
package RawRSAKeyring_Compile;

import BoundedInts_Compile.uint8;
import EdkWrapping_Compile.UnwrapEdkMaterialOutput;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import RawRSAKeyring_Compile.RsaGenerateAndWrapKeyMaterial;
import RawRSAKeyring_Compile.RsaUnwrapInfo;
import RawRSAKeyring_Compile.RsaUnwrapKeyMaterial;
import RawRSAKeyring_Compile.RsaWrapInfo;
import RawRSAKeyring_Compile.RsaWrapKeyMaterial;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.__default;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.RSAPaddingMode;

public class RawRSAKeyring
implements VerifiableInterface,
IKeyring {
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public DafnySequence<? extends Byte> _keyNamespace = ValidUTF8Bytes.defaultValue();
    public DafnySequence<? extends Byte> _keyName = ValidUTF8Bytes.defaultValue();
    public RSAPaddingMode _paddingScheme = RSAPaddingMode.Default();
    public Option<DafnySequence<? extends Byte>> _publicKey = Option.Default();
    public Option<DafnySequence<? extends Byte>> _privateKey = Option.Default();
    private static final TypeDescriptor<RawRSAKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(RawRSAKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out247 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out247;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out248 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out248;
    }

    public void __ctor(DafnySequence<? extends Byte> namespace, DafnySequence<? extends Byte> name, Option<DafnySequence<? extends Byte>> publicKey, Option<DafnySequence<? extends Byte>> privateKey, RSAPaddingMode paddingScheme, AtomicPrimitivesClient cryptoPrimitives) {
        this._keyNamespace = namespace;
        this._keyName = name;
        this._paddingScheme = paddingScheme;
        this._publicKey = publicKey;
        this._privateKey = privateKey;
        this._cryptoPrimitives = cryptoPrimitives;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> output = null;
        Outcome<Object> _1467_valueOrError0 = Outcome.Default();
        _1467_valueOrError0 = __default.Need(Error._typeDescriptor(), this.publicKey().is_Some() && BigInteger.valueOf(this.publicKey().Extract((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor())).length()).signum() == 1, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"A RawRSAKeyring without a public key cannot provide OnEncrypt")));
        if (_1467_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _1467_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return output;
        }
        EncryptionMaterials _1468_materials = input.dtor_materials();
        AlgorithmSuiteInfo _1469_suite = _1468_materials.dtor_algorithmSuite();
        RsaWrapKeyMaterial _nw59 = new RsaWrapKeyMaterial();
        _nw59.__ctor(this.publicKey().dtor_value(), this.paddingScheme(), this.cryptoPrimitives());
        RsaWrapKeyMaterial _1470_wrap = _nw59;
        RsaGenerateAndWrapKeyMaterial _nw60 = new RsaGenerateAndWrapKeyMaterial();
        _nw60.__ctor(this.publicKey().dtor_value(), this.paddingScheme(), this.cryptoPrimitives());
        RsaGenerateAndWrapKeyMaterial _1471_generateAndWrap = _nw60;
        Result<WrapEdkMaterialOutput<RsaWrapInfo>, Object> _1473_valueOrError1 = Result.Default(WrapEdkMaterialOutput.Default(RsaWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<RsaWrapInfo>, Error> _out249 = EdkWrapping_Compile.__default.WrapEdkMaterial(RsaWrapInfo._typeDescriptor(), _1468_materials, _1470_wrap, _1471_generateAndWrap);
        _1473_valueOrError1 = _out249;
        if (_1473_valueOrError1.IsFailure(WrapEdkMaterialOutput._typeDescriptor(RsaWrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            output = _1473_valueOrError1.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(RsaWrapInfo._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return output;
        }
        WrapEdkMaterialOutput<RsaWrapInfo> _1472_wrapOutput = _1473_valueOrError1.Extract(WrapEdkMaterialOutput._typeDescriptor(RsaWrapInfo._typeDescriptor()), Error._typeDescriptor());
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _1474_symmetricSigningKeyList = _1472_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_1472_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None();
        EncryptedDataKey _1475_edk = EncryptedDataKey.create(this.keyNamespace(), this.keyName(), _1472_wrapOutput.dtor_wrappedMaterial());
        if (_1472_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _1477_valueOrError2 = null;
            _1477_valueOrError2 = Materials_Compile.__default.EncryptionMaterialAddDataKey(_1468_materials, _1472_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_1475_edk}), _1474_symmetricSigningKeyList);
            if (_1477_valueOrError2.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                output = _1477_valueOrError2.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return output;
            }
            EncryptionMaterials _1476_result = _1477_valueOrError2.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            output = Result.create_Success(OnEncryptOutput.create(_1476_result));
            return output;
        }
        if (_1472_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _1479_valueOrError3 = null;
            _1479_valueOrError3 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(_1468_materials, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_1475_edk}), _1474_symmetricSigningKeyList);
            if (_1479_valueOrError3.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                output = _1479_valueOrError3.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return output;
            }
            EncryptionMaterials _1478_result = _1479_valueOrError3.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            output = Result.create_Success(OnEncryptOutput.create(_1478_result));
            return output;
        }
        return output;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> output = null;
        Outcome<Object> _1480_valueOrError0 = Outcome.Default();
        _1480_valueOrError0 = __default.Need(Error._typeDescriptor(), this.privateKey().is_Some() && BigInteger.valueOf(this.privateKey().Extract((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor())).length()).signum() == 1, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"A RawRSAKeyring without a private key cannot provide OnEncrypt")));
        if (_1480_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _1480_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        DecryptionMaterials _1481_materials = input.dtor_materials();
        Outcome<Object> _1482_valueOrError1 = Outcome.Default();
        _1482_valueOrError1 = __default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_1481_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_1482_valueOrError1.IsFailure(Error._typeDescriptor())) {
            output = _1482_valueOrError1.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        DafnySequence _1483_errors = DafnySequence.empty(Error._typeDescriptor());
        BigInteger _hi10 = BigInteger.valueOf(input.dtor_encryptedDataKeys().length());
        BigInteger _1484_i = BigInteger.ZERO;
        while (_1484_i.compareTo(_hi10) < 0) {
            if (this.ShouldDecryptEDK((EncryptedDataKey)input.dtor_encryptedDataKeys().select(Helpers.toInt((BigInteger)_1484_i)))) {
                Result<UnwrapEdkMaterialOutput<RsaUnwrapInfo>, Error> _out250;
                EncryptedDataKey _1485_edk = (EncryptedDataKey)input.dtor_encryptedDataKeys().select(Helpers.toInt((BigInteger)_1484_i));
                RsaUnwrapKeyMaterial _nw61 = new RsaUnwrapKeyMaterial();
                _nw61.__ctor(this.privateKey().Extract((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor())), this.paddingScheme(), this.cryptoPrimitives());
                RsaUnwrapKeyMaterial _1486_unwrap = _nw61;
                Result<UnwrapEdkMaterialOutput<RsaUnwrapInfo>, Error> _1487_unwrapOutput = _out250 = EdkWrapping_Compile.__default.UnwrapEdkMaterial(RsaUnwrapInfo._typeDescriptor(), _1485_edk.dtor_ciphertext(), _1481_materials, _1486_unwrap);
                if (_1487_unwrapOutput.is_Success()) {
                    Result<DecryptionMaterials, Error> _1489_valueOrError2 = null;
                    _1489_valueOrError2 = Materials_Compile.__default.DecryptionMaterialsAddDataKey(_1481_materials, _1487_unwrapOutput.dtor_value().dtor_plaintextDataKey(), _1487_unwrapOutput.dtor_value().dtor_symmetricSigningKey());
                    if (_1489_valueOrError2.IsFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                        output = _1489_valueOrError2.PropagateFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                        return output;
                    }
                    DecryptionMaterials _1488_returnMaterials = _1489_valueOrError2.Extract(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
                    output = Result.create_Success(OnDecryptOutput.create(_1488_returnMaterials));
                    return output;
                }
                _1483_errors = DafnySequence.concatenate((DafnySequence)_1483_errors, (DafnySequence)DafnySequence.of(Error._typeDescriptor(), (Object[])new Error[]{_1487_unwrapOutput.dtor_error()}));
            } else {
                Result<Object, Object> _1491_valueOrError3 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
                _1491_valueOrError3 = UTF8.__default.Decode(((EncryptedDataKey)input.dtor_encryptedDataKeys().select(Helpers.toInt((BigInteger)_1484_i))).dtor_keyProviderId()).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _1492_e_boxed0 -> {
                    DafnySequence _1492_e = _1492_e_boxed0;
                    return Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_1492_e);
                });
                if (_1491_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                    output = _1491_valueOrError3.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                    return output;
                }
                DafnySequence _1490_extractedKeyProviderId = (DafnySequence)_1491_valueOrError3.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
                _1483_errors = DafnySequence.concatenate((DafnySequence)_1483_errors, (DafnySequence)DafnySequence.of(Error._typeDescriptor(), (Object[])new Error[]{Error.create_AwsCryptographicMaterialProvidersException(ErrorMessages_Compile.__default.IncorrectRawDataKeys(String_Compile.__default.Base10Int2String(_1484_i), (DafnySequence<? extends Character>)DafnySequence.asString((String)"RSAKeyring"), (DafnySequence<? extends Character>)_1490_extractedKeyProviderId))}));
            }
            _1484_i = _1484_i.add(BigInteger.ONE);
        }
        output = Result.create_Failure(Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_1483_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"Raw RSA Key was unable to decrypt any encrypted data key. The list of encountered Exceptions is avaible via `list`.")));
        return output;
    }

    public boolean ShouldDecryptEDK(EncryptedDataKey edk) {
        return UTF8.__default.ValidUTF8Seq(edk.dtor_keyProviderInfo()) && edk.dtor_keyProviderInfo().equals(this.keyName()) && edk.dtor_keyProviderId().equals(this.keyNamespace()) && BigInteger.valueOf(edk.dtor_ciphertext().length()).signum() == 1;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public DafnySequence<? extends Byte> keyNamespace() {
        return this._keyNamespace;
    }

    public DafnySequence<? extends Byte> keyName() {
        return this._keyName;
    }

    public RSAPaddingMode paddingScheme() {
        return this._paddingScheme;
    }

    public Option<DafnySequence<? extends Byte>> publicKey() {
        return this._publicKey;
    }

    public Option<DafnySequence<? extends Byte>> privateKey() {
        return this._privateKey;
    }

    public static TypeDescriptor<RawRSAKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "RawRSAKeyring.RawRSAKeyring";
    }
}

