/*
 * Decompiled with CFR 0.152.
 */
package RawECDHKeyring_Compile;

import BoundedInts_Compile.uint8;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.CompressPublicKeyInput;
import software.amazon.cryptography.primitives.internaldafny.types.CompressPublicKeyOutput;
import software.amazon.cryptography.primitives.internaldafny.types.DecompressPublicKeyInput;
import software.amazon.cryptography.primitives.internaldafny.types.DecompressPublicKeyOutput;
import software.amazon.cryptography.primitives.internaldafny.types.DeriveSharedSecretInput;
import software.amazon.cryptography.primitives.internaldafny.types.DeriveSharedSecretOutput;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPrivateKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPublicKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.types.GenerateECCKeyPairInput;
import software.amazon.cryptography.primitives.internaldafny.types.GenerateECCKeyPairOutput;
import software.amazon.cryptography.primitives.internaldafny.types.ValidatePublicKeyInput;
import software.amazon.cryptography.primitives.internaldafny.types.ValidatePublicKeyOutput;

public class __default {
    public static boolean ValidPublicKeyLength(DafnySequence<? extends Byte> p) {
        return Objects.equals(BigInteger.valueOf(p.length()), Constants_Compile.__default.ECDH__PUBLIC__KEY__LEN__ECC__NIST__256()) || Objects.equals(BigInteger.valueOf(p.length()), Constants_Compile.__default.ECDH__PUBLIC__KEY__LEN__ECC__NIST__384()) || Objects.equals(BigInteger.valueOf(p.length()), Constants_Compile.__default.ECDH__PUBLIC__KEY__LEN__ECC__NIST__521());
    }

    public static boolean ValidCompressedPublicKeyLength(DafnySequence<? extends Byte> p) {
        return Objects.equals(BigInteger.valueOf(p.length()), Constants_Compile.__default.ECDH__PUBLIC__KEY__COMPRESSED__LEN__ECC__NIST__256()) || Objects.equals(BigInteger.valueOf(p.length()), Constants_Compile.__default.ECDH__PUBLIC__KEY__COMPRESSED__LEN__ECC__NIST__384()) || Objects.equals(BigInteger.valueOf(p.length()), Constants_Compile.__default.ECDH__PUBLIC__KEY__COMPRESSED__LEN__ECC__NIST__521());
    }

    public static boolean ValidProviderInfoLength(DafnySequence<? extends Byte> p) {
        return Objects.equals(BigInteger.valueOf(p.length()), BigInteger.valueOf(Integer.toUnsignedLong(Constants_Compile.__default.ECDH__PROVIDER__INFO__256__LEN()))) || Objects.equals(BigInteger.valueOf(p.length()), BigInteger.valueOf(Integer.toUnsignedLong(Constants_Compile.__default.ECDH__PROVIDER__INFO__384__LEN()))) || Objects.equals(BigInteger.valueOf(p.length()), BigInteger.valueOf(Integer.toUnsignedLong(Constants_Compile.__default.ECDH__PROVIDER__INFO__521__LEN())));
    }

    public static Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> LocalDeriveSharedSecret(ECCPrivateKey senderPrivateKey, ECCPublicKey recipientPublicKey, ECDHCurveSpec curveSpec, AtomicPrimitivesClient crypto) {
        Result<DeriveSharedSecretOutput, Error> _out205;
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DeriveSharedSecretOutput, Error> _1207_maybeSharedSecret = _out205 = crypto.DeriveSharedSecret(DeriveSharedSecretInput.create(curveSpec, senderPrivateKey, recipientPublicKey));
        Result<DeriveSharedSecretOutput, Object> _1209_valueOrError0 = Result.Default(DeriveSharedSecretOutput.Default());
        _1209_valueOrError0 = _1207_maybeSharedSecret.MapFailure(DeriveSharedSecretOutput._typeDescriptor(), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _1210_e_boxed0 -> {
            Error _1210_e = _1210_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_1210_e);
        });
        if (_1209_valueOrError0.IsFailure(DeriveSharedSecretOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _1209_valueOrError0.PropagateFailure(DeriveSharedSecretOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return res;
        }
        DeriveSharedSecretOutput _1208_sharedSecretOutput = _1209_valueOrError0.Extract(DeriveSharedSecretOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        res = Result.create_Success(_1208_sharedSecretOutput.dtor_sharedSecret());
        return res;
    }

    public static Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> CompressPublicKey(ECCPublicKey publicKey, ECDHCurveSpec curveSpec, AtomicPrimitivesClient crypto) {
        Result<CompressPublicKeyOutput, Error> _out206;
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<CompressPublicKeyOutput, Error> _1211_maybeCompressedPublicKey = _out206 = crypto.CompressPublicKey(CompressPublicKeyInput.create(publicKey, curveSpec));
        Result<CompressPublicKeyOutput, Object> _1213_valueOrError0 = Result.Default(CompressPublicKeyOutput.Default());
        _1213_valueOrError0 = _1211_maybeCompressedPublicKey.MapFailure(CompressPublicKeyOutput._typeDescriptor(), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _1214_e_boxed0 -> {
            Error _1214_e = _1214_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_1214_e);
        });
        if (_1213_valueOrError0.IsFailure(CompressPublicKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _1213_valueOrError0.PropagateFailure(CompressPublicKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return res;
        }
        CompressPublicKeyOutput _1212_compresedPublicKey = _1213_valueOrError0.Extract(CompressPublicKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        res = Result.create_Success(_1212_compresedPublicKey.dtor_compressedPublicKey());
        return res;
    }

    public static Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> DecompressPublicKey(DafnySequence<? extends Byte> publicKey, ECDHCurveSpec curveSpec, AtomicPrimitivesClient crypto) {
        Result<DecompressPublicKeyOutput, Error> _out207;
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DecompressPublicKeyOutput, Error> _1215_maybePublicKey = _out207 = crypto.DecompressPublicKey(DecompressPublicKeyInput.create(publicKey, curveSpec));
        Result<DecompressPublicKeyOutput, Object> _1217_valueOrError0 = Result.Default(DecompressPublicKeyOutput.Default());
        _1217_valueOrError0 = _1215_maybePublicKey.MapFailure(DecompressPublicKeyOutput._typeDescriptor(), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _1218_e_boxed0 -> {
            Error _1218_e = _1218_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_1218_e);
        });
        if (_1217_valueOrError0.IsFailure(DecompressPublicKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _1217_valueOrError0.PropagateFailure(DecompressPublicKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return res;
        }
        DecompressPublicKeyOutput _1216_publicKey = _1217_valueOrError0.Extract(DecompressPublicKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        res = Result.create_Success(_1216_publicKey.dtor_publicKey().dtor_der());
        return res;
    }

    public static DafnySequence<? extends Byte> SerializeProviderInfo(DafnySequence<? extends Byte> senderPublicKey, DafnySequence<? extends Byte> recipientPublicKey) {
        return DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(__default.RAW__ECDH__KEYRING__VERSION(), StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(recipientPublicKey.cardinalityInt())), recipientPublicKey), StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(senderPublicKey.cardinalityInt())), senderPublicKey);
    }

    public static Result<GenerateECCKeyPairOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GenerateEphemeralEccKeyPair(ECDHCurveSpec curveSpec, AtomicPrimitivesClient crypto) {
        Result<GenerateECCKeyPairOutput, Error> _out208;
        Result<GenerateECCKeyPairOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = Result.Default(GenerateECCKeyPairOutput.Default());
        Result<GenerateECCKeyPairOutput, Error> _1219_maybeKeyPair = _out208 = crypto.GenerateECCKeyPair(GenerateECCKeyPairInput.create(curveSpec));
        Result<GenerateECCKeyPairOutput, Object> _1221_valueOrError0 = Result.Default(GenerateECCKeyPairOutput.Default());
        _1221_valueOrError0 = _1219_maybeKeyPair.MapFailure(GenerateECCKeyPairOutput._typeDescriptor(), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _1222_e_boxed0 -> {
            Error _1222_e = _1222_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_1222_e);
        });
        if (_1221_valueOrError0.IsFailure(GenerateECCKeyPairOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _1221_valueOrError0.PropagateFailure(GenerateECCKeyPairOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), GenerateECCKeyPairOutput._typeDescriptor());
            return res;
        }
        GenerateECCKeyPairOutput _1220_keyPair = _1221_valueOrError0.Extract(GenerateECCKeyPairOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        res = Result.create_Success(_1220_keyPair);
        return res;
    }

    public static Result<Boolean, software.amazon.cryptography.materialproviders.internaldafny.types.Error> ValidatePublicKey(AtomicPrimitivesClient crypto, ECDHCurveSpec curveSpec, DafnySequence<? extends Byte> publicKey) {
        Result<ValidatePublicKeyOutput, Error> _out209;
        Result<Boolean, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = Result.Default(false);
        Result<ValidatePublicKeyOutput, Error> _1223_maybeValidate = _out209 = crypto.ValidatePublicKey(ValidatePublicKeyInput.create(curveSpec, publicKey));
        Result<ValidatePublicKeyOutput, Object> _1225_valueOrError0 = Result.Default(ValidatePublicKeyOutput.Default());
        _1225_valueOrError0 = _1223_maybeValidate.MapFailure(ValidatePublicKeyOutput._typeDescriptor(), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _1226_e_boxed0 -> {
            Error _1226_e = _1226_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_1226_e);
        });
        if (_1225_valueOrError0.IsFailure(ValidatePublicKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _1225_valueOrError0.PropagateFailure(ValidatePublicKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return res;
        }
        ValidatePublicKeyOutput _1224_validate = _1225_valueOrError0.Extract(ValidatePublicKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        res = Result.create_Success(_1224_validate.dtor_success());
        return res;
    }

    public static DafnySequence<? extends Character> CurveSpecTypeToString(ECDHCurveSpec c) {
        ECDHCurveSpec _source34 = c;
        if (_source34.is_ECC__NIST__P256()) {
            return DafnySequence.asString((String)"p256");
        }
        if (_source34.is_ECC__NIST__P384()) {
            return DafnySequence.asString((String)"p384");
        }
        if (_source34.is_ECC__NIST__P521()) {
            return DafnySequence.asString((String)"p521");
        }
        return DafnySequence.asString((String)"sm2");
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.Error E(DafnySequence<? extends Character> s) {
        return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException(s);
    }

    public static DafnySequence<? extends Byte> RAW__ECDH__KEYRING__VERSION() {
        return DafnySequence.of((byte[])new byte[]{1});
    }

    public String toString() {
        return "RawECDHKeyring._default";
    }
}

