/*
 * Decompiled with CFR 0.152.
 */
package RawAESKeyring_Compile;

import BoundedInts_Compile.uint8;
import EdkWrapping_Compile.UnwrapEdkMaterialOutput;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import RawAESKeyring_Compile.AesGenerateAndWrapKeyMaterial;
import RawAESKeyring_Compile.AesUnwrapInfo;
import RawAESKeyring_Compile.AesUnwrapKeyMaterial;
import RawAESKeyring_Compile.AesWrapInfo;
import RawAESKeyring_Compile.AesWrapKeyMaterial;
import RawAESKeyring_Compile.__default;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.AES__GCM;

public class RawAESKeyring
implements VerifiableInterface,
IKeyring {
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public DafnySequence<? extends Byte> _wrappingKey = DafnySequence.empty(uint8._typeDescriptor());
    public AES__GCM _wrappingAlgorithm = null;
    public DafnySequence<? extends Byte> _keyNamespace = ValidUTF8Bytes.defaultValue();
    public DafnySequence<? extends Byte> _keyName = ValidUTF8Bytes.defaultValue();
    private static final TypeDescriptor<RawAESKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(RawAESKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out238 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out238;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out239 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out239;
    }

    public void __ctor(DafnySequence<? extends Byte> namespace, DafnySequence<? extends Byte> name, DafnySequence<? extends Byte> key, AES__GCM wrappingAlgorithm, AtomicPrimitivesClient cryptoPrimitives) {
        this._keyNamespace = namespace;
        this._keyName = name;
        this._wrappingKey = key;
        this._wrappingAlgorithm = wrappingAlgorithm;
        this._cryptoPrimitives = cryptoPrimitives;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> output = null;
        EncryptionMaterials _1412_materials = input.dtor_materials();
        AlgorithmSuiteInfo _1413_suite = _1412_materials.dtor_algorithmSuite();
        AesWrapKeyMaterial _nw56 = new AesWrapKeyMaterial();
        _nw56.__ctor(this.wrappingKey(), this.wrappingAlgorithm(), this.cryptoPrimitives());
        AesWrapKeyMaterial _1414_wrap = _nw56;
        AesGenerateAndWrapKeyMaterial _nw57 = new AesGenerateAndWrapKeyMaterial();
        _nw57.__ctor(_1414_wrap);
        AesGenerateAndWrapKeyMaterial _1415_generateAndWrap = _nw57;
        Result<WrapEdkMaterialOutput<AesWrapInfo>, Object> _1417_valueOrError0 = Result.Default(WrapEdkMaterialOutput.Default(AesWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<AesWrapInfo>, Error> _out240 = EdkWrapping_Compile.__default.WrapEdkMaterial(AesWrapInfo._typeDescriptor(), _1412_materials, _1414_wrap, _1415_generateAndWrap);
        _1417_valueOrError0 = _out240;
        if (_1417_valueOrError0.IsFailure(WrapEdkMaterialOutput._typeDescriptor(AesWrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            output = _1417_valueOrError0.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(AesWrapInfo._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return output;
        }
        WrapEdkMaterialOutput<AesWrapInfo> _1416_wrapOutput = _1417_valueOrError0.Extract(WrapEdkMaterialOutput._typeDescriptor(AesWrapInfo._typeDescriptor()), Error._typeDescriptor());
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _1418_symmetricSigningKeyList = _1416_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_1416_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None();
        EncryptedDataKey _1419_edk = EncryptedDataKey.create(this.keyNamespace(), this.SerializeProviderInfo(_1416_wrapOutput.dtor_wrapInfo().dtor_iv()), _1416_wrapOutput.dtor_wrappedMaterial());
        if (_1416_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _1421_valueOrError1 = null;
            _1421_valueOrError1 = Materials_Compile.__default.EncryptionMaterialAddDataKey(_1412_materials, _1416_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_1419_edk}), _1418_symmetricSigningKeyList);
            if (_1421_valueOrError1.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                output = _1421_valueOrError1.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return output;
            }
            EncryptionMaterials _1420_result = _1421_valueOrError1.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            output = Result.create_Success(OnEncryptOutput.create(_1420_result));
            return output;
        }
        if (_1416_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _1423_valueOrError2 = null;
            _1423_valueOrError2 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(_1412_materials, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_1419_edk}), _1418_symmetricSigningKeyList);
            if (_1423_valueOrError2.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                output = _1423_valueOrError2.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return output;
            }
            EncryptionMaterials _1422_result = _1423_valueOrError2.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            output = Result.create_Success(OnEncryptOutput.create(_1422_result));
            return output;
        }
        return output;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> output = null;
        DecryptionMaterials _1424_materials = input.dtor_materials();
        Outcome<Object> _1425_valueOrError0 = Outcome.Default();
        _1425_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_1424_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_1425_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _1425_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        Result<Object, Object> _1427_valueOrError1 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _1427_valueOrError1 = CanonicalEncryptionContext_Compile.__default.EncryptionContextToAAD(input.dtor_materials().dtor_encryptionContext());
        if (_1427_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            output = _1427_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        DafnySequence _1426_aad = (DafnySequence)_1427_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        Outcome<Object> _1428_valueOrError2 = Outcome.Default();
        _1428_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Objects.equals(BigInteger.valueOf(this.wrappingKey().length()), BigInteger.valueOf(this.wrappingAlgorithm().dtor_keyLength())), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"The wrapping key does not match the wrapping algorithm")));
        if (_1428_valueOrError2.IsFailure(Error._typeDescriptor())) {
            output = _1428_valueOrError2.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        DafnySequence _1429_errors = DafnySequence.empty(Error._typeDescriptor());
        BigInteger _hi9 = BigInteger.valueOf(input.dtor_encryptedDataKeys().length());
        BigInteger _1430_i = BigInteger.ZERO;
        while (_1430_i.compareTo(_hi9) < 0) {
            if (this.ShouldDecryptEDK((EncryptedDataKey)input.dtor_encryptedDataKeys().select(Helpers.toInt((BigInteger)_1430_i)))) {
                Result<UnwrapEdkMaterialOutput<AesUnwrapInfo>, Error> _out241;
                EncryptedDataKey _1431_edk = (EncryptedDataKey)input.dtor_encryptedDataKeys().select(Helpers.toInt((BigInteger)_1430_i));
                DafnySequence<? extends Byte> _1432_iv = this.GetIvFromProvInfo(_1431_edk.dtor_keyProviderInfo());
                AesUnwrapKeyMaterial _nw58 = new AesUnwrapKeyMaterial();
                _nw58.__ctor(this.wrappingKey(), this.wrappingAlgorithm(), _1432_iv, this.cryptoPrimitives());
                AesUnwrapKeyMaterial _1433_unwrap = _nw58;
                Result<UnwrapEdkMaterialOutput<AesUnwrapInfo>, Error> _1434_unwrapOutput = _out241 = EdkWrapping_Compile.__default.UnwrapEdkMaterial(AesUnwrapInfo._typeDescriptor(), _1431_edk.dtor_ciphertext(), _1424_materials, _1433_unwrap);
                if (_1434_unwrapOutput.is_Success()) {
                    Result<DecryptionMaterials, Error> _1436_valueOrError3 = null;
                    _1436_valueOrError3 = Materials_Compile.__default.DecryptionMaterialsAddDataKey(_1424_materials, _1434_unwrapOutput.dtor_value().dtor_plaintextDataKey(), _1434_unwrapOutput.dtor_value().dtor_symmetricSigningKey());
                    if (_1436_valueOrError3.IsFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                        output = _1436_valueOrError3.PropagateFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                        return output;
                    }
                    DecryptionMaterials _1435_result = _1436_valueOrError3.Extract(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
                    OnDecryptOutput _1437_value = OnDecryptOutput.create(_1435_result);
                    output = Result.create_Success(_1437_value);
                    return output;
                }
                _1429_errors = DafnySequence.concatenate((DafnySequence)_1429_errors, (DafnySequence)DafnySequence.of(Error._typeDescriptor(), (Object[])new Error[]{_1434_unwrapOutput.dtor_error()}));
            } else {
                Result<Object, Object> _1439_valueOrError4 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
                _1439_valueOrError4 = UTF8.__default.Decode(((EncryptedDataKey)input.dtor_encryptedDataKeys().select(Helpers.toInt((BigInteger)_1430_i))).dtor_keyProviderId()).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _1440_e_boxed0 -> {
                    DafnySequence _1440_e = _1440_e_boxed0;
                    return Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_1440_e);
                });
                if (_1439_valueOrError4.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                    output = _1439_valueOrError4.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                    return output;
                }
                DafnySequence _1438_extractedKeyProviderId = (DafnySequence)_1439_valueOrError4.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
                _1429_errors = DafnySequence.concatenate((DafnySequence)_1429_errors, (DafnySequence)DafnySequence.of(Error._typeDescriptor(), (Object[])new Error[]{Error.create_AwsCryptographicMaterialProvidersException(ErrorMessages_Compile.__default.IncorrectRawDataKeys(String_Compile.__default.Base10Int2String(_1430_i), (DafnySequence<? extends Character>)DafnySequence.asString((String)"AESKeyring"), (DafnySequence<? extends Character>)_1438_extractedKeyProviderId))}));
            }
            _1430_i = _1430_i.add(BigInteger.ONE);
        }
        output = Result.create_Failure(Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_1429_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"Raw AES Keyring was unable to decrypt any encrypted data key. The list of encountered Exceptions is avaible via `list`.")));
        return output;
    }

    public DafnySequence<? extends Byte> SerializeProviderInfo(DafnySequence<? extends Byte> iv) {
        return DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(this.keyName(), StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(this.wrappingAlgorithm().dtor_tagLength() * 8)), StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(this.wrappingAlgorithm().dtor_ivLength())), iv);
    }

    public boolean ShouldDecryptEDK(EncryptedDataKey edk) {
        return edk.dtor_keyProviderId().equals(this.keyNamespace()) && this.ValidProviderInfo(edk.dtor_keyProviderInfo());
    }

    public boolean ValidProviderInfo(DafnySequence<? extends Byte> info) {
        return Objects.equals(BigInteger.valueOf(info.length()), BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN()).add(__default.IV__LEN__LEN()).add(BigInteger.valueOf(this.wrappingAlgorithm().dtor_ivLength()))) && info.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()))).equals(this.keyName()) && StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)info.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length())), Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN())))) == 128 && StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)info.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length())), Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN())))) == this.wrappingAlgorithm().dtor_tagLength() * 8 && StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)info.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN())), Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN()).add(__default.IV__LEN__LEN())))) == this.wrappingAlgorithm().dtor_ivLength() && StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)info.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN())), Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN()).add(__default.IV__LEN__LEN())))) == 12;
    }

    public DafnySequence<? extends Byte> GetIvFromProvInfo(DafnySequence<? extends Byte> info) {
        return info.drop(BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN()).add(__default.IV__LEN__LEN()));
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public DafnySequence<? extends Byte> wrappingKey() {
        return this._wrappingKey;
    }

    public AES__GCM wrappingAlgorithm() {
        return this._wrappingAlgorithm;
    }

    public DafnySequence<? extends Byte> keyNamespace() {
        return this._keyNamespace;
    }

    public DafnySequence<? extends Byte> keyName() {
        return this._keyName;
    }

    public static TypeDescriptor<RawAESKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "RawAESKeyring.RawAESKeyring";
    }
}

