/*
 * Decompiled with CFR 0.152.
 */
package RSAEncryption;

import BoundedInts_Compile.int32;
import BoundedInts_Compile.uint32;
import BoundedInts_Compile.uint8;
import RSAEncryption.RSA;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.__default;
import dafny.DafnySequence;
import dafny.Tuple2;
import java.math.BigInteger;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.types.RSADecryptInput;
import software.amazon.cryptography.primitives.internaldafny.types.RSAEncryptInput;
import software.amazon.cryptography.primitives.internaldafny.types.RSAPrivateKey;
import software.amazon.cryptography.primitives.internaldafny.types.RSAPublicKey;

public abstract class _ExternBase___default {
    public static Tuple2 GenerateKeyPair(int lengthBits) {
        RSAPublicKey publicKey = null;
        RSAPrivateKey privateKey = null;
        Tuple2<DafnySequence<? extends Byte>, DafnySequence<? extends Byte>> _outcollector0 = RSA.GenerateKeyPairExtern(lengthBits);
        DafnySequence _out18 = (DafnySequence)_outcollector0.dtor__0();
        DafnySequence _out19 = (DafnySequence)_outcollector0.dtor__1();
        DafnySequence _92_pemPublic = _out18;
        DafnySequence _93_pemPrivate = _out19;
        privateKey = RSAPrivateKey.create(lengthBits, (DafnySequence<? extends Byte>)_93_pemPrivate);
        publicKey = RSAPublicKey.create(lengthBits, (DafnySequence<? extends Byte>)_92_pemPublic);
        return new Tuple2((Object)publicKey, (Object)privateKey);
    }

    public static Result<Integer, Error> GetRSAKeyModulusLength(DafnySequence<? extends Byte> publicKey) {
        Result<Integer, Error> _94_valueOrError0 = RSA.GetRSAKeyModulusLengthExtern(publicKey);
        if (_94_valueOrError0.IsFailure(uint32._typeDescriptor(), Error._typeDescriptor())) {
            return _94_valueOrError0.PropagateFailure(uint32._typeDescriptor(), Error._typeDescriptor(), int32._typeDescriptor());
        }
        int _95_length = _94_valueOrError0.Extract(uint32._typeDescriptor(), Error._typeDescriptor());
        Outcome<Error> _96_valueOrError1 = __default.Need(Error._typeDescriptor(), BigInteger.valueOf(81L).compareTo(BigInteger.valueOf(Integer.toUnsignedLong(_95_length))) <= 0 && BigInteger.valueOf(Integer.toUnsignedLong(_95_length)).compareTo(StandardLibrary_mUInt_Compile.__default.INT32__MAX__LIMIT()) < 0, Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unsupported length for RSA modulus.")));
        if (_96_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _96_valueOrError1.PropagateFailure(Error._typeDescriptor(), int32._typeDescriptor());
        }
        return Result.create_Success(_95_length);
    }

    public static Result<DafnySequence<? extends Byte>, Error> Decrypt(RSADecryptInput input) {
        Result<DafnySequence<? extends Byte>, Error> output = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Outcome<Object> _97_valueOrError0 = Outcome.Default();
        _97_valueOrError0 = __default.Need(Error._typeDescriptor(), BigInteger.valueOf(input.dtor_privateKey().length()).signum() == 1 && BigInteger.valueOf(input.dtor_cipherText().length()).signum() == 1, Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"")));
        if (_97_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _97_valueOrError0.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return output;
        }
        Result<DafnySequence<? extends Byte>, Error> _out20 = RSA.DecryptExtern(input.dtor_padding(), input.dtor_privateKey(), input.dtor_cipherText());
        output = _out20;
        return output;
    }

    public static Result<DafnySequence<? extends Byte>, Error> Encrypt(RSAEncryptInput input) {
        Result<DafnySequence<? extends Byte>, Error> output = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Outcome<Object> _98_valueOrError0 = Outcome.Default();
        _98_valueOrError0 = __default.Need(Error._typeDescriptor(), BigInteger.valueOf(input.dtor_publicKey().length()).signum() == 1 && BigInteger.valueOf(input.dtor_plaintext().length()).signum() == 1, Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"")));
        if (_98_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _98_valueOrError0.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return output;
        }
        Result<DafnySequence<? extends Byte>, Error> _out21 = RSA.EncryptExtern(input.dtor_padding(), input.dtor_publicKey(), input.dtor_plaintext());
        output = _out21;
        return output;
    }

    public static Result<Integer, Error> CreateGetRSAKeyModulusLengthExternSuccess(int output) {
        return Result.create_Success(output);
    }

    public static Result<Integer, Error> CreateGetRSAKeyModulusLengthExternFailure(Error error) {
        return Result.create_Failure(error);
    }

    public static Result<DafnySequence<? extends Byte>, Error> CreateBytesSuccess(DafnySequence<? extends Byte> bytes) {
        return Result.create_Success(bytes);
    }

    public static Result<DafnySequence<? extends Byte>, Error> CreateBytesFailure(Error error) {
        return Result.create_Failure(error);
    }

    public String toString() {
        return "RSAEncryption._default";
    }
}

