/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsEcdhKeyring_Compile;

import Actions_Compile.Action;
import Actions_Compile.ActionWithResult;
import AwsKmsEcdhKeyring_Compile.__default;
import BoundedInts_Compile.uint8;
import EcdhEdkWrapping_Compile.EcdhUnwrap;
import EcdhEdkWrapping_Compile.EcdhUnwrapInfo;
import EdkWrapping_Compile.UnwrapEdkMaterialOutput;
import Materials_Compile.SealedDecryptionMaterials;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.Tuple0;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.KmsEcdhStaticConfigurations;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class DecryptSingleEncryptedDataKey
implements ActionWithResult<EncryptedDataKey, DecryptionMaterials, Error>,
Action<EncryptedDataKey, Result<DecryptionMaterials, Error>> {
    public DecryptionMaterials _materials = null;
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public DafnySequence<? extends Byte> _recipientPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    public KmsEcdhStaticConfigurations _keyAgreementScheme = KmsEcdhStaticConfigurations.Default();
    public IKMSClient _client = null;
    public ECDHCurveSpec _curveSpec = ECDHCurveSpec.Default();
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    public DafnySequence<? extends Byte> _senderPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    private static final TypeDescriptor<DecryptSingleEncryptedDataKey> _TYPE = TypeDescriptor.referenceWithInitializer(DecryptSingleEncryptedDataKey.class, () -> null);

    public void __ctor(DecryptionMaterials materials, AtomicPrimitivesClient cryptoPrimitives, DafnySequence<? extends Byte> recipientPublicKey, IKMSClient client, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens, KmsEcdhStaticConfigurations keyAgreementScheme, ECDHCurveSpec curveSpec) {
        this._materials = materials;
        this._cryptoPrimitives = cryptoPrimitives;
        this._recipientPublicKey = recipientPublicKey;
        this._keyAgreementScheme = keyAgreementScheme;
        this._client = client;
        this._curveSpec = curveSpec;
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<DecryptionMaterials, Error> Invoke(EncryptedDataKey edk) {
        Result<UnwrapEdkMaterialOutput<EcdhUnwrapInfo>, Error> _out237;
        Result<DecryptionMaterials, Error> res = null;
        Outcome<Object> _1361_valueOrError0 = Outcome.Default();
        _1361_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), UTF8.__default.ValidUTF8Seq(edk.dtor_keyProviderId()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Received invalid EDK provider id for AWS KMS ECDH Keyring")));
        if (_1361_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _1361_valueOrError0.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        AlgorithmSuiteInfo _1362_suite = this.materials().dtor_algorithmSuite();
        DafnySequence<? extends Byte> _1363_keyProviderId = edk.dtor_keyProviderId();
        DafnySequence<? extends Byte> _1364_providerInfo = edk.dtor_keyProviderInfo();
        DafnySequence<? extends Byte> _1365_ciphertext = edk.dtor_ciphertext();
        Result<Object, Object> _1367_valueOrError1 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _1367_valueOrError1 = EdkWrapping_Compile.__default.GetProviderWrappedMaterial(_1365_ciphertext, _1362_suite);
        if (_1367_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _1367_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _1366_providerWrappedMaterial = (DafnySequence)_1367_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        Outcome<Object> _1368_valueOrError2 = Outcome.Default();
        _1368_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_1364_providerInfo.length()).compareTo(BigInteger.valueOf(Integer.toUnsignedLong(Constants_Compile.__default.ECDH__PROVIDER__INFO__521__LEN()))) <= 0 && RawECDHKeyring_Compile.__default.ValidProviderInfoLength(_1364_providerInfo), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"EDK ProviderInfo longer than expected")));
        if (_1368_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _1368_valueOrError2.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        byte _1369_keyringVersion = (Byte)_1364_providerInfo.select(Helpers.toInt((BigInteger)BigInteger.ZERO));
        Outcome<Object> _1370_valueOrError3 = Outcome.Default();
        _1370_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), DafnySequence.of((byte[])new byte[]{_1369_keyringVersion}).equals(__default.AWS__KMS__ECDH__KEYRING__VERSION()), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Incorrect Keyring version found in provider info.")));
        if (_1370_valueOrError3.IsFailure(Error._typeDescriptor())) {
            res = _1370_valueOrError3.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        BigInteger _1371_recipientPublicKeyLength = BigInteger.ZERO;
        _1371_recipientPublicKeyLength = BigInteger.valueOf(Integer.toUnsignedLong(StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)_1364_providerInfo.subsequence(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPL__INDEX(), Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX()))));
        BigInteger _1372_recipientPublicKeyLengthIndex = BigInteger.ZERO;
        _1372_recipientPublicKeyLengthIndex = BigInteger.valueOf(Integer.toUnsignedLong(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX())).add(_1371_recipientPublicKeyLength);
        BigInteger _1373_senderPublicKeyIndex = BigInteger.ZERO;
        _1373_senderPublicKeyIndex = _1372_recipientPublicKeyLengthIndex.add(Constants_Compile.__default.ECDH__PROVIDER__INFO__PUBLIC__KEY__LEN());
        Outcome<Object> _1374_valueOrError4 = Outcome.Default();
        _1374_valueOrError4 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _1372_recipientPublicKeyLengthIndex.add(BigInteger.valueOf(4L)).compareTo(BigInteger.valueOf(_1364_providerInfo.length())) < 0, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Key Provider Info Serialization Error. Serialized length less than expected.")));
        if (_1374_valueOrError4.IsFailure(Error._typeDescriptor())) {
            res = _1374_valueOrError4.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _1375_providerInfoRecipientPublicKey = _1364_providerInfo.subsequence(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX(), Helpers.toInt((BigInteger)_1372_recipientPublicKeyLengthIndex));
        DafnySequence _1376_providerInfoSenderPublicKey = _1364_providerInfo.drop(_1373_senderPublicKeyIndex);
        Result<Object, Object> _1378_valueOrError5 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out232 = RawECDHKeyring_Compile.__default.DecompressPublicKey((DafnySequence<? extends Byte>)_1376_providerInfoSenderPublicKey, this.curveSpec(), this.cryptoPrimitives());
        _1378_valueOrError5 = _out232;
        if (_1378_valueOrError5.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _1378_valueOrError5.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _1377_senderPublicKey = (DafnySequence)_1378_valueOrError5.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        Result<Object, Object> _1380_valueOrError6 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out233 = RawECDHKeyring_Compile.__default.DecompressPublicKey((DafnySequence<? extends Byte>)_1375_providerInfoRecipientPublicKey, this.curveSpec(), this.cryptoPrimitives());
        _1380_valueOrError6 = _out233;
        if (_1380_valueOrError6.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _1380_valueOrError6.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _1379_recipientPublicKey = (DafnySequence)_1380_valueOrError6.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        Result<Boolean, Object> _1382_valueOrError7 = Result.Default(false);
        Result<Boolean, Error> _out234 = RawECDHKeyring_Compile.__default.ValidatePublicKey(this.cryptoPrimitives(), this.curveSpec(), (DafnySequence<? extends Byte>)_1377_senderPublicKey);
        _1382_valueOrError7 = _out234;
        if (_1382_valueOrError7.IsFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor())) {
            res = _1382_valueOrError7.PropagateFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        boolean _1381___v0 = _1382_valueOrError7.Extract((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor());
        Result<Boolean, Object> _1384_valueOrError8 = Result.Default(false);
        Result<Boolean, Error> _out235 = RawECDHKeyring_Compile.__default.ValidatePublicKey(this.cryptoPrimitives(), this.curveSpec(), (DafnySequence<? extends Byte>)_1379_recipientPublicKey);
        _1384_valueOrError8 = _out235;
        if (_1384_valueOrError8.IsFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor())) {
            res = _1384_valueOrError8.PropagateFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        boolean _1383___v1 = _1384_valueOrError8.Extract((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor());
        Outcome<Object> _1385_valueOrError9 = Outcome.Default();
        _1385_valueOrError9 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__PublicKeyType((DafnySequence<? extends Byte>)_1377_senderPublicKey) && software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__PublicKeyType(this.recipientPublicKey()), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Received serialized sender public key of incorrect length")));
        if (_1385_valueOrError9.IsFailure(Error._typeDescriptor())) {
            res = _1385_valueOrError9.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _1386_sharedSecretPublicKey = DafnySequence.empty(uint8._typeDescriptor());
        DafnySequence<? extends Character> _1387_sharedSecretKmsKeyId = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
        if (this.keyAgreementScheme().is_KmsPublicKeyDiscovery()) {
            Result<Tuple0, Object> _1389_valueOrError10 = Result.Default(Tuple0.Default());
            _1389_valueOrError10 = AwsKmsUtils_Compile.__default.ValidateKmsKeyId(this.keyAgreementScheme().dtor_KmsPublicKeyDiscovery().dtor_recipientKmsIdentifier());
            if (_1389_valueOrError10.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor())) {
                res = _1389_valueOrError10.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
                return res;
            }
            Tuple0 _1388___v2 = _1389_valueOrError10.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor());
            _1386_sharedSecretPublicKey = _1377_senderPublicKey;
            _1387_sharedSecretKmsKeyId = this.keyAgreementScheme().dtor_KmsPublicKeyDiscovery().dtor_recipientKmsIdentifier();
        } else if (this.keyAgreementScheme().is_KmsPrivateKeyToStaticPublicKey()) {
            Result<Tuple0, Object> _1391_valueOrError11 = Result.Default(Tuple0.Default());
            _1391_valueOrError11 = AwsKmsUtils_Compile.__default.ValidateKmsKeyId(this.keyAgreementScheme().dtor_KmsPrivateKeyToStaticPublicKey().dtor_senderKmsIdentifier());
            if (_1391_valueOrError11.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor())) {
                res = _1391_valueOrError11.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
                return res;
            }
            Tuple0 _1390___v3 = _1391_valueOrError11.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor());
            _1387_sharedSecretKmsKeyId = this.keyAgreementScheme().dtor_KmsPrivateKeyToStaticPublicKey().dtor_senderKmsIdentifier();
            _1386_sharedSecretPublicKey = this.keyAgreementScheme().dtor_KmsPrivateKeyToStaticPublicKey().dtor_recipientPublicKey().equals((Object)_1379_recipientPublicKey) ? _1379_recipientPublicKey : _1377_senderPublicKey;
        } else {
            throw new IllegalArgumentException("unreachable alternative");
        }
        Result<Object, Object> _1393_valueOrError12 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out236 = __default.DeriveSharedSecret(this.client(), _1387_sharedSecretKmsKeyId, (DafnySequence<? extends Byte>)_1386_sharedSecretPublicKey, this.grantTokens());
        _1393_valueOrError12 = _out236;
        if (_1393_valueOrError12.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _1393_valueOrError12.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _1392_sharedSecret = (DafnySequence)_1393_valueOrError12.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        EcdhUnwrap _nw55 = new EcdhUnwrap();
        _nw55.__ctor((DafnySequence<? extends Byte>)_1376_providerInfoSenderPublicKey, (DafnySequence<? extends Byte>)_1375_providerInfoRecipientPublicKey, (DafnySequence<? extends Byte>)_1392_sharedSecret, __default.AWS__KMS__ECDH__KEYRING__VERSION(), this.curveSpec(), this.cryptoPrimitives());
        EcdhUnwrap _1394_ecdhUnwrap = _nw55;
        Result<UnwrapEdkMaterialOutput<EcdhUnwrapInfo>, Error> _1395_unwrapOutputRes = _out237 = EdkWrapping_Compile.__default.UnwrapEdkMaterial(EcdhUnwrapInfo._typeDescriptor(), edk.dtor_ciphertext(), this.materials(), _1394_ecdhUnwrap);
        Result<UnwrapEdkMaterialOutput<EcdhUnwrapInfo>, Object> _1397_valueOrError13 = Result.Default(UnwrapEdkMaterialOutput.Default(EcdhUnwrapInfo.Default()));
        _1397_valueOrError13 = _1395_unwrapOutputRes;
        if (_1397_valueOrError13.IsFailure(UnwrapEdkMaterialOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            res = _1397_valueOrError13.PropagateFailure(UnwrapEdkMaterialOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        UnwrapEdkMaterialOutput<EcdhUnwrapInfo> _1396_unwrapOutput = _1397_valueOrError13.Extract(UnwrapEdkMaterialOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()), Error._typeDescriptor());
        Result<DecryptionMaterials, Error> _1399_valueOrError14 = null;
        _1399_valueOrError14 = Materials_Compile.__default.DecryptionMaterialsAddDataKey(this.materials(), _1396_unwrapOutput.dtor_plaintextDataKey(), _1396_unwrapOutput.dtor_symmetricSigningKey());
        if (_1399_valueOrError14.IsFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
            res = _1399_valueOrError14.PropagateFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DecryptionMaterials _1398_result = _1399_valueOrError14.Extract(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        res = Result.create_Success(_1398_result);
        return res;
    }

    public DecryptionMaterials materials() {
        return this._materials;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public DafnySequence<? extends Byte> recipientPublicKey() {
        return this._recipientPublicKey;
    }

    public KmsEcdhStaticConfigurations keyAgreementScheme() {
        return this._keyAgreementScheme;
    }

    public IKMSClient client() {
        return this._client;
    }

    public ECDHCurveSpec curveSpec() {
        return this._curveSpec;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public DafnySequence<? extends Byte> senderPublicKey() {
        return this._senderPublicKey;
    }

    public static TypeDescriptor<DecryptSingleEncryptedDataKey> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsEcdhKeyring.DecryptSingleEncryptedDataKey";
    }
}

