/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsEcdhKeyring_Compile;

import AwsKmsEcdhKeyring_Compile.DecryptSingleEncryptedDataKey;
import AwsKmsEcdhKeyring_Compile.OnDecryptEcdhDataKeyFilter;
import AwsKmsEcdhKeyring_Compile.__default;
import BoundedInts_Compile.uint8;
import EcdhEdkWrapping_Compile.EcdhGenerateAndWrapKeyMaterial;
import EcdhEdkWrapping_Compile.EcdhWrapInfo;
import EcdhEdkWrapping_Compile.EcdhWrapKeyMaterial;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import Materials_Compile.SealedDecryptionMaterials;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.KmsEcdhStaticConfigurations;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class AwsKmsEcdhKeyring
implements VerifiableInterface,
IKeyring {
    public IKMSClient _client = null;
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public KmsEcdhStaticConfigurations _keyAgreementScheme = KmsEcdhStaticConfigurations.Default();
    public ECDHCurveSpec _curveSpec = ECDHCurveSpec.Default();
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    public DafnySequence<? extends Byte> _recipientPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    public Option<DafnySequence<? extends Byte>> _senderPublicKey = Option.Default();
    public Option<DafnySequence<? extends Byte>> _compressedSenderPublicKey = Option.Default();
    public DafnySequence<? extends Byte> _compressedRecipientPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    public Option<DafnySequence<? extends Character>> _senderKmsKeyId = Option.Default();
    private static final TypeDescriptor<AwsKmsEcdhKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsEcdhKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out226 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out226;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out227 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out227;
    }

    public void __ctor(KmsEcdhStaticConfigurations KeyAgreementScheme2, ECDHCurveSpec curveSpec, IKMSClient client, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens, Option<DafnySequence<? extends Character>> senderKmsKeyId, Option<DafnySequence<? extends Byte>> senderPublicKey, DafnySequence<? extends Byte> recipientPublicKey, Option<DafnySequence<? extends Byte>> compressedSenderPublicKey, DafnySequence<? extends Byte> compressedRecipientPublicKey, AtomicPrimitivesClient cryptoPrimitives) {
        this._keyAgreementScheme = KeyAgreementScheme2;
        this._curveSpec = curveSpec;
        this._client = client;
        this._grantTokens = grantTokens;
        this._recipientPublicKey = recipientPublicKey;
        this._senderPublicKey = senderPublicKey;
        this._compressedSenderPublicKey = compressedSenderPublicKey;
        this._compressedRecipientPublicKey = compressedRecipientPublicKey;
        this._senderKmsKeyId = senderKmsKeyId;
        this._cryptoPrimitives = cryptoPrimitives;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> res = null;
        Outcome<Object> _1321_valueOrError0 = Outcome.Default();
        _1321_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), !this.keyAgreementScheme().is_KmsPublicKeyDiscovery(), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"KmsPublicKeyDiscovery Key Agreement Scheme is forbidden on encrypt.")));
        if (_1321_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _1321_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        Outcome<Object> _1322_valueOrError1 = Outcome.Default();
        _1322_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), this.senderKmsKeyId().is_Some(), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring MUST be configured with a sender KMS Key ID")));
        if (_1322_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _1322_valueOrError1.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        Outcome<Object> _1323_valueOrError2 = Outcome.Default();
        _1323_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), this.senderPublicKey().is_Some(), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring MUST be configured with a senderPublicKey")));
        if (_1323_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _1323_valueOrError2.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence<? extends Character> _1324_senderKmsKeyId = this.senderKmsKeyId().dtor_value();
        EncryptionMaterials _1325_materials = input.dtor_materials();
        AlgorithmSuiteInfo _1326_suite = input.dtor_materials().dtor_algorithmSuite();
        Result<Object, Object> _1328_valueOrError3 = Result.Default(DafnyMap.empty());
        _1328_valueOrError3 = AwsKmsUtils_Compile.__default.StringifyEncryptionContext(input.dtor_materials().dtor_encryptionContext());
        if (_1328_valueOrError3.IsFailure((TypeDescriptor<DafnyMap>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor())) {
            res = _1328_valueOrError3.PropagateFailure((TypeDescriptor<Object>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnyMap _1327_stringifiedEncCtx = (DafnyMap)_1328_valueOrError3.Extract((TypeDescriptor<Object>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor());
        Result<Object, Object> _1330_valueOrError4 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out228 = __default.DeriveSharedSecret(this.client(), _1324_senderKmsKeyId, this.recipientPublicKey(), this.grantTokens());
        _1330_valueOrError4 = _out228;
        if (_1330_valueOrError4.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _1330_valueOrError4.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _1329_sharedSecret = (DafnySequence)_1330_valueOrError4.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        DafnySequence<? extends Byte> _1331_operationCompressedSenderPublicKey = this.compressedSenderPublicKey().is_None() ? DafnySequence.empty(uint8._typeDescriptor()) : this.compressedSenderPublicKey().dtor_value();
        Result<DafnySequence<? extends Byte>, Object> _1333_valueOrError5 = Result.Default(ValidUTF8Bytes.defaultValue());
        _1333_valueOrError5 = UTF8.__default.Encode(RawECDHKeyring_Compile.__default.CurveSpecTypeToString(this.curveSpec())).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_1333_valueOrError5.IsFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor())) {
            res = _1333_valueOrError5.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence<? extends Byte> _1332_curveSpecUtf8 = _1333_valueOrError5.Extract(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor());
        Result<Object, Object> _1335_valueOrError6 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _1335_valueOrError6 = CanonicalEncryptionContext_Compile.__default.EncryptionContextToAAD(input.dtor_materials().dtor_encryptionContext());
        if (_1335_valueOrError6.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _1335_valueOrError6.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _1334_canonicalizedEC = (DafnySequence)_1335_valueOrError6.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        DafnySequence<? extends Byte> _1336_fixedInfo = EcdhEdkWrapping_Compile.__default.SerializeFixedInfo(Constants_Compile.__default.ECDH__KDF__UTF8(), _1332_curveSpecUtf8, _1331_operationCompressedSenderPublicKey, this.compressedRecipientPublicKey(), (DafnySequence<? extends Byte>)_1334_canonicalizedEC, __default.AWS__KMS__ECDH__KEYRING__VERSION());
        EcdhGenerateAndWrapKeyMaterial _nw51 = new EcdhGenerateAndWrapKeyMaterial();
        _nw51.__ctor((DafnySequence<? extends Byte>)_1329_sharedSecret, _1336_fixedInfo, this.cryptoPrimitives());
        EcdhGenerateAndWrapKeyMaterial _1337_ecdhGenerateAndWrap = _nw51;
        EcdhWrapKeyMaterial _nw52 = new EcdhWrapKeyMaterial();
        _nw52.__ctor((DafnySequence<? extends Byte>)_1329_sharedSecret, _1336_fixedInfo, this.cryptoPrimitives());
        EcdhWrapKeyMaterial _1338_ecdhWrap = _nw52;
        Result<WrapEdkMaterialOutput<EcdhWrapInfo>, Object> _1340_valueOrError7 = Result.Default(WrapEdkMaterialOutput.Default(EcdhWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<EcdhWrapInfo>, Error> _out229 = EdkWrapping_Compile.__default.WrapEdkMaterial(EcdhWrapInfo._typeDescriptor(), _1325_materials, _1338_ecdhWrap, _1337_ecdhGenerateAndWrap);
        _1340_valueOrError7 = _out229;
        if (_1340_valueOrError7.IsFailure(WrapEdkMaterialOutput._typeDescriptor(EcdhWrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            res = _1340_valueOrError7.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(EcdhWrapInfo._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        WrapEdkMaterialOutput<EcdhWrapInfo> _1339_wrapOutput = _1340_valueOrError7.Extract(WrapEdkMaterialOutput._typeDescriptor(EcdhWrapInfo._typeDescriptor()), Error._typeDescriptor());
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _1341_symmetricSigningKeyList = _1339_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_1339_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None();
        Outcome<Object> _1342_valueOrError8 = Outcome.Default();
        _1342_valueOrError8 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), RawECDHKeyring_Compile.__default.ValidCompressedPublicKeyLength(_1331_operationCompressedSenderPublicKey) && RawECDHKeyring_Compile.__default.ValidCompressedPublicKeyLength(this.compressedRecipientPublicKey()), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid compressed public key length.")));
        if (_1342_valueOrError8.IsFailure(Error._typeDescriptor())) {
            res = _1342_valueOrError8.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        EncryptedDataKey _1343_edk = EncryptedDataKey.create(Constants_Compile.__default.KMS__ECDH__PROVIDER__ID(), RawECDHKeyring_Compile.__default.SerializeProviderInfo(_1331_operationCompressedSenderPublicKey, this.compressedRecipientPublicKey()), _1339_wrapOutput.dtor_wrappedMaterial());
        if (_1339_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _1345_valueOrError9 = null;
            _1345_valueOrError9 = Materials_Compile.__default.EncryptionMaterialAddDataKey(_1325_materials, _1339_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_1343_edk}), _1341_symmetricSigningKeyList);
            if (_1345_valueOrError9.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _1345_valueOrError9.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _1344_result = _1345_valueOrError9.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput.create(_1344_result));
            return res;
        }
        if (_1339_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _1347_valueOrError10 = null;
            _1347_valueOrError10 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(_1325_materials, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_1343_edk}), _1341_symmetricSigningKeyList);
            if (_1347_valueOrError10.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _1347_valueOrError10.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _1346_result = _1347_valueOrError10.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput.create(_1346_result));
            return res;
        }
        return res;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<Error>> _out231;
        Result<OnDecryptOutput, Error> res = null;
        DecryptionMaterials _1348_materials = input.dtor_materials();
        AlgorithmSuiteInfo _1349_suite = input.dtor_materials().dtor_algorithmSuite();
        Outcome<Object> _1350_valueOrError0 = Outcome.Default();
        _1350_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_1348_materials), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_1350_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _1350_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        OnDecryptEcdhDataKeyFilter _nw53 = new OnDecryptEcdhDataKeyFilter();
        _nw53.__ctor(this.keyAgreementScheme(), this.compressedRecipientPublicKey(), this.compressedSenderPublicKey());
        OnDecryptEcdhDataKeyFilter _1351_filter = _nw53;
        Result<Object, Object> _1353_valueOrError1 = Result.Default(DafnySequence.empty(EncryptedDataKey._typeDescriptor()));
        Result<DafnySequence<? extends EncryptedDataKey>, Error> _out230 = Actions_Compile.__default.FilterWithResult(EncryptedDataKey._typeDescriptor(), Error._typeDescriptor(), _1351_filter, input.dtor_encryptedDataKeys());
        _1353_valueOrError1 = _out230;
        if (_1353_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor())) {
            res = _1353_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _1352_edksToAttempt = (DafnySequence)_1353_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor());
        if (BigInteger.valueOf(_1352_edksToAttempt.length()).signum() == 0) {
            Result<Object, Object> _1355_valueOrError2 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _1355_valueOrError2 = ErrorMessages_Compile.__default.IncorrectDataKeys(input.dtor_encryptedDataKeys(), input.dtor_materials().dtor_algorithmSuite(), (DafnySequence<? extends Character>)DafnySequence.asString((String)""));
            if (_1355_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                res = _1355_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                return res;
            }
            DafnySequence _1354_errorMessage = (DafnySequence)_1355_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
            res = Result.create_Failure(__default.E((DafnySequence<? extends Character>)_1354_errorMessage));
            return res;
        }
        DecryptSingleEncryptedDataKey _nw54 = new DecryptSingleEncryptedDataKey();
        _nw54.__ctor(_1348_materials, this.cryptoPrimitives(), this.compressedRecipientPublicKey(), this.client(), this.grantTokens(), this.keyAgreementScheme(), this.curveSpec());
        DecryptSingleEncryptedDataKey _1356_decryptClosure = _nw54;
        Result<DecryptionMaterials, DafnySequence<Error>> _1357_outcome = _out231 = Actions_Compile.__default.ReduceToSuccess(EncryptedDataKey._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _1356_decryptClosure, _1352_edksToAttempt);
        Result<DecryptionMaterials, Error> _1359_valueOrError3 = null;
        _1359_valueOrError3 = _1357_outcome.MapFailure(SealedDecryptionMaterials._typeDescriptor(), (TypeDescriptor<DafnySequence<Error>>)DafnySequence._typeDescriptor(Error._typeDescriptor()), Error._typeDescriptor(), _1360_errors_boxed0 -> {
            DafnySequence _1360_errors = _1360_errors_boxed0;
            return Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_1360_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured KMS Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`."));
        });
        if (_1359_valueOrError3.IsFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
            res = _1359_valueOrError3.PropagateFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptionMaterials _1358_SealedDecryptionMaterials = _1359_valueOrError3.Extract(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        res = Result.create_Success(OnDecryptOutput.create(_1358_SealedDecryptionMaterials));
        return res;
    }

    public IKMSClient client() {
        return this._client;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public KmsEcdhStaticConfigurations keyAgreementScheme() {
        return this._keyAgreementScheme;
    }

    public ECDHCurveSpec curveSpec() {
        return this._curveSpec;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public DafnySequence<? extends Byte> recipientPublicKey() {
        return this._recipientPublicKey;
    }

    public Option<DafnySequence<? extends Byte>> senderPublicKey() {
        return this._senderPublicKey;
    }

    public Option<DafnySequence<? extends Byte>> compressedSenderPublicKey() {
        return this._compressedSenderPublicKey;
    }

    public DafnySequence<? extends Byte> compressedRecipientPublicKey() {
        return this._compressedRecipientPublicKey;
    }

    public Option<DafnySequence<? extends Character>> senderKmsKeyId() {
        return this._senderKmsKeyId;
    }

    public static TypeDescriptor<AwsKmsEcdhKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsEcdhKeyring.AwsKmsEcdhKeyring";
    }
}

