/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.services.kms.internaldafny.types;

import BoundedInts_Compile.uint8;
import Wrappers_Compile.Option;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.services.kms.internaldafny.types.EncryptionAlgorithmSpec;
import software.amazon.cryptography.services.kms.internaldafny.types.RecipientInfo;

public class DecryptRequest {
    public DafnySequence<? extends Byte> _CiphertextBlob;
    public Option<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Character>>> _EncryptionContext;
    public Option<DafnySequence<? extends DafnySequence<? extends Character>>> _GrantTokens;
    public Option<DafnySequence<? extends Character>> _KeyId;
    public Option<EncryptionAlgorithmSpec> _EncryptionAlgorithm;
    public Option<RecipientInfo> _Recipient;
    public Option<Boolean> _DryRun;
    private static final DecryptRequest theDefault = DecryptRequest.create((DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()), Option.Default(), Option.Default(), Option.Default(), Option.Default(), Option.Default(), Option.Default());
    private static final TypeDescriptor<DecryptRequest> _TYPE = TypeDescriptor.referenceWithInitializer(DecryptRequest.class, () -> DecryptRequest.Default());

    public DecryptRequest(DafnySequence<? extends Byte> CiphertextBlob, Option<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Character>>> EncryptionContext, Option<DafnySequence<? extends DafnySequence<? extends Character>>> GrantTokens, Option<DafnySequence<? extends Character>> KeyId, Option<EncryptionAlgorithmSpec> EncryptionAlgorithm, Option<RecipientInfo> Recipient, Option<Boolean> DryRun) {
        this._CiphertextBlob = CiphertextBlob;
        this._EncryptionContext = EncryptionContext;
        this._GrantTokens = GrantTokens;
        this._KeyId = KeyId;
        this._EncryptionAlgorithm = EncryptionAlgorithm;
        this._Recipient = Recipient;
        this._DryRun = DryRun;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        DecryptRequest o = (DecryptRequest)other;
        return Objects.equals(this._CiphertextBlob, o._CiphertextBlob) && Objects.equals(this._EncryptionContext, o._EncryptionContext) && Objects.equals(this._GrantTokens, o._GrantTokens) && Objects.equals(this._KeyId, o._KeyId) && Objects.equals(this._EncryptionAlgorithm, o._EncryptionAlgorithm) && Objects.equals(this._Recipient, o._Recipient) && Objects.equals(this._DryRun, o._DryRun);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._CiphertextBlob);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._EncryptionContext);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._GrantTokens);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._KeyId);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._EncryptionAlgorithm);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._Recipient);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._DryRun);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("ComAmazonawsKmsTypes.DecryptRequest.DecryptRequest");
        s.append("(");
        s.append(Helpers.toString(this._CiphertextBlob));
        s.append(", ");
        s.append(Helpers.toString(this._EncryptionContext));
        s.append(", ");
        s.append(Helpers.toString(this._GrantTokens));
        s.append(", ");
        s.append(Helpers.toString(this._KeyId));
        s.append(", ");
        s.append(Helpers.toString(this._EncryptionAlgorithm));
        s.append(", ");
        s.append(Helpers.toString(this._Recipient));
        s.append(", ");
        s.append(Helpers.toString(this._DryRun));
        s.append(")");
        return s.toString();
    }

    public static DecryptRequest Default() {
        return theDefault;
    }

    public static TypeDescriptor<DecryptRequest> _typeDescriptor() {
        return _TYPE;
    }

    public static DecryptRequest create(DafnySequence<? extends Byte> CiphertextBlob, Option<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Character>>> EncryptionContext, Option<DafnySequence<? extends DafnySequence<? extends Character>>> GrantTokens, Option<DafnySequence<? extends Character>> KeyId, Option<EncryptionAlgorithmSpec> EncryptionAlgorithm, Option<RecipientInfo> Recipient, Option<Boolean> DryRun) {
        return new DecryptRequest(CiphertextBlob, EncryptionContext, GrantTokens, KeyId, EncryptionAlgorithm, Recipient, DryRun);
    }

    public static DecryptRequest create_DecryptRequest(DafnySequence<? extends Byte> CiphertextBlob, Option<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Character>>> EncryptionContext, Option<DafnySequence<? extends DafnySequence<? extends Character>>> GrantTokens, Option<DafnySequence<? extends Character>> KeyId, Option<EncryptionAlgorithmSpec> EncryptionAlgorithm, Option<RecipientInfo> Recipient, Option<Boolean> DryRun) {
        return DecryptRequest.create(CiphertextBlob, EncryptionContext, GrantTokens, KeyId, EncryptionAlgorithm, Recipient, DryRun);
    }

    public boolean is_DecryptRequest() {
        return true;
    }

    public DafnySequence<? extends Byte> dtor_CiphertextBlob() {
        return this._CiphertextBlob;
    }

    public Option<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Character>>> dtor_EncryptionContext() {
        return this._EncryptionContext;
    }

    public Option<DafnySequence<? extends DafnySequence<? extends Character>>> dtor_GrantTokens() {
        return this._GrantTokens;
    }

    public Option<DafnySequence<? extends Character>> dtor_KeyId() {
        return this._KeyId;
    }

    public Option<EncryptionAlgorithmSpec> dtor_EncryptionAlgorithm() {
        return this._EncryptionAlgorithm;
    }

    public Option<RecipientInfo> dtor_Recipient() {
        return this._Recipient;
    }

    public Option<Boolean> dtor_DryRun() {
        return this._DryRun;
    }
}

