/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.KmsEcdhConfigurations;
import software.amazon.cryptography.materialproviders.model.RawEcdhConfigurations;

public class StaticUnifiedModelConfigurations {
    private final KmsEcdhConfigurations AWS_KMS_ECDH;
    private final RawEcdhConfigurations RAW_ECDH;

    protected StaticUnifiedModelConfigurations(BuilderImpl builder) {
        this.AWS_KMS_ECDH = builder.AWS_KMS_ECDH();
        this.RAW_ECDH = builder.RAW_ECDH();
    }

    public KmsEcdhConfigurations AWS_KMS_ECDH() {
        return this.AWS_KMS_ECDH;
    }

    public RawEcdhConfigurations RAW_ECDH() {
        return this.RAW_ECDH;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected KmsEcdhConfigurations AWS_KMS_ECDH;
        protected RawEcdhConfigurations RAW_ECDH;

        protected BuilderImpl() {
        }

        protected BuilderImpl(StaticUnifiedModelConfigurations model) {
            this.AWS_KMS_ECDH = model.AWS_KMS_ECDH();
            this.RAW_ECDH = model.RAW_ECDH();
        }

        @Override
        public Builder AWS_KMS_ECDH(KmsEcdhConfigurations AWS_KMS_ECDH) {
            this.AWS_KMS_ECDH = AWS_KMS_ECDH;
            return this;
        }

        @Override
        public KmsEcdhConfigurations AWS_KMS_ECDH() {
            return this.AWS_KMS_ECDH;
        }

        @Override
        public Builder RAW_ECDH(RawEcdhConfigurations RAW_ECDH) {
            this.RAW_ECDH = RAW_ECDH;
            return this;
        }

        @Override
        public RawEcdhConfigurations RAW_ECDH() {
            return this.RAW_ECDH;
        }

        @Override
        public StaticUnifiedModelConfigurations build() {
            if (!this.onlyOneNonNull()) {
                throw new IllegalArgumentException("`StaticUnifiedModelConfigurations` is a Union. A Union MUST have one and only one value set.");
            }
            return new StaticUnifiedModelConfigurations(this);
        }

        private boolean onlyOneNonNull() {
            Object[] allValues = new Object[]{this.AWS_KMS_ECDH, this.RAW_ECDH};
            boolean haveOneNonNull = false;
            for (Object o : allValues) {
                if (!Objects.nonNull(o)) continue;
                if (haveOneNonNull) {
                    return false;
                }
                haveOneNonNull = true;
            }
            return haveOneNonNull;
        }
    }

    public static interface Builder {
        public Builder AWS_KMS_ECDH(KmsEcdhConfigurations var1);

        public KmsEcdhConfigurations AWS_KMS_ECDH();

        public Builder RAW_ECDH(RawEcdhConfigurations var1);

        public RawEcdhConfigurations RAW_ECDH();

        public StaticUnifiedModelConfigurations build();
    }
}

