/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.nio.ByteBuffer;
import java.util.Objects;

public class KmsRecipientConfiguration {
    private final String RecipientKmsKeyId;
    private final ByteBuffer RecipientPublicKey;

    protected KmsRecipientConfiguration(BuilderImpl builder) {
        this.RecipientKmsKeyId = builder.RecipientKmsKeyId();
        this.RecipientPublicKey = builder.RecipientPublicKey();
    }

    public String RecipientKmsKeyId() {
        return this.RecipientKmsKeyId;
    }

    public ByteBuffer RecipientPublicKey() {
        return this.RecipientPublicKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String RecipientKmsKeyId;
        protected ByteBuffer RecipientPublicKey;

        protected BuilderImpl() {
        }

        protected BuilderImpl(KmsRecipientConfiguration model) {
            this.RecipientKmsKeyId = model.RecipientKmsKeyId();
            this.RecipientPublicKey = model.RecipientPublicKey();
        }

        @Override
        public Builder RecipientKmsKeyId(String RecipientKmsKeyId) {
            this.RecipientKmsKeyId = RecipientKmsKeyId;
            return this;
        }

        @Override
        public String RecipientKmsKeyId() {
            return this.RecipientKmsKeyId;
        }

        @Override
        public Builder RecipientPublicKey(ByteBuffer RecipientPublicKey) {
            this.RecipientPublicKey = RecipientPublicKey;
            return this;
        }

        @Override
        public ByteBuffer RecipientPublicKey() {
            return this.RecipientPublicKey;
        }

        @Override
        public KmsRecipientConfiguration build() {
            if (!this.onlyOneNonNull()) {
                throw new IllegalArgumentException("`KmsRecipientConfiguration` is a Union. A Union MUST have one and only one value set.");
            }
            return new KmsRecipientConfiguration(this);
        }

        private boolean onlyOneNonNull() {
            Object[] allValues = new Object[]{this.RecipientKmsKeyId, this.RecipientPublicKey};
            boolean haveOneNonNull = false;
            for (Object o : allValues) {
                if (!Objects.nonNull(o)) continue;
                if (haveOneNonNull) {
                    return false;
                }
                haveOneNonNull = true;
            }
            return haveOneNonNull;
        }
    }

    public static interface Builder {
        public Builder RecipientKmsKeyId(String var1);

        public String RecipientKmsKeyId();

        public Builder RecipientPublicKey(ByteBuffer var1);

        public ByteBuffer RecipientPublicKey();

        public KmsRecipientConfiguration build();
    }
}

