/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.KmsSenderToStaticRecipientInput;
import software.amazon.cryptography.materialproviders.model.RecipientDiscoverySchemeInput;

public class KmsEcdhConfigurations {
    private final RecipientDiscoverySchemeInput RecipientDiscoveryScheme;
    private final KmsSenderToStaticRecipientInput KmsSenderToStaticRecipient;

    protected KmsEcdhConfigurations(BuilderImpl builder) {
        this.RecipientDiscoveryScheme = builder.RecipientDiscoveryScheme();
        this.KmsSenderToStaticRecipient = builder.KmsSenderToStaticRecipient();
    }

    public RecipientDiscoverySchemeInput RecipientDiscoveryScheme() {
        return this.RecipientDiscoveryScheme;
    }

    public KmsSenderToStaticRecipientInput KmsSenderToStaticRecipient() {
        return this.KmsSenderToStaticRecipient;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected RecipientDiscoverySchemeInput RecipientDiscoveryScheme;
        protected KmsSenderToStaticRecipientInput KmsSenderToStaticRecipient;

        protected BuilderImpl() {
        }

        protected BuilderImpl(KmsEcdhConfigurations model) {
            this.RecipientDiscoveryScheme = model.RecipientDiscoveryScheme();
            this.KmsSenderToStaticRecipient = model.KmsSenderToStaticRecipient();
        }

        @Override
        public Builder RecipientDiscoveryScheme(RecipientDiscoverySchemeInput RecipientDiscoveryScheme) {
            this.RecipientDiscoveryScheme = RecipientDiscoveryScheme;
            return this;
        }

        @Override
        public RecipientDiscoverySchemeInput RecipientDiscoveryScheme() {
            return this.RecipientDiscoveryScheme;
        }

        @Override
        public Builder KmsSenderToStaticRecipient(KmsSenderToStaticRecipientInput KmsSenderToStaticRecipient) {
            this.KmsSenderToStaticRecipient = KmsSenderToStaticRecipient;
            return this;
        }

        @Override
        public KmsSenderToStaticRecipientInput KmsSenderToStaticRecipient() {
            return this.KmsSenderToStaticRecipient;
        }

        @Override
        public KmsEcdhConfigurations build() {
            if (!this.onlyOneNonNull()) {
                throw new IllegalArgumentException("`KmsEcdhConfigurations` is a Union. A Union MUST have one and only one value set.");
            }
            return new KmsEcdhConfigurations(this);
        }

        private boolean onlyOneNonNull() {
            Object[] allValues = new Object[]{this.RecipientDiscoveryScheme, this.KmsSenderToStaticRecipient};
            boolean haveOneNonNull = false;
            for (Object o : allValues) {
                if (!Objects.nonNull(o)) continue;
                if (haveOneNonNull) {
                    return false;
                }
                haveOneNonNull = true;
            }
            return haveOneNonNull;
        }
    }

    public static interface Builder {
        public Builder RecipientDiscoveryScheme(RecipientDiscoverySchemeInput var1);

        public RecipientDiscoverySchemeInput RecipientDiscoveryScheme();

        public Builder KmsSenderToStaticRecipient(KmsSenderToStaticRecipientInput var1);

        public KmsSenderToStaticRecipientInput KmsSenderToStaticRecipient();

        public KmsEcdhConfigurations build();
    }
}

