/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.nio.ByteBuffer;
import java.util.Objects;

public class EphemeralSenderToStaticRecipientInput {
    private final ByteBuffer recipientPublicKey;

    protected EphemeralSenderToStaticRecipientInput(BuilderImpl builder) {
        this.recipientPublicKey = builder.recipientPublicKey();
    }

    public ByteBuffer recipientPublicKey() {
        return this.recipientPublicKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ByteBuffer recipientPublicKey;

        protected BuilderImpl() {
        }

        protected BuilderImpl(EphemeralSenderToStaticRecipientInput model) {
            this.recipientPublicKey = model.recipientPublicKey();
        }

        @Override
        public Builder recipientPublicKey(ByteBuffer recipientPublicKey) {
            this.recipientPublicKey = recipientPublicKey;
            return this;
        }

        @Override
        public ByteBuffer recipientPublicKey() {
            return this.recipientPublicKey;
        }

        @Override
        public EphemeralSenderToStaticRecipientInput build() {
            if (Objects.isNull(this.recipientPublicKey())) {
                throw new IllegalArgumentException("Missing value for required field `recipientPublicKey`");
            }
            return new EphemeralSenderToStaticRecipientInput(this);
        }
    }

    public static interface Builder {
        public Builder recipientPublicKey(ByteBuffer var1);

        public ByteBuffer recipientPublicKey();

        public EphemeralSenderToStaticRecipientInput build();
    }
}

