/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.internaldafny.types;

import dafny.TypeDescriptor;
import software.amazon.cryptography.materialproviders.internaldafny.types.ECDSA;
import software.amazon.cryptography.materialproviders.internaldafny.types.None;
import software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm_ECDSA;
import software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm_None;

public abstract class SignatureAlgorithm {
    private static final SignatureAlgorithm theDefault = SignatureAlgorithm.create_ECDSA(ECDSA.Default());
    private static final TypeDescriptor<SignatureAlgorithm> _TYPE = TypeDescriptor.referenceWithInitializer(SignatureAlgorithm.class, () -> SignatureAlgorithm.Default());

    public static SignatureAlgorithm Default() {
        return theDefault;
    }

    public static TypeDescriptor<SignatureAlgorithm> _typeDescriptor() {
        return _TYPE;
    }

    public static SignatureAlgorithm create_ECDSA(ECDSA ECDSA2) {
        return new SignatureAlgorithm_ECDSA(ECDSA2);
    }

    public static SignatureAlgorithm create_None(None None2) {
        return new SignatureAlgorithm_None(None2);
    }

    public boolean is_ECDSA() {
        return this instanceof SignatureAlgorithm_ECDSA;
    }

    public boolean is_None() {
        return this instanceof SignatureAlgorithm_None;
    }

    public ECDSA dtor_ECDSA() {
        SignatureAlgorithm d = this;
        return ((SignatureAlgorithm_ECDSA)d)._ECDSA;
    }

    public None dtor_None() {
        SignatureAlgorithm d = this;
        return ((SignatureAlgorithm_None)d)._None;
    }
}

