/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders;

import Wrappers_Compile.Result;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.ICryptographicMaterialsManager;
import software.amazon.cryptography.materialproviders.ToDafny;
import software.amazon.cryptography.materialproviders.ToNative;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput;
import software.amazon.cryptography.materialproviders.model.DecryptMaterialsInput;
import software.amazon.cryptography.materialproviders.model.GetEncryptionMaterialsInput;

public final class CryptographicMaterialsManager
implements ICryptographicMaterialsManager {
    private final software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager _impl;

    private CryptographicMaterialsManager(software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager iCryptographicMaterialsManager) {
        Objects.requireNonNull(iCryptographicMaterialsManager, "Missing value for required argument `iCryptographicMaterialsManager`");
        this._impl = iCryptographicMaterialsManager;
    }

    public static CryptographicMaterialsManager wrap(software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager iCryptographicMaterialsManager) {
        return new CryptographicMaterialsManager(iCryptographicMaterialsManager);
    }

    public static <I extends ICryptographicMaterialsManager> CryptographicMaterialsManager wrap(I iCryptographicMaterialsManager) {
        Objects.requireNonNull(iCryptographicMaterialsManager, "Missing value for required argument `iCryptographicMaterialsManager`");
        if (iCryptographicMaterialsManager instanceof CryptographicMaterialsManager) {
            return (CryptographicMaterialsManager)iCryptographicMaterialsManager;
        }
        return CryptographicMaterialsManager.wrap(new NativeWrapper(iCryptographicMaterialsManager));
    }

    public software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager impl() {
        return this._impl;
    }

    @Override
    public software.amazon.cryptography.materialproviders.model.DecryptMaterialsOutput DecryptMaterials(DecryptMaterialsInput input) {
        software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsInput dafnyValue = ToDafny.DecryptMaterialsInput(input);
        Result<DecryptMaterialsOutput, Error> result = this._impl.DecryptMaterials(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.DecryptMaterialsOutput(result.dtor_value());
    }

    @Override
    public software.amazon.cryptography.materialproviders.model.GetEncryptionMaterialsOutput GetEncryptionMaterials(GetEncryptionMaterialsInput input) {
        software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput dafnyValue = ToDafny.GetEncryptionMaterialsInput(input);
        Result<GetEncryptionMaterialsOutput, Error> result = this._impl.GetEncryptionMaterials(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.GetEncryptionMaterialsOutput(result.dtor_value());
    }

    protected static final class NativeWrapper
    implements software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager {
        protected final ICryptographicMaterialsManager _impl;

        NativeWrapper(ICryptographicMaterialsManager nativeImpl) {
            if (nativeImpl instanceof CryptographicMaterialsManager) {
                throw new IllegalArgumentException("Recursive wrapping is strictly forbidden.");
            }
            this._impl = nativeImpl;
        }

        @Override
        public Result<DecryptMaterialsOutput, Error> DecryptMaterials(software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsInput dafnyInput) {
            try {
                DecryptMaterialsInput nativeInput = ToNative.DecryptMaterialsInput(dafnyInput);
                software.amazon.cryptography.materialproviders.model.DecryptMaterialsOutput nativeOutput = this._impl.DecryptMaterials(nativeInput);
                DecryptMaterialsOutput dafnyOutput = ToDafny.DecryptMaterialsOutput(nativeOutput);
                return Result.create_Success(dafnyOutput);
            }
            catch (RuntimeException ex) {
                return Result.create_Failure(ToDafny.Error(ex));
            }
        }

        @Override
        public Result<DecryptMaterialsOutput, Error> DecryptMaterials_k(software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsInput dafnyInput) {
            throw new RuntimeException("Not supported at this time.");
        }

        @Override
        public Result<GetEncryptionMaterialsOutput, Error> GetEncryptionMaterials(software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput dafnyInput) {
            try {
                GetEncryptionMaterialsInput nativeInput = ToNative.GetEncryptionMaterialsInput(dafnyInput);
                software.amazon.cryptography.materialproviders.model.GetEncryptionMaterialsOutput nativeOutput = this._impl.GetEncryptionMaterials(nativeInput);
                GetEncryptionMaterialsOutput dafnyOutput = ToDafny.GetEncryptionMaterialsOutput(nativeOutput);
                return Result.create_Success(dafnyOutput);
            }
            catch (RuntimeException ex) {
                return Result.create_Failure(ToDafny.Error(ex));
            }
        }

        @Override
        public Result<GetEncryptionMaterialsOutput, Error> GetEncryptionMaterials_k(software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput dafnyInput) {
            throw new RuntimeException("Not supported at this time.");
        }
    }
}

