/*
 * Decompiled with CFR 0.152.
 */
package RawECDHKeyring_Compile;

import Actions_Compile.Action;
import Actions_Compile.ActionWithResult;
import BoundedInts_Compile.uint8;
import EcdhEdkWrapping_Compile.EcdhUnwrap;
import EcdhEdkWrapping_Compile.EcdhUnwrapInfo;
import EdkWrapping_Compile.UnwrapEdkMaterialOutput;
import Materials_Compile.SealedDecryptionMaterials;
import RawECDHKeyring_Compile.__default;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.RawEcdhStaticConfigurations;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPrivateKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPublicKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec;

public class DecryptSingleEncryptedDataKey
implements ActionWithResult<EncryptedDataKey, DecryptionMaterials, Error>,
Action<EncryptedDataKey, Result<DecryptionMaterials, Error>> {
    public DecryptionMaterials _materials = null;
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public DafnySequence<? extends Byte> _recipientPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    public DafnySequence<? extends Byte> _senderPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    public RawEcdhStaticConfigurations _keyAgreementScheme = RawEcdhStaticConfigurations.Default();
    public ECDHCurveSpec _curveSpec = ECDHCurveSpec.Default();
    private static final TypeDescriptor<DecryptSingleEncryptedDataKey> _TYPE = TypeDescriptor.referenceWithInitializer(DecryptSingleEncryptedDataKey.class, () -> null);

    public void __ctor(DecryptionMaterials materials, AtomicPrimitivesClient cryptoPrimitives, DafnySequence<? extends Byte> senderPublicKey, DafnySequence<? extends Byte> recipientPublicKey, RawEcdhStaticConfigurations keyAgreementScheme, ECDHCurveSpec curveSpec) {
        this._materials = materials;
        this._cryptoPrimitives = cryptoPrimitives;
        this._recipientPublicKey = recipientPublicKey;
        this._senderPublicKey = senderPublicKey;
        this._keyAgreementScheme = keyAgreementScheme;
        this._curveSpec = curveSpec;
    }

    @Override
    public Result<DecryptionMaterials, Error> Invoke(EncryptedDataKey edk) {
        Result<UnwrapEdkMaterialOutput<EcdhUnwrapInfo>, Error> _out224;
        Result<DecryptionMaterials, Error> res = null;
        Outcome<Object> _1279_valueOrError0 = Outcome.Default();
        _1279_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), UTF8.__default.ValidUTF8Seq(edk.dtor_keyProviderId()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Received invalid EDK provider id for AWS KMS ECDH Keyring")));
        if (_1279_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _1279_valueOrError0.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        AlgorithmSuiteInfo _1280_suite = this.materials().dtor_algorithmSuite();
        DafnySequence<? extends Byte> _1281_keyProviderId = edk.dtor_keyProviderId();
        DafnySequence<? extends Byte> _1282_providerInfo = edk.dtor_keyProviderInfo();
        DafnySequence<? extends Byte> _1283_ciphertext = edk.dtor_ciphertext();
        Result<Object, Object> _1285_valueOrError1 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _1285_valueOrError1 = EdkWrapping_Compile.__default.GetProviderWrappedMaterial(_1283_ciphertext, _1280_suite);
        if (_1285_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _1285_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _1284_providerWrappedMaterial = (DafnySequence)_1285_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        Outcome<Object> _1286_valueOrError2 = Outcome.Default();
        _1286_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_1282_providerInfo.length()).compareTo(BigInteger.valueOf(Integer.toUnsignedLong(Constants_Compile.__default.ECDH__PROVIDER__INFO__521__LEN()))) <= 0 && __default.ValidProviderInfoLength(_1282_providerInfo), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"EDK ProviderInfo longer than expected")));
        if (_1286_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _1286_valueOrError2.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        byte _1287_keyringVersion = (Byte)_1282_providerInfo.select(Helpers.toInt((BigInteger)BigInteger.ZERO));
        Outcome<Object> _1288_valueOrError3 = Outcome.Default();
        _1288_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), DafnySequence.of((byte[])new byte[]{_1287_keyringVersion}).equals(__default.RAW__ECDH__KEYRING__VERSION()), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Incorrect Keyring version found in provider info.")));
        if (_1288_valueOrError3.IsFailure(Error._typeDescriptor())) {
            res = _1288_valueOrError3.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        BigInteger _1289_recipientPublicKeyLength = BigInteger.ZERO;
        _1289_recipientPublicKeyLength = BigInteger.valueOf(Integer.toUnsignedLong(StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)_1282_providerInfo.subsequence(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPL__INDEX(), Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX()))));
        BigInteger _1290_recipientPublicKeyLengthIndex = BigInteger.ZERO;
        _1290_recipientPublicKeyLengthIndex = BigInteger.valueOf(Integer.toUnsignedLong(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX())).add(_1289_recipientPublicKeyLength);
        BigInteger _1291_senderPublicKeyIndex = BigInteger.ZERO;
        _1291_senderPublicKeyIndex = _1290_recipientPublicKeyLengthIndex.add(Constants_Compile.__default.ECDH__PROVIDER__INFO__PUBLIC__KEY__LEN());
        Outcome<Object> _1292_valueOrError4 = Outcome.Default();
        _1292_valueOrError4 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _1290_recipientPublicKeyLengthIndex.add(BigInteger.valueOf(4L)).compareTo(BigInteger.valueOf(_1282_providerInfo.length())) < 0, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Key Provider Info Serialization Error. Serialized length less than expected.")));
        if (_1292_valueOrError4.IsFailure(Error._typeDescriptor())) {
            res = _1292_valueOrError4.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _1293_providerInfoRecipientPublicKey = _1282_providerInfo.subsequence(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX(), Helpers.toInt((BigInteger)_1290_recipientPublicKeyLengthIndex));
        DafnySequence _1294_providerInfoSenderPublicKey = _1282_providerInfo.drop(_1291_senderPublicKeyIndex);
        Result<Object, Object> _1296_valueOrError5 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out218 = __default.DecompressPublicKey((DafnySequence<? extends Byte>)_1294_providerInfoSenderPublicKey, this.curveSpec(), this.cryptoPrimitives());
        _1296_valueOrError5 = _out218;
        if (_1296_valueOrError5.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _1296_valueOrError5.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _1295_senderPublicKey = (DafnySequence)_1296_valueOrError5.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        Result<Object, Object> _1298_valueOrError6 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out219 = __default.DecompressPublicKey((DafnySequence<? extends Byte>)_1293_providerInfoRecipientPublicKey, this.curveSpec(), this.cryptoPrimitives());
        _1298_valueOrError6 = _out219;
        if (_1298_valueOrError6.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _1298_valueOrError6.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _1297_recipientPublicKey = (DafnySequence)_1298_valueOrError6.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        Result<Boolean, Object> _1300_valueOrError7 = Result.Default(false);
        Result<Boolean, Error> _out220 = __default.ValidatePublicKey(this.cryptoPrimitives(), this.curveSpec(), (DafnySequence<? extends Byte>)_1295_senderPublicKey);
        _1300_valueOrError7 = _out220;
        if (_1300_valueOrError7.IsFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor())) {
            res = _1300_valueOrError7.PropagateFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        boolean _1299___v0 = _1300_valueOrError7.Extract((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor());
        Result<Boolean, Object> _1302_valueOrError8 = Result.Default(false);
        Result<Boolean, Error> _out221 = __default.ValidatePublicKey(this.cryptoPrimitives(), this.curveSpec(), (DafnySequence<? extends Byte>)_1297_recipientPublicKey);
        _1302_valueOrError8 = _out221;
        if (_1302_valueOrError8.IsFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor())) {
            res = _1302_valueOrError8.PropagateFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        boolean _1301___v1 = _1302_valueOrError8.Extract((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor());
        DafnySequence _1303_sharedSecretPublicKey = DafnySequence.empty(uint8._typeDescriptor());
        DafnySequence<? extends Byte> _1304_sharedSecretPrivateKey = DafnySequence.empty(uint8._typeDescriptor());
        if (this.keyAgreementScheme().is_PublicKeyDiscovery()) {
            _1303_sharedSecretPublicKey = _1295_senderPublicKey;
            _1304_sharedSecretPrivateKey = this.keyAgreementScheme().dtor_PublicKeyDiscovery().dtor_recipientStaticPrivateKey();
        } else if (this.keyAgreementScheme().is_RawPrivateKeyToStaticPublicKey()) {
            _1304_sharedSecretPrivateKey = this.keyAgreementScheme().dtor_RawPrivateKeyToStaticPublicKey().dtor_senderStaticPrivateKey();
            _1303_sharedSecretPublicKey = this.keyAgreementScheme().dtor_RawPrivateKeyToStaticPublicKey().dtor_recipientPublicKey().equals((Object)_1297_recipientPublicKey) ? _1297_recipientPublicKey : _1295_senderPublicKey;
        } else {
            if (this.keyAgreementScheme().is_EphemeralPrivateKeyToStaticPublicKey()) {
                res = Result.create_Failure(__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"EphemeralPrivateKeyToStaticPublicKey Not allowed on decrypt")));
                return res;
            }
            throw new IllegalArgumentException("unreachable alternative");
        }
        Result<Boolean, Object> _1306_valueOrError9 = Result.Default(false);
        Result<Boolean, Error> _out222 = __default.ValidatePublicKey(this.cryptoPrimitives(), this.curveSpec(), (DafnySequence<? extends Byte>)_1303_sharedSecretPublicKey);
        _1306_valueOrError9 = _out222;
        if (_1306_valueOrError9.IsFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor())) {
            res = _1306_valueOrError9.PropagateFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        boolean _1305___v2 = _1306_valueOrError9.Extract((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor());
        Result<Object, Object> _1308_valueOrError10 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out223 = __default.LocalDeriveSharedSecret(ECCPrivateKey.create(_1304_sharedSecretPrivateKey), ECCPublicKey.create((DafnySequence<? extends Byte>)_1303_sharedSecretPublicKey), this.curveSpec(), this.cryptoPrimitives());
        _1308_valueOrError10 = _out223;
        if (_1308_valueOrError10.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _1308_valueOrError10.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _1307_sharedSecret = (DafnySequence)_1308_valueOrError10.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        EcdhUnwrap _nw50 = new EcdhUnwrap();
        _nw50.__ctor((DafnySequence<? extends Byte>)_1294_providerInfoSenderPublicKey, (DafnySequence<? extends Byte>)_1293_providerInfoRecipientPublicKey, (DafnySequence<? extends Byte>)_1307_sharedSecret, __default.RAW__ECDH__KEYRING__VERSION(), this.curveSpec(), this.cryptoPrimitives());
        EcdhUnwrap _1309_ecdhUnwrap = _nw50;
        Result<UnwrapEdkMaterialOutput<EcdhUnwrapInfo>, Error> _1310_unwrapOutputRes = _out224 = EdkWrapping_Compile.__default.UnwrapEdkMaterial(EcdhUnwrapInfo._typeDescriptor(), edk.dtor_ciphertext(), this.materials(), _1309_ecdhUnwrap);
        Result<UnwrapEdkMaterialOutput<EcdhUnwrapInfo>, Object> _1312_valueOrError11 = Result.Default(UnwrapEdkMaterialOutput.Default(EcdhUnwrapInfo.Default()));
        _1312_valueOrError11 = _1310_unwrapOutputRes;
        if (_1312_valueOrError11.IsFailure(UnwrapEdkMaterialOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            res = _1312_valueOrError11.PropagateFailure(UnwrapEdkMaterialOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        UnwrapEdkMaterialOutput<EcdhUnwrapInfo> _1311_unwrapOutput = _1312_valueOrError11.Extract(UnwrapEdkMaterialOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()), Error._typeDescriptor());
        Result<DecryptionMaterials, Error> _1314_valueOrError12 = null;
        _1314_valueOrError12 = Materials_Compile.__default.DecryptionMaterialsAddDataKey(this.materials(), _1311_unwrapOutput.dtor_plaintextDataKey(), _1311_unwrapOutput.dtor_symmetricSigningKey());
        if (_1314_valueOrError12.IsFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
            res = _1314_valueOrError12.PropagateFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DecryptionMaterials _1313_result = _1314_valueOrError12.Extract(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        res = Result.create_Success(_1313_result);
        return res;
    }

    public DecryptionMaterials materials() {
        return this._materials;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public DafnySequence<? extends Byte> recipientPublicKey() {
        return this._recipientPublicKey;
    }

    public DafnySequence<? extends Byte> senderPublicKey() {
        return this._senderPublicKey;
    }

    public RawEcdhStaticConfigurations keyAgreementScheme() {
        return this._keyAgreementScheme;
    }

    public ECDHCurveSpec curveSpec() {
        return this._curveSpec;
    }

    public static TypeDescriptor<DecryptSingleEncryptedDataKey> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "RawECDHKeyring.DecryptSingleEncryptedDataKey";
    }
}

