/*
 * Decompiled with CFR 0.152.
 */
package KMSKeystoreOperations_Compile;

import AwsArnParsing_Compile.AwsArn;
import AwsArnParsing_Compile.AwsKmsIdentifier;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.keystore.internaldafny.types.Discovery;
import software.amazon.cryptography.keystore.internaldafny.types.Error;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration_discovery;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration_kmsKeyArn;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration_kmsMRKeyArn;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration_mrDiscovery;
import software.amazon.cryptography.keystore.internaldafny.types.MRDiscovery;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue;
import software.amazon.cryptography.services.kms.internaldafny.types.DecryptRequest;
import software.amazon.cryptography.services.kms.internaldafny.types.DecryptResponse;
import software.amazon.cryptography.services.kms.internaldafny.types.GenerateDataKeyWithoutPlaintextRequest;
import software.amazon.cryptography.services.kms.internaldafny.types.GenerateDataKeyWithoutPlaintextResponse;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;
import software.amazon.cryptography.services.kms.internaldafny.types.ReEncryptRequest;
import software.amazon.cryptography.services.kms.internaldafny.types.ReEncryptResponse;

public class __default {
    public static DafnySequence<? extends Character> replaceRegion(DafnySequence<? extends Character> arn, DafnySequence<? extends Character> region) {
        Result<AwsArn, DafnySequence<? extends Character>> _145_parsed = AwsArnParsing_Compile.__default.ParseAwsKmsArn(arn);
        if (_145_parsed.is_Failure()) {
            return arn;
        }
        if (!AwsArnParsing_Compile.__default.IsMultiRegionAwsKmsArn(_145_parsed.dtor_value())) {
            return arn;
        }
        DafnySequence<? extends Character> _146_newArn = _145_parsed.dtor_value().ToArnString(Option.create_Some(region));
        if (software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__KeyIdType(_146_newArn)) {
            return _146_newArn;
        }
        return arn;
    }

    public static DafnySequence<? extends Character> GetArn(KMSConfiguration kmsConfiguration, DafnySequence<? extends Character> discoverdArn) {
        MRDiscovery _153___mcc_h3;
        KMSConfiguration _source8 = kmsConfiguration;
        if (_source8.is_kmsKeyArn()) {
            DafnySequence<? extends Character> _147___mcc_h0;
            DafnySequence<? extends Character> _148_arn = _147___mcc_h0 = ((KMSConfiguration_kmsKeyArn)_source8)._kmsKeyArn;
            return _148_arn;
        }
        if (_source8.is_kmsMRKeyArn()) {
            DafnySequence<? extends Character> _149___mcc_h1;
            DafnySequence<? extends Character> _150_arn = _149___mcc_h1 = ((KMSConfiguration_kmsMRKeyArn)_source8)._kmsMRKeyArn;
            return _150_arn;
        }
        if (_source8.is_discovery()) {
            Discovery _151___mcc_h2;
            Discovery _152_obj = _151___mcc_h2 = ((KMSConfiguration_discovery)_source8)._discovery;
            return discoverdArn;
        }
        MRDiscovery _154_region = _153___mcc_h3 = ((KMSConfiguration_mrDiscovery)_source8)._mrDiscovery;
        return __default.replaceRegion(discoverdArn, _154_region.dtor_region());
    }

    public static boolean AttemptKmsOperation_q(KMSConfiguration kmsConfiguration, DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Character>> encryptionContext) {
        MRDiscovery _161___mcc_h3;
        KMSConfiguration _source9 = kmsConfiguration;
        if (_source9.is_kmsKeyArn()) {
            DafnySequence<? extends Character> _155___mcc_h0 = ((KMSConfiguration_kmsKeyArn)_source9)._kmsKeyArn;
            DafnySequence<? extends Character> _156_arn = _155___mcc_h0;
            return _156_arn.equals((Object)((DafnySequence)encryptionContext.get(Structure_Compile.__default.KMS__FIELD()))) && KmsArn_Compile.__default.ValidKmsArn_q(_156_arn);
        }
        if (_source9.is_kmsMRKeyArn()) {
            DafnySequence<? extends Character> _157___mcc_h1 = ((KMSConfiguration_kmsMRKeyArn)_source9)._kmsMRKeyArn;
            DafnySequence<? extends Character> _158_arn = _157___mcc_h1;
            return __default.MrkMatch(_158_arn, (DafnySequence<? extends Character>)((DafnySequence)encryptionContext.get(Structure_Compile.__default.KMS__FIELD()))) && KmsArn_Compile.__default.ValidKmsArn_q(_158_arn);
        }
        if (_source9.is_discovery()) {
            Discovery _159___mcc_h2;
            Discovery _160_obj = _159___mcc_h2 = ((KMSConfiguration_discovery)_source9)._discovery;
            return KmsArn_Compile.__default.ValidKmsArn_q((DafnySequence<? extends Character>)((DafnySequence)encryptionContext.get(Structure_Compile.__default.KMS__FIELD())));
        }
        MRDiscovery _162_obj = _161___mcc_h3 = ((KMSConfiguration_mrDiscovery)_source9)._mrDiscovery;
        return KmsArn_Compile.__default.ValidKmsArn_q((DafnySequence<? extends Character>)((DafnySequence)encryptionContext.get(Structure_Compile.__default.KMS__FIELD())));
    }

    public static boolean Compatible_q(KMSConfiguration kmsConfiguration, DafnySequence<? extends Character> keyId) {
        DafnySequence<? extends Character> _165___mcc_h1;
        KMSConfiguration _source10 = kmsConfiguration;
        if (_source10.is_kmsKeyArn()) {
            DafnySequence<? extends Character> _163___mcc_h0;
            DafnySequence<? extends Character> _164_arn = _163___mcc_h0 = ((KMSConfiguration_kmsKeyArn)_source10)._kmsKeyArn;
            return _164_arn.equals(keyId);
        }
        DafnySequence<? extends Character> _166_arn = _165___mcc_h1 = ((KMSConfiguration_kmsMRKeyArn)_source10)._kmsMRKeyArn;
        return __default.MrkMatch(_166_arn, keyId);
    }

    public static boolean OptCompatible_q(KMSConfiguration kmsConfiguration, Option<DafnySequence<? extends Character>> keyId) {
        return keyId.is_Some() && __default.Compatible_q(kmsConfiguration, keyId.dtor_value());
    }

    public static boolean MrkMatch(DafnySequence<? extends Character> x, DafnySequence<? extends Character> y) {
        Result<AwsArn, DafnySequence<? extends Character>> _167_xArn = AwsArnParsing_Compile.__default.ParseAwsKmsArn(x);
        Result<AwsArn, DafnySequence<? extends Character>> _168_yArn = AwsArnParsing_Compile.__default.ParseAwsKmsArn(y);
        if (_167_xArn.is_Failure() || _168_yArn.is_Failure()) {
            return false;
        }
        return AwsKmsMrkMatchForDecrypt_Compile.__default.AwsKmsMrkMatchForDecrypt(AwsKmsIdentifier.create_AwsKmsArnIdentifier(_167_xArn.dtor_value()), AwsKmsIdentifier.create_AwsKmsArnIdentifier(_168_yArn.dtor_value()));
    }

    public static boolean HasKeyId(KMSConfiguration kmsConfiguration) {
        return kmsConfiguration.is_kmsKeyArn() || kmsConfiguration.is_kmsMRKeyArn();
    }

    public static DafnySequence<? extends Character> GetKeyId(KMSConfiguration kmsConfiguration) {
        DafnySequence<? extends Character> _171___mcc_h1;
        KMSConfiguration _source11 = kmsConfiguration;
        if (_source11.is_kmsKeyArn()) {
            DafnySequence<? extends Character> _169___mcc_h0;
            DafnySequence<? extends Character> _170_arn = _169___mcc_h0 = ((KMSConfiguration_kmsKeyArn)_source11)._kmsKeyArn;
            return _170_arn;
        }
        DafnySequence<? extends Character> _172_arn = _171___mcc_h1 = ((KMSConfiguration_kmsMRKeyArn)_source11)._kmsMRKeyArn;
        return _172_arn;
    }

    public static Result<GenerateDataKeyWithoutPlaintextResponse, Error> GenerateKey(DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Character>> encryptionContext, KMSConfiguration kmsConfiguration, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens, IKMSClient kmsClient) {
        Result<GenerateDataKeyWithoutPlaintextResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out11;
        Result<GenerateDataKeyWithoutPlaintextResponse, Error> res = Result.Default(GenerateDataKeyWithoutPlaintextResponse.Default());
        DafnySequence<? extends Character> _173_kmsKeyArn = __default.GetKeyId(kmsConfiguration);
        GenerateDataKeyWithoutPlaintextRequest _174_generatorRequest = GenerateDataKeyWithoutPlaintextRequest.create(_173_kmsKeyArn, Option.create_Some(encryptionContext), Option.create_None(), Option.create_Some(32), Option.create_Some(grantTokens), Option.create_None());
        Result<GenerateDataKeyWithoutPlaintextResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _175_maybeGenerateResponse = _out11 = kmsClient.GenerateDataKeyWithoutPlaintext(_174_generatorRequest);
        Result<GenerateDataKeyWithoutPlaintextResponse, Object> _177_valueOrError0 = Result.Default(GenerateDataKeyWithoutPlaintextResponse.Default());
        _177_valueOrError0 = _175_maybeGenerateResponse.MapFailure(GenerateDataKeyWithoutPlaintextResponse._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _178_e_boxed0 -> {
            software.amazon.cryptography.services.kms.internaldafny.types.Error _178_e = _178_e_boxed0;
            return Error.create_ComAmazonawsKms(_178_e);
        });
        if (_177_valueOrError0.IsFailure(GenerateDataKeyWithoutPlaintextResponse._typeDescriptor(), Error._typeDescriptor())) {
            res = _177_valueOrError0.PropagateFailure(GenerateDataKeyWithoutPlaintextResponse._typeDescriptor(), Error._typeDescriptor(), GenerateDataKeyWithoutPlaintextResponse._typeDescriptor());
            return res;
        }
        GenerateDataKeyWithoutPlaintextResponse _176_generateResponse = _177_valueOrError0.Extract(GenerateDataKeyWithoutPlaintextResponse._typeDescriptor(), Error._typeDescriptor());
        Outcome<Object> _179_valueOrError1 = Outcome.Default();
        _179_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _176_generateResponse.dtor_KeyId().is_Some(), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from KMS GenerateDataKey:: Invalid Key Id")));
        if (_179_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _179_valueOrError1.PropagateFailure(Error._typeDescriptor(), GenerateDataKeyWithoutPlaintextResponse._typeDescriptor());
            return res;
        }
        Outcome<Object> _180_valueOrError2 = Outcome.Default();
        _180_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _176_generateResponse.dtor_CiphertextBlob().is_Some() && software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__CiphertextType(_176_generateResponse.dtor_CiphertextBlob().dtor_value()), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS GenerateDataKey: Invalid ciphertext")));
        if (_180_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _180_valueOrError2.PropagateFailure(Error._typeDescriptor(), GenerateDataKeyWithoutPlaintextResponse._typeDescriptor());
            return res;
        }
        res = Result.create_Success(_176_generateResponse);
        return res;
    }

    public static Result<ReEncryptResponse, Error> ReEncryptKey(DafnySequence<? extends Byte> ciphertext, DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Character>> sourceEncryptionContext, DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Character>> destinationEncryptionContext, KMSConfiguration kmsConfiguration, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens, IKMSClient kmsClient) {
        Result<ReEncryptResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out12;
        Result<ReEncryptResponse, Error> res = Result.Default(ReEncryptResponse.Default());
        DafnySequence<? extends Character> _181_kmsKeyArn = __default.GetKeyId(kmsConfiguration);
        ReEncryptRequest _182_reEncryptRequest = ReEncryptRequest.create(ciphertext, Option.create_Some(sourceEncryptionContext), Option.create_Some(_181_kmsKeyArn), _181_kmsKeyArn, Option.create_Some(destinationEncryptionContext), Option.create_None(), Option.create_None(), Option.create_Some(grantTokens), Option.create_None());
        Result<ReEncryptResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _183_maybeReEncryptResponse = _out12 = kmsClient.ReEncrypt(_182_reEncryptRequest);
        Result<ReEncryptResponse, Object> _185_valueOrError0 = Result.Default(ReEncryptResponse.Default());
        _185_valueOrError0 = _183_maybeReEncryptResponse.MapFailure(ReEncryptResponse._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _186_e_boxed0 -> {
            software.amazon.cryptography.services.kms.internaldafny.types.Error _186_e = _186_e_boxed0;
            return Error.create_ComAmazonawsKms(_186_e);
        });
        if (_185_valueOrError0.IsFailure(ReEncryptResponse._typeDescriptor(), Error._typeDescriptor())) {
            res = _185_valueOrError0.PropagateFailure(ReEncryptResponse._typeDescriptor(), Error._typeDescriptor(), ReEncryptResponse._typeDescriptor());
            return res;
        }
        ReEncryptResponse _184_reEncryptResponse = _185_valueOrError0.Extract(ReEncryptResponse._typeDescriptor(), Error._typeDescriptor());
        Outcome<Object> _187_valueOrError1 = Outcome.Default();
        _187_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _184_reEncryptResponse.dtor_SourceKeyId().is_Some() && _184_reEncryptResponse.dtor_KeyId().is_Some() && _184_reEncryptResponse.dtor_SourceKeyId().dtor_value().equals(_181_kmsKeyArn) && _184_reEncryptResponse.dtor_KeyId().dtor_value().equals(_181_kmsKeyArn), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from KMS ReEncrypt:: Invalid Key Id")));
        if (_187_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _187_valueOrError1.PropagateFailure(Error._typeDescriptor(), ReEncryptResponse._typeDescriptor());
            return res;
        }
        Outcome<Object> _188_valueOrError2 = Outcome.Default();
        _188_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _184_reEncryptResponse.dtor_CiphertextBlob().is_Some() && software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__CiphertextType(_184_reEncryptResponse.dtor_CiphertextBlob().dtor_value()), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS ReEncrypt: Invalid ciphertext.")));
        if (_188_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _188_valueOrError2.PropagateFailure(Error._typeDescriptor(), ReEncryptResponse._typeDescriptor());
            return res;
        }
        res = Result.create_Success(_184_reEncryptResponse);
        return res;
    }

    public static Result<DecryptResponse, Error> DecryptKey(DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Character>> encryptionContext, DafnyMap<? extends DafnySequence<? extends Character>, ? extends AttributeValue> item, KMSConfiguration kmsConfiguration, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens, IKMSClient kmsClient) {
        Result<DecryptResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out13;
        Result<DecryptResponse, Error> output = Result.Default(DecryptResponse.Default());
        DafnySequence<? extends Character> _189_kmsKeyArn = __default.GetArn(kmsConfiguration, (DafnySequence<? extends Character>)((DafnySequence)encryptionContext.get(Structure_Compile.__default.KMS__FIELD())));
        Result<DecryptResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _190_maybeDecryptResponse = _out13 = kmsClient.Decrypt(DecryptRequest.create(((AttributeValue)item.get(Structure_Compile.__default.BRANCH__KEY__FIELD())).dtor_B(), Option.create_Some(encryptionContext), Option.create_Some(grantTokens), Option.create_Some(_189_kmsKeyArn), Option.create_None(), Option.create_None(), Option.create_None()));
        Result<DecryptResponse, Object> _192_valueOrError0 = Result.Default(DecryptResponse.Default());
        _192_valueOrError0 = _190_maybeDecryptResponse.MapFailure(DecryptResponse._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _193_e_boxed0 -> {
            software.amazon.cryptography.services.kms.internaldafny.types.Error _193_e = _193_e_boxed0;
            return Error.create_ComAmazonawsKms(_193_e);
        });
        if (_192_valueOrError0.IsFailure(DecryptResponse._typeDescriptor(), Error._typeDescriptor())) {
            output = _192_valueOrError0.PropagateFailure(DecryptResponse._typeDescriptor(), Error._typeDescriptor(), DecryptResponse._typeDescriptor());
            return output;
        }
        DecryptResponse _191_decryptResponse = _192_valueOrError0.Extract(DecryptResponse._typeDescriptor(), Error._typeDescriptor());
        Outcome<Object> _194_valueOrError1 = Outcome.Default();
        _194_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _191_decryptResponse.dtor_Plaintext().is_Some() && Objects.equals(BigInteger.valueOf(32L), BigInteger.valueOf(_191_decryptResponse.dtor_Plaintext().dtor_value().length())), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS Decrypt: Key is not 32 bytes.")));
        if (_194_valueOrError1.IsFailure(Error._typeDescriptor())) {
            output = _194_valueOrError1.PropagateFailure(Error._typeDescriptor(), DecryptResponse._typeDescriptor());
            return output;
        }
        output = Result.create_Success(_191_decryptResponse);
        return output;
    }

    public String toString() {
        return "KMSKeystoreOperations._default";
    }
}

