/*
 * Decompiled with CFR 0.152.
 */
package ECDH;

import ECDH.ECCAlgorithm;
import ECDH._ExternBase___default;
import Signature.PublicKeyUtils;
import StandardLibraryInternal.InternalResult;
import Wrappers_Compile.Result;
import dafny.Array;
import dafny.DafnySequence;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;
import software.amazon.cryptography.primitives.ToDafny;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPrivateKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.model.AwsCryptographicPrimitivesError;
import software.amazon.smithy.dafny.conversion.ToDafny;

public class ECCUtils
extends _ExternBase___default {
    public static Result<DafnySequence<? extends Byte>, Error> GetPublicKey(ECDHCurveSpec dtor_eccAlgorithm, ECCPrivateKey dtor_privateKey) {
        ECCUtils.checkBCProvider();
        InternalResult<ECCAlgorithm, Error> maybeEccAlgorithm = ECCAlgorithm.eccAlgorithm(dtor_eccAlgorithm);
        if (maybeEccAlgorithm.isFailure()) {
            return ECCUtils.CreateExternGetPublicKeyFromPrivateError(maybeEccAlgorithm.error());
        }
        if (!maybeEccAlgorithm.value().curve.equals("SM2PKE")) {
            try {
                byte[] pem = ECCUtils.dafnyArrayUnWrapper(dtor_privateKey._pem);
                ECPrivateKey privateKey = (ECPrivateKey)ECCUtils.parsePrivateKeyEccPemBytesToPrivateKey(pem);
                ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)maybeEccAlgorithm.value().curve);
                BigInteger privateKeyOrder = privateKey.getParams().getOrder();
                BigInteger parameterSpecOrder = parameterSpec.getG().getCurve().getOrder();
                if (privateKeyOrder.compareTo(parameterSpecOrder) != 0) {
                    return ECCUtils.CreateExternGetPublicKeyFromPrivateError(ToDafny.Error(AwsCryptographicPrimitivesError.builder().message("Private Key NOT on configured curve spec.").build()));
                }
                org.bouncycastle.math.ec.ECPoint Q = parameterSpec.getG().multiply(privateKey.getS());
                org.bouncycastle.jce.spec.ECPublicKeySpec publicKeySpec = new org.bouncycastle.jce.spec.ECPublicKeySpec(Q, (org.bouncycastle.jce.spec.ECParameterSpec)parameterSpec);
                KeyFactory keyFactory = KeyFactory.getInstance("EC", "BC");
                PublicKey publicKey = keyFactory.generatePublic((KeySpec)publicKeySpec);
                X509EncodedKeySpec encodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
                return ECCUtils.CreateExternGetPublicKeyFromPrivateSuccess((DafnySequence<? extends Byte>)DafnySequence.fromBytes((byte[])encodedKeySpec.getEncoded()));
            }
            catch (Exception e) {
                return ECCUtils.CreateExternGetPublicKeyFromPrivateError(ToDafny.Error(AwsCryptographicPrimitivesError.builder().cause(e).message(e.getMessage()).build()));
            }
        }
        return ECCUtils.CreateExternGetPublicKeyFromPrivateError(ToDafny.Error(new RuntimeException("SM2 Not yet Supported.")));
    }

    public static PrivateKey parsePrivateKeyEccPemBytesToPrivateKey(byte[] pem) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        byte[] privateKeyBytes = ECCUtils.parsePrivateKeyPemBytes(pem);
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeyBytes));
    }

    public static Result<Boolean, Error> ValidatePublicKey(ECDHCurveSpec dtor_eccAlgorithm, DafnySequence<? extends Byte> dtro_publicKey) {
        ECCUtils.checkBCProvider();
        byte[] publicKeyBytes = ECCUtils.dafnyArrayUnWrapper(dtro_publicKey);
        InternalResult<ECCAlgorithm, Error> maybeEccAlgorithm = ECCAlgorithm.eccAlgorithm(dtor_eccAlgorithm);
        if (maybeEccAlgorithm.isFailure()) {
            return ECCUtils.CreateExternValidatePublicKeyError(maybeEccAlgorithm.error());
        }
        if (!maybeEccAlgorithm.value().curve.equals("SM2")) {
            try {
                boolean validPublicKey = ECCUtils.NistPublicKeyValidationCriteria(publicKeyBytes, maybeEccAlgorithm.value());
                return ECCUtils.CreateExternValidatePublicKeySuccess(validPublicKey);
            }
            catch (Exception e) {
                return ECCUtils.CreateExternValidatePublicKeyError(ToDafny.Error(AwsCryptographicPrimitivesError.builder().cause(e).message(e.getMessage()).build()));
            }
        }
        return ECCUtils.CreateExternValidatePublicKeyError(ToDafny.Error(new RuntimeException("SM2 Not yet Supported.")));
    }

    static boolean NistPublicKeyValidationCriteria(byte[] publicKeyBytes, ECCAlgorithm ecParameterSpec) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException, IllegalArgumentException {
        org.bouncycastle.jce.interfaces.ECPublicKey ecPublicKey;
        org.bouncycastle.math.ec.ECPoint ecPoint;
        KeyFactory keyFactory = KeyFactory.getInstance("EC", "BC");
        PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(publicKeyBytes));
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)ecParameterSpec.curve);
        ECCurve ecCurve = spec.getCurve();
        org.bouncycastle.math.ec.ECPoint pointOnCurve = ecCurve.validatePoint((ecPoint = (ecPublicKey = (org.bouncycastle.jce.interfaces.ECPublicKey)publicKey).getQ()).getAffineXCoord().toBigInteger(), ecPoint.getAffineYCoord().toBigInteger());
        return ECCUtils.ValidatePublicKeyIsNotInfinity(pointOnCurve) && ECCUtils.CoordinateBetween0AndP(ecPoint.getAffineXCoord().toBigInteger(), ecCurve) && ECCUtils.CoordinateBetween0AndP(ecPoint.getAffineYCoord().toBigInteger(), ecCurve);
    }

    private static boolean ValidatePublicKeyIsNotInfinity(org.bouncycastle.math.ec.ECPoint point) {
        return !point.isInfinity();
    }

    private static boolean CoordinateBetween0AndP(BigInteger coordinate, ECCurve curve) {
        return coordinate.compareTo(BigInteger.ZERO) > 0 && coordinate.compareTo(curve.getField().getCharacteristic()) < 0;
    }

    public static Result<DafnySequence<? extends Byte>, Error> CompressPublicKey(DafnySequence<? extends Byte> publicKeyDerBytes, ECDHCurveSpec dtor_eccAlgorithm) {
        try {
            ECCUtils.checkBCProvider();
            byte[] publicKeyBytes = ECCUtils.dafnyArrayUnWrapper(publicKeyDerBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("EC", "BC");
            org.bouncycastle.jce.interfaces.ECPublicKey publicKey = (org.bouncycastle.jce.interfaces.ECPublicKey)keyFactory.generatePublic(new X509EncodedKeySpec(publicKeyBytes));
            byte[] compressedPublicKey = publicKey.getQ().getEncoded(true);
            return ECCUtils.CreateExternCompressPublicKeySuccess((DafnySequence<? extends Byte>)DafnySequence.fromBytes((byte[])compressedPublicKey));
        }
        catch (Exception e) {
            return ECCUtils.CreateExternCompressPublicKeyError(ToDafny.Error(AwsCryptographicPrimitivesError.builder().message(e.getMessage()).build()));
        }
    }

    public static Result<DafnySequence<? extends Byte>, Error> DecompressPublicKey(DafnySequence<? extends Byte> compressedPublicKey, ECDHCurveSpec dtor_eccAlgorithm) {
        try {
            ECCUtils.checkBCProvider();
            InternalResult<ECCAlgorithm, Error> maybeEccAlgorithm = ECCAlgorithm.eccAlgorithm(dtor_eccAlgorithm);
            if (maybeEccAlgorithm.isFailure()) {
                return ECCUtils.CreateExternDecompressPublicKeyError(maybeEccAlgorithm.error());
            }
            ECParameterSpec ecParameterSpec = ECCUtils.ecParameterSpec(maybeEccAlgorithm.value());
            byte[] compressedPublicKeyBytes = ECCUtils.dafnyArrayUnWrapper(compressedPublicKey);
            ECPoint point = PublicKeyUtils.byteArrayToECPoint(compressedPublicKeyBytes, ecParameterSpec);
            ECPublicKeySpec spec = new ECPublicKeySpec(point, ecParameterSpec);
            ECPublicKey publicKey = (ECPublicKey)KeyFactory.getInstance("EC").generatePublic(spec);
            return ECCUtils.CreateExternDecompressPublicKeySuccess((DafnySequence<? extends Byte>)DafnySequence.fromBytes((byte[])publicKey.getEncoded()));
        }
        catch (Exception e) {
            return ECCUtils.CreateExternDecompressPublicKeyError(ToDafny.Error(AwsCryptographicPrimitivesError.builder().message(e.getMessage()).build()));
        }
    }

    public static Result<DafnySequence<? extends Byte>, Error> ParsePublicKey(DafnySequence<? extends Byte> publicKey) {
        try {
            ECCUtils.checkBCProvider();
            byte[] publicKeyBytes = ECCUtils.dafnyArrayUnWrapper(publicKey);
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKeyBytes);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded());
            KeyFactory keyFactory = KeyFactory.getInstance("EC", "BC");
            PublicKey ecPublicKey = keyFactory.generatePublic(x509KeySpec);
            return ECCUtils.CreateExternParsePublicKeySuccess((DafnySequence<? extends Byte>)DafnySequence.fromBytes((byte[])ecPublicKey.getEncoded()));
        }
        catch (Exception e) {
            return ECCUtils.CreateExternParsePublicKeyError(ToDafny.Error(AwsCryptographicPrimitivesError.builder().message(e.getMessage()).build()));
        }
    }

    static DafnySequence<Byte> encodePrivateKey(PrivateKey privateKey) throws IOException {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
        StringWriter stringWriter = new StringWriter();
        PemWriter pemWriter = new PemWriter((Writer)stringWriter);
        pemWriter.writeObject((PemObjectGenerator)new PemObject("PRIVATE KEY", pkcs8KeySpec.getEncoded()));
        pemWriter.close();
        ByteBuffer outBuffer = StandardCharsets.UTF_8.encode(stringWriter.toString());
        return ToDafny.Simple.ByteSequence((ByteBuffer)outBuffer, (int)0, (int)outBuffer.limit());
    }

    private static byte[] parsePrivateKeyPemBytes(byte[] pem) throws IOException {
        PemReader pemReader = new PemReader((Reader)new InputStreamReader(new ByteArrayInputStream(pem)));
        PemObject pemObject = pemReader.readPemObject();
        return pemObject.getContent();
    }

    public static byte[] dafnyArrayUnWrapper(DafnySequence<? extends Byte> dafnyByteSequence) {
        return (byte[])Array.unwrap((Array)dafnyByteSequence.toArray());
    }

    public static void checkBCProvider() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static ECParameterSpec ecParameterSpec(ECCAlgorithm eccAlgorithm) throws NoSuchAlgorithmException, InvalidParameterSpecException {
        ECGenParameterSpec spec = new ECGenParameterSpec(eccAlgorithm.curve);
        AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
        parameters.init(spec);
        return parameters.getParameterSpec(ECParameterSpec.class);
    }
}

