/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsEcdhKeyring_Compile;

import Actions_Compile.DeterministicAction;
import Actions_Compile.DeterministicActionWithResult;
import AwsKmsEcdhKeyring_Compile.__default;
import BoundedInts_Compile.uint8;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.KmsEcdhStaticConfigurations;

public class OnDecryptEcdhDataKeyFilter
implements DeterministicActionWithResult<EncryptedDataKey, Boolean, Error>,
DeterministicAction<EncryptedDataKey, Result<Boolean, Error>> {
    public KmsEcdhStaticConfigurations _keyAgreementScheme = KmsEcdhStaticConfigurations.Default();
    public DafnySequence<? extends Byte> _compressedRecipientPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    public DafnySequence<? extends Byte> _compressedSenderPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    private static final TypeDescriptor<OnDecryptEcdhDataKeyFilter> _TYPE = TypeDescriptor.referenceWithInitializer(OnDecryptEcdhDataKeyFilter.class, () -> null);

    public void __ctor(KmsEcdhStaticConfigurations keyAgreementScheme, DafnySequence<? extends Byte> compressedRecipientPublicKey, Option<DafnySequence<? extends Byte>> compressedSenderPublicKey) {
        this._keyAgreementScheme = keyAgreementScheme;
        this._compressedRecipientPublicKey = compressedRecipientPublicKey;
        this._compressedSenderPublicKey = compressedSenderPublicKey.is_Some() ? compressedSenderPublicKey.dtor_value() : DafnySequence.empty(uint8._typeDescriptor());
    }

    @Override
    public Result<Boolean, Error> Invoke(EncryptedDataKey edk) {
        Result<Boolean, Error> res = Result.Default(false);
        DafnySequence<? extends Byte> _1400_providerInfo = edk.dtor_keyProviderInfo();
        DafnySequence<? extends Byte> _1401_providerId = edk.dtor_keyProviderId();
        if (!_1401_providerId.equals(Constants_Compile.__default.RAW__ECDH__PROVIDER__ID()) && !_1401_providerId.equals(Constants_Compile.__default.KMS__ECDH__PROVIDER__ID())) {
            res = Result.create_Success(false);
            return res;
        }
        Outcome<Object> _1402_valueOrError0 = Outcome.Default();
        _1402_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_1400_providerInfo.length()).compareTo(BigInteger.valueOf(Integer.toUnsignedLong(Constants_Compile.__default.ECDH__PROVIDER__INFO__521__LEN()))) <= 0 && RawECDHKeyring_Compile.__default.ValidProviderInfoLength(_1400_providerInfo), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"EDK ProviderInfo longer than expected")));
        if (_1402_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _1402_valueOrError0.PropagateFailure(Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return res;
        }
        byte _1403_keyringVersion = (Byte)_1400_providerInfo.select(Helpers.toInt((BigInteger)BigInteger.ZERO));
        Outcome<Object> _1404_valueOrError1 = Outcome.Default();
        _1404_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), DafnySequence.of((byte[])new byte[]{_1403_keyringVersion}).equals(__default.AWS__KMS__ECDH__KEYRING__VERSION()), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Incorrect Keyring version found in provider info.")));
        if (_1404_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _1404_valueOrError1.PropagateFailure(Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return res;
        }
        BigInteger _1405_recipientPublicKeyLength = BigInteger.ZERO;
        _1405_recipientPublicKeyLength = BigInteger.valueOf(Integer.toUnsignedLong(StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)_1400_providerInfo.subsequence(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPL__INDEX(), Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX()))));
        BigInteger _1406_recipientPublicKeyLengthIndex = BigInteger.ZERO;
        _1406_recipientPublicKeyLengthIndex = BigInteger.valueOf(Integer.toUnsignedLong(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX())).add(_1405_recipientPublicKeyLength);
        BigInteger _1407_senderPublicKeyIndex = BigInteger.ZERO;
        _1407_senderPublicKeyIndex = _1406_recipientPublicKeyLengthIndex.add(Constants_Compile.__default.ECDH__PROVIDER__INFO__PUBLIC__KEY__LEN());
        Outcome<Object> _1408_valueOrError2 = Outcome.Default();
        _1408_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _1406_recipientPublicKeyLengthIndex.add(BigInteger.valueOf(4L)).compareTo(BigInteger.valueOf(_1400_providerInfo.length())) < 0, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Key Provider Info Serialization Error. Serialized length less than expected.")));
        if (_1408_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _1408_valueOrError2.PropagateFailure(Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return res;
        }
        DafnySequence _1409_providerInfoRecipientPublicKey = _1400_providerInfo.subsequence(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX(), Helpers.toInt((BigInteger)_1406_recipientPublicKeyLengthIndex));
        DafnySequence _1410_providerInfoSenderPublicKey = _1400_providerInfo.drop(_1407_senderPublicKeyIndex);
        if (this.keyAgreementScheme().is_KmsPublicKeyDiscovery()) {
            res = Result.create_Success(this.compressedRecipientPublicKey().equals((Object)_1409_providerInfoRecipientPublicKey));
            return res;
        }
        res = Result.create_Success(this.compressedSenderPublicKey().equals((Object)_1410_providerInfoSenderPublicKey) && this.compressedRecipientPublicKey().equals((Object)_1409_providerInfoRecipientPublicKey) || this.compressedSenderPublicKey().equals((Object)_1409_providerInfoRecipientPublicKey) && this.compressedRecipientPublicKey().equals((Object)_1410_providerInfoSenderPublicKey));
        return res;
    }

    public KmsEcdhStaticConfigurations keyAgreementScheme() {
        return this._keyAgreementScheme;
    }

    public DafnySequence<? extends Byte> compressedRecipientPublicKey() {
        return this._compressedRecipientPublicKey;
    }

    public DafnySequence<? extends Byte> compressedSenderPublicKey() {
        return this._compressedSenderPublicKey;
    }

    public static TypeDescriptor<OnDecryptEcdhDataKeyFilter> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsEcdhKeyring.OnDecryptEcdhDataKeyFilter";
    }
}

