/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import software.amazon.cryptography.primitives.model.RSAPaddingMode;

public class RSAEncryptInput {
    private final RSAPaddingMode padding;
    private final ByteBuffer publicKey;
    private final ByteBuffer plaintext;

    protected RSAEncryptInput(BuilderImpl builder) {
        this.padding = builder.padding();
        this.publicKey = builder.publicKey();
        this.plaintext = builder.plaintext();
    }

    public RSAPaddingMode padding() {
        return this.padding;
    }

    public ByteBuffer publicKey() {
        return this.publicKey;
    }

    public ByteBuffer plaintext() {
        return this.plaintext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected RSAPaddingMode padding;
        protected ByteBuffer publicKey;
        protected ByteBuffer plaintext;

        protected BuilderImpl() {
        }

        protected BuilderImpl(RSAEncryptInput model) {
            this.padding = model.padding();
            this.publicKey = model.publicKey();
            this.plaintext = model.plaintext();
        }

        @Override
        public Builder padding(RSAPaddingMode padding) {
            this.padding = padding;
            return this;
        }

        @Override
        public RSAPaddingMode padding() {
            return this.padding;
        }

        @Override
        public Builder publicKey(ByteBuffer publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Override
        public ByteBuffer publicKey() {
            return this.publicKey;
        }

        @Override
        public Builder plaintext(ByteBuffer plaintext) {
            this.plaintext = plaintext;
            return this;
        }

        @Override
        public ByteBuffer plaintext() {
            return this.plaintext;
        }

        @Override
        public RSAEncryptInput build() {
            if (Objects.isNull((Object)this.padding())) {
                throw new IllegalArgumentException("Missing value for required field `padding`");
            }
            if (Objects.isNull(this.publicKey())) {
                throw new IllegalArgumentException("Missing value for required field `publicKey`");
            }
            if (Objects.isNull(this.plaintext())) {
                throw new IllegalArgumentException("Missing value for required field `plaintext`");
            }
            return new RSAEncryptInput(this);
        }
    }

    public static interface Builder {
        public Builder padding(RSAPaddingMode var1);

        public RSAPaddingMode padding();

        public Builder publicKey(ByteBuffer var1);

        public ByteBuffer publicKey();

        public Builder plaintext(ByteBuffer var1);

        public ByteBuffer plaintext();

        public RSAEncryptInput build();
    }
}

