/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.nio.ByteBuffer;
import java.util.Objects;

public class EncryptedDataKey {
    private final String keyProviderId;
    private final ByteBuffer keyProviderInfo;
    private final ByteBuffer ciphertext;

    protected EncryptedDataKey(BuilderImpl builder) {
        this.keyProviderId = builder.keyProviderId();
        this.keyProviderInfo = builder.keyProviderInfo();
        this.ciphertext = builder.ciphertext();
    }

    public String keyProviderId() {
        return this.keyProviderId;
    }

    public ByteBuffer keyProviderInfo() {
        return this.keyProviderInfo;
    }

    public ByteBuffer ciphertext() {
        return this.ciphertext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String keyProviderId;
        protected ByteBuffer keyProviderInfo;
        protected ByteBuffer ciphertext;

        protected BuilderImpl() {
        }

        protected BuilderImpl(EncryptedDataKey model) {
            this.keyProviderId = model.keyProviderId();
            this.keyProviderInfo = model.keyProviderInfo();
            this.ciphertext = model.ciphertext();
        }

        @Override
        public Builder keyProviderId(String keyProviderId) {
            this.keyProviderId = keyProviderId;
            return this;
        }

        @Override
        public String keyProviderId() {
            return this.keyProviderId;
        }

        @Override
        public Builder keyProviderInfo(ByteBuffer keyProviderInfo) {
            this.keyProviderInfo = keyProviderInfo;
            return this;
        }

        @Override
        public ByteBuffer keyProviderInfo() {
            return this.keyProviderInfo;
        }

        @Override
        public Builder ciphertext(ByteBuffer ciphertext) {
            this.ciphertext = ciphertext;
            return this;
        }

        @Override
        public ByteBuffer ciphertext() {
            return this.ciphertext;
        }

        @Override
        public EncryptedDataKey build() {
            if (Objects.isNull(this.keyProviderId())) {
                throw new IllegalArgumentException("Missing value for required field `keyProviderId`");
            }
            if (Objects.isNull(this.keyProviderInfo())) {
                throw new IllegalArgumentException("Missing value for required field `keyProviderInfo`");
            }
            if (Objects.isNull(this.ciphertext())) {
                throw new IllegalArgumentException("Missing value for required field `ciphertext`");
            }
            return new EncryptedDataKey(this);
        }
    }

    public static interface Builder {
        public Builder keyProviderId(String var1);

        public String keyProviderId();

        public Builder keyProviderInfo(ByteBuffer var1);

        public ByteBuffer keyProviderInfo();

        public Builder ciphertext(ByteBuffer var1);

        public ByteBuffer ciphertext();

        public EncryptedDataKey build();
    }
}

