/*
 * Decompiled with CFR 0.152.
 */
package RawRSAKeyring_Compile;

import BoundedInts_Compile.uint8;
import EdkWrapping_Compile.UnwrapEdkMaterialOutput;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import RawRSAKeyring_Compile.RsaGenerateAndWrapKeyMaterial;
import RawRSAKeyring_Compile.RsaUnwrapInfo;
import RawRSAKeyring_Compile.RsaUnwrapKeyMaterial;
import RawRSAKeyring_Compile.RsaWrapInfo;
import RawRSAKeyring_Compile.RsaWrapKeyMaterial;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.__default;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.RSAPaddingMode;

public class RawRSAKeyring
implements VerifiableInterface,
IKeyring {
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public DafnySequence<? extends Byte> _keyNamespace = ValidUTF8Bytes.defaultValue();
    public DafnySequence<? extends Byte> _keyName = ValidUTF8Bytes.defaultValue();
    public RSAPaddingMode _paddingScheme = RSAPaddingMode.Default();
    public Option<DafnySequence<? extends Byte>> _publicKey = Option.Default();
    public Option<DafnySequence<? extends Byte>> _privateKey = Option.Default();
    private static final TypeDescriptor<RawRSAKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(RawRSAKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out204 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out204;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out205 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out205;
    }

    public void __ctor(DafnySequence<? extends Byte> namespace, DafnySequence<? extends Byte> name, Option<DafnySequence<? extends Byte>> publicKey, Option<DafnySequence<? extends Byte>> privateKey, RSAPaddingMode paddingScheme, AtomicPrimitivesClient cryptoPrimitives) {
        this._keyNamespace = namespace;
        this._keyName = name;
        this._paddingScheme = paddingScheme;
        this._publicKey = publicKey;
        this._privateKey = privateKey;
        this._cryptoPrimitives = cryptoPrimitives;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> output = null;
        Outcome<Object> _1193_valueOrError0 = Outcome.Default();
        _1193_valueOrError0 = __default.Need(Error._typeDescriptor(), this.publicKey().is_Some() && BigInteger.valueOf(this.publicKey().Extract((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor())).length()).signum() == 1, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"A RawRSAKeyring without a public key cannot provide OnEncrypt")));
        if (_1193_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _1193_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return output;
        }
        EncryptionMaterials _1194_materials = input.dtor_materials();
        AlgorithmSuiteInfo _1195_suite = _1194_materials.dtor_algorithmSuite();
        RsaWrapKeyMaterial _nw48 = new RsaWrapKeyMaterial();
        _nw48.__ctor(this.publicKey().dtor_value(), this.paddingScheme(), this.cryptoPrimitives());
        RsaWrapKeyMaterial _1196_wrap = _nw48;
        RsaGenerateAndWrapKeyMaterial _nw49 = new RsaGenerateAndWrapKeyMaterial();
        _nw49.__ctor(this.publicKey().dtor_value(), this.paddingScheme(), this.cryptoPrimitives());
        RsaGenerateAndWrapKeyMaterial _1197_generateAndWrap = _nw49;
        Result<WrapEdkMaterialOutput<RsaWrapInfo>, Object> _1199_valueOrError1 = Result.Default(WrapEdkMaterialOutput.Default(RsaWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<RsaWrapInfo>, Error> _out206 = EdkWrapping_Compile.__default.WrapEdkMaterial(RsaWrapInfo._typeDescriptor(), _1194_materials, _1196_wrap, _1197_generateAndWrap);
        _1199_valueOrError1 = _out206;
        if (_1199_valueOrError1.IsFailure(WrapEdkMaterialOutput._typeDescriptor(RsaWrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            output = _1199_valueOrError1.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(RsaWrapInfo._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return output;
        }
        WrapEdkMaterialOutput<RsaWrapInfo> _1198_wrapOutput = _1199_valueOrError1.Extract(WrapEdkMaterialOutput._typeDescriptor(RsaWrapInfo._typeDescriptor()), Error._typeDescriptor());
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _1200_symmetricSigningKeyList = _1198_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_1198_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None();
        EncryptedDataKey _1201_edk = EncryptedDataKey.create(this.keyNamespace(), this.keyName(), _1198_wrapOutput.dtor_wrappedMaterial());
        if (_1198_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _1203_valueOrError2 = null;
            _1203_valueOrError2 = Materials_Compile.__default.EncryptionMaterialAddDataKey(_1194_materials, _1198_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_1201_edk}), _1200_symmetricSigningKeyList);
            if (_1203_valueOrError2.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                output = _1203_valueOrError2.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return output;
            }
            EncryptionMaterials _1202_result = _1203_valueOrError2.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            output = Result.create_Success(OnEncryptOutput.create(_1202_result));
            return output;
        }
        if (_1198_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _1205_valueOrError3 = null;
            _1205_valueOrError3 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(_1194_materials, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_1201_edk}), _1200_symmetricSigningKeyList);
            if (_1205_valueOrError3.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                output = _1205_valueOrError3.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return output;
            }
            EncryptionMaterials _1204_result = _1205_valueOrError3.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            output = Result.create_Success(OnEncryptOutput.create(_1204_result));
            return output;
        }
        return output;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> output = null;
        Outcome<Object> _1206_valueOrError0 = Outcome.Default();
        _1206_valueOrError0 = __default.Need(Error._typeDescriptor(), this.privateKey().is_Some() && BigInteger.valueOf(this.privateKey().Extract((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor())).length()).signum() == 1, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"A RawRSAKeyring without a private key cannot provide OnEncrypt")));
        if (_1206_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _1206_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        DecryptionMaterials _1207_materials = input.dtor_materials();
        Outcome<Object> _1208_valueOrError1 = Outcome.Default();
        _1208_valueOrError1 = __default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_1207_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_1208_valueOrError1.IsFailure(Error._typeDescriptor())) {
            output = _1208_valueOrError1.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        DafnySequence _1209_errors = DafnySequence.empty(Error._typeDescriptor());
        BigInteger _hi9 = BigInteger.valueOf(input.dtor_encryptedDataKeys().length());
        BigInteger _1210_i = BigInteger.ZERO;
        while (_1210_i.compareTo(_hi9) < 0) {
            if (this.ShouldDecryptEDK((EncryptedDataKey)input.dtor_encryptedDataKeys().select(Helpers.toInt((BigInteger)_1210_i)))) {
                Result<UnwrapEdkMaterialOutput<RsaUnwrapInfo>, Error> _out207;
                EncryptedDataKey _1211_edk = (EncryptedDataKey)input.dtor_encryptedDataKeys().select(Helpers.toInt((BigInteger)_1210_i));
                RsaUnwrapKeyMaterial _nw50 = new RsaUnwrapKeyMaterial();
                _nw50.__ctor(this.privateKey().Extract((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor())), this.paddingScheme(), this.cryptoPrimitives());
                RsaUnwrapKeyMaterial _1212_unwrap = _nw50;
                Result<UnwrapEdkMaterialOutput<RsaUnwrapInfo>, Error> _1213_unwrapOutput = _out207 = EdkWrapping_Compile.__default.UnwrapEdkMaterial(RsaUnwrapInfo._typeDescriptor(), _1211_edk.dtor_ciphertext(), _1207_materials, _1212_unwrap);
                if (_1213_unwrapOutput.is_Success()) {
                    Result<DecryptionMaterials, Error> _1215_valueOrError2 = null;
                    _1215_valueOrError2 = Materials_Compile.__default.DecryptionMaterialsAddDataKey(_1207_materials, _1213_unwrapOutput.dtor_value().dtor_plaintextDataKey(), _1213_unwrapOutput.dtor_value().dtor_symmetricSigningKey());
                    if (_1215_valueOrError2.IsFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                        output = _1215_valueOrError2.PropagateFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                        return output;
                    }
                    DecryptionMaterials _1214_returnMaterials = _1215_valueOrError2.Extract(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
                    output = Result.create_Success(OnDecryptOutput.create(_1214_returnMaterials));
                    return output;
                }
                _1209_errors = DafnySequence.concatenate((DafnySequence)_1209_errors, (DafnySequence)DafnySequence.of(Error._typeDescriptor(), (Object[])new Error[]{_1213_unwrapOutput.dtor_error()}));
            } else {
                Result<Object, Object> _1217_valueOrError3 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
                _1217_valueOrError3 = UTF8.__default.Decode(((EncryptedDataKey)input.dtor_encryptedDataKeys().select(Helpers.toInt((BigInteger)_1210_i))).dtor_keyProviderId()).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _1218_e_boxed0 -> {
                    DafnySequence _1218_e = _1218_e_boxed0;
                    return Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_1218_e);
                });
                if (_1217_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                    output = _1217_valueOrError3.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                    return output;
                }
                DafnySequence _1216_extractedKeyProviderId = (DafnySequence)_1217_valueOrError3.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
                _1209_errors = DafnySequence.concatenate((DafnySequence)_1209_errors, (DafnySequence)DafnySequence.of(Error._typeDescriptor(), (Object[])new Error[]{Error.create_AwsCryptographicMaterialProvidersException(ErrorMessages_Compile.__default.IncorrectRawDataKeys(String_Compile.__default.Base10Int2String(_1210_i), (DafnySequence<? extends Character>)DafnySequence.asString((String)"RSAKeyring"), (DafnySequence<? extends Character>)_1216_extractedKeyProviderId))}));
            }
            _1210_i = _1210_i.add(BigInteger.ONE);
        }
        output = Result.create_Failure(Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_1209_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"Raw RSA Key was unable to decrypt any encrypted data key. The list of encountered Exceptions is avaible via `list`.")));
        return output;
    }

    public boolean ShouldDecryptEDK(EncryptedDataKey edk) {
        return UTF8.__default.ValidUTF8Seq(edk.dtor_keyProviderInfo()) && edk.dtor_keyProviderInfo().equals(this.keyName()) && edk.dtor_keyProviderId().equals(this.keyNamespace()) && BigInteger.valueOf(edk.dtor_ciphertext().length()).signum() == 1;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public DafnySequence<? extends Byte> keyNamespace() {
        return this._keyNamespace;
    }

    public DafnySequence<? extends Byte> keyName() {
        return this._keyName;
    }

    public RSAPaddingMode paddingScheme() {
        return this._paddingScheme;
    }

    public Option<DafnySequence<? extends Byte>> publicKey() {
        return this._publicKey;
    }

    public Option<DafnySequence<? extends Byte>> privateKey() {
        return this._privateKey;
    }

    public static TypeDescriptor<RawRSAKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "RawRSAKeyring.RawRSAKeyring";
    }
}

