/*
 * Decompiled with CFR 0.152.
 */
package Materials_Compile;

import BoundedInts_Compile.uint8;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.DafnySet;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import java.util.function.Function;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.ECDSA;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.InitializeDecryptionMaterialsInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.InitializeEncryptionMaterialsInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.None;
import software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm;
import software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm_ECDSA;
import software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm_None;

public class __default {
    public static Result<EncryptionMaterials, Error> InitializeEncryptionMaterials(InitializeEncryptionMaterialsInput input) {
        InitializeEncryptionMaterialsInput _pat_let_tv0 = input;
        InitializeEncryptionMaterialsInput _pat_let_tv1 = input;
        InitializeEncryptionMaterialsInput _pat_let_tv2 = input;
        Outcome<Error> _366_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), !input.dtor_encryptionContext().contains(__default.EC__PUBLIC__KEY__FIELD()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Encryption Context ")));
        if (_366_valueOrError0.IsFailure(Error._typeDescriptor())) {
            return _366_valueOrError0.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _367_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), ((Function<InitializeEncryptionMaterialsInput, Boolean>)_368_input -> Helpers.Quantifier((Iterable)_368_input.dtor_requiredEncryptionContextKeys().UniqueElements(), (boolean)true, _forall_var_8_boxed0 -> {
            DafnySequence _forall_var_8;
            DafnySequence _369_key = _forall_var_8 = _forall_var_8_boxed0;
            return !_368_input.dtor_requiredEncryptionContextKeys().contains((Object)_369_key) || _368_input.dtor_encryptionContext().contains((Object)_369_key);
        })).apply(input), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Required encryption context keys do not exist in provided encryption context.")));
        if (_367_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _367_valueOrError1.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        AlgorithmSuiteInfo _370_suite = AlgorithmSuites_Compile.__default.GetSuite(input.dtor_algorithmSuiteId());
        Outcome<Error> _371_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _370_suite.dtor_signature().is_ECDSA() == (input.dtor_signingKey().is_Some() && input.dtor_verificationKey().is_Some()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Missing signature key for signed suite.")));
        if (_371_valueOrError2.IsFailure(Error._typeDescriptor())) {
            return _371_valueOrError2.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _372_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _370_suite.dtor_signature().is_None() == (input.dtor_signingKey().is_None() && input.dtor_verificationKey().is_None()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Signature key not allowed for non-signed suites.")));
        if (_372_valueOrError3.IsFailure(Error._typeDescriptor())) {
            return _372_valueOrError3.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Result _373_valueOrError4 = ((Function<SignatureAlgorithm, Result>)_source20_boxed0 -> {
            SignatureAlgorithm _source20 = _source20_boxed0;
            if (_source20.is_ECDSA()) {
                ECDSA _374___mcc_h0 = ((SignatureAlgorithm_ECDSA)_source20)._ECDSA;
                return (Result)Helpers.Let((Object)_374___mcc_h0, boxed4 -> {
                    ECDSA _pat_let2_0 = boxed4;
                    return (Result)Helpers.Let((Object)_pat_let2_0, boxed5 -> {
                        ECDSA _375_curve = boxed5;
                        return (Result)Helpers.Let(UTF8.__default.Encode(Base64_Compile.__default.Encode(_pat_let_tv0.dtor_verificationKey().dtor_value())).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _376_e_boxed0 -> {
                            DafnySequence _376_e = _376_e_boxed0;
                            return Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_376_e);
                        }), boxed6 -> {
                            Result _pat_let3_0 = boxed6;
                            return (Result)Helpers.Let((Object)_pat_let3_0, boxed7 -> {
                                Result _377_valueOrError5 = boxed7;
                                return _377_valueOrError5.IsFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor()) ? _377_valueOrError5.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor(), DafnyMap._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor())) : (Result)Helpers.Let(_377_valueOrError5.Extract(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor()), boxed8 -> {
                                    DafnySequence _pat_let4_0 = boxed8;
                                    return (Result)Helpers.Let((Object)_pat_let4_0, boxed9 -> {
                                        DafnySequence _378_enc__vk = boxed9;
                                        return Result.create_Success(DafnyMap.update(_pat_let_tv1.dtor_encryptionContext(), __default.EC__PUBLIC__KEY__FIELD(), (Object)_378_enc__vk));
                                    });
                                });
                            });
                        });
                    });
                });
            }
            None _379___mcc_h2 = ((SignatureAlgorithm_None)_source20)._None;
            return (Result)Helpers.Let((Object)_370_suite.dtor_signature(), boxed10 -> {
                SignatureAlgorithm _pat_let5_0 = boxed10;
                return (Result)Helpers.Let((Object)_pat_let5_0, boxed11 -> {
                    SignatureAlgorithm _380_None = boxed11;
                    return Result.create_Success(_pat_let_tv2.dtor_encryptionContext());
                });
            });
        }).apply(_370_suite.dtor_signature());
        if (_373_valueOrError4.IsFailure(DafnyMap._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()), Error._typeDescriptor())) {
            return _373_valueOrError4.PropagateFailure(DafnyMap._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()), Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        DafnyMap _381_encryptionContext = (DafnyMap)_373_valueOrError4.Extract(DafnyMap._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()), Error._typeDescriptor());
        return Result.create_Success(EncryptionMaterials.create(_370_suite, (DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>)_381_encryptionContext, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.empty(EncryptedDataKey._typeDescriptor()), input.dtor_requiredEncryptionContextKeys(), Option.create_None(), input.dtor_signingKey(), _370_suite.dtor_symmetricSignature().is_None() ? Option.create_None() : Option.create_Some(DafnySequence.empty((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor())))));
    }

    public static Result<DecryptionMaterials, Error> InitializeDecryptionMaterials(InitializeDecryptionMaterialsInput input) {
        Outcome<Error> _382_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), ((Function<InitializeDecryptionMaterialsInput, Boolean>)_383_input -> Helpers.Quantifier((Iterable)_383_input.dtor_requiredEncryptionContextKeys().UniqueElements(), (boolean)true, _forall_var_9_boxed0 -> {
            DafnySequence _forall_var_9;
            DafnySequence _384_key = _forall_var_9 = _forall_var_9_boxed0;
            return !_383_input.dtor_requiredEncryptionContextKeys().contains((Object)_384_key) || _383_input.dtor_encryptionContext().contains((Object)_384_key);
        })).apply(input), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Reporoduced encryption context key did not exist in provided encryption context.")));
        if (_382_valueOrError0.IsFailure(Error._typeDescriptor())) {
            return _382_valueOrError0.PropagateFailure(Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        AlgorithmSuiteInfo _385_suite = AlgorithmSuites_Compile.__default.GetSuite(input.dtor_algorithmSuiteId());
        Outcome<Error> _386_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _385_suite.dtor_signature().is_ECDSA() == input.dtor_encryptionContext().contains(__default.EC__PUBLIC__KEY__FIELD()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Encryption Context missing verification key.")));
        if (_386_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _386_valueOrError1.PropagateFailure(Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _387_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _385_suite.dtor_signature().is_None() == !input.dtor_encryptionContext().contains(__default.EC__PUBLIC__KEY__FIELD()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Verification key can not exist in non-signed Algorithm Suites.")));
        if (_387_valueOrError2.IsFailure(Error._typeDescriptor())) {
            return _387_valueOrError2.PropagateFailure(Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        Result<Option<DafnySequence<? extends Byte>>, Error> _388_valueOrError3 = __default.DecodeVerificationKey(input.dtor_encryptionContext());
        if (_388_valueOrError3.IsFailure(Option._typeDescriptor(DafnySequence._typeDescriptor(uint8._typeDescriptor())), Error._typeDescriptor())) {
            return _388_valueOrError3.PropagateFailure(Option._typeDescriptor(DafnySequence._typeDescriptor(uint8._typeDescriptor())), Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        Option<DafnySequence<? extends Byte>> _389_verificationKey = _388_valueOrError3.Extract(Option._typeDescriptor(DafnySequence._typeDescriptor(uint8._typeDescriptor())), Error._typeDescriptor());
        return Result.create_Success(DecryptionMaterials.create(_385_suite, input.dtor_encryptionContext(), input.dtor_requiredEncryptionContextKeys(), Option.create_None(), _389_verificationKey, Option.create_None()));
    }

    public static Result<Option<DafnySequence<? extends Byte>>, Error> DecodeVerificationKey(DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> encryptionContext) {
        if (encryptionContext.contains(__default.EC__PUBLIC__KEY__FIELD())) {
            DafnySequence _390_utf8Key = (DafnySequence)encryptionContext.get(__default.EC__PUBLIC__KEY__FIELD());
            Result<DafnySequence<? extends Character>, Error> _391_valueOrError0 = UTF8.__default.Decode((DafnySequence<? extends Byte>)_390_utf8Key).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _392_e_boxed0 -> {
                DafnySequence _392_e = _392_e_boxed0;
                return Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_392_e);
            });
            if (_391_valueOrError0.IsFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                return _391_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), Option._typeDescriptor(DafnySequence._typeDescriptor(uint8._typeDescriptor())));
            }
            DafnySequence<? extends Character> _393_base64Key = _391_valueOrError0.Extract((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
            Result<DafnySequence<? extends Byte>, Error> _394_valueOrError1 = Base64_Compile.__default.Decode(_393_base64Key).MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _395_e_boxed0 -> {
                DafnySequence _395_e = _395_e_boxed0;
                return Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_395_e);
            });
            if (_394_valueOrError1.IsFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
                return _394_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), Option._typeDescriptor(DafnySequence._typeDescriptor(uint8._typeDescriptor())));
            }
            DafnySequence<? extends Byte> _396_key = _394_valueOrError1.Extract((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
            return Result.create_Success(Option.create_Some(_396_key));
        }
        return Result.create_Success(Option.create_None());
    }

    public static boolean ValidEncryptionMaterialsTransition(EncryptionMaterials oldMat, EncryptionMaterials newMat) {
        return Objects.equals(newMat.dtor_algorithmSuite(), oldMat.dtor_algorithmSuite()) && newMat.dtor_encryptionContext().equals(oldMat.dtor_encryptionContext()) && newMat.dtor_requiredEncryptionContextKeys().equals(oldMat.dtor_requiredEncryptionContextKeys()) && Objects.equals(newMat.dtor_signingKey(), oldMat.dtor_signingKey()) && (oldMat.dtor_plaintextDataKey().is_None() && newMat.dtor_plaintextDataKey().is_Some() || Objects.equals(oldMat.dtor_plaintextDataKey(), newMat.dtor_plaintextDataKey())) && newMat.dtor_plaintextDataKey().is_Some() && BigInteger.valueOf(oldMat.dtor_encryptedDataKeys().length()).compareTo(BigInteger.valueOf(newMat.dtor_encryptedDataKeys().length())) <= 0 && oldMat.dtor_encryptedDataKeys().asDafnyMultiset().isSubsetOf(newMat.dtor_encryptedDataKeys().asDafnyMultiset()) && (oldMat.dtor_algorithmSuite().dtor_symmetricSignature().is_None() || newMat.dtor_symmetricSigningKeys().is_Some() && oldMat.dtor_symmetricSigningKeys().is_Some() && oldMat.dtor_symmetricSigningKeys().dtor_value().asDafnyMultiset().isSubsetOf(newMat.dtor_symmetricSigningKeys().dtor_value().asDafnyMultiset())) && __default.ValidEncryptionMaterials(oldMat) && __default.ValidEncryptionMaterials(newMat);
    }

    public static boolean ValidEncryptionMaterials(EncryptionMaterials encryptionMaterials) {
        EncryptionMaterials _pat_let_tv3 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv4 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv5 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv6 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv7 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv8 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv9 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv10 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv11 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv12 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv13 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv14 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv15 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv16 = encryptionMaterials;
        return AlgorithmSuites_Compile.__default.AlgorithmSuite_q(encryptionMaterials.dtor_algorithmSuite()) && (Boolean)Helpers.Let((Object)encryptionMaterials.dtor_algorithmSuite(), boxed12 -> {
            AlgorithmSuiteInfo _pat_let6_0 = boxed12;
            return (boolean)((Boolean)Helpers.Let((Object)_pat_let6_0, boxed13 -> {
                AlgorithmSuiteInfo _397_suite = boxed13;
                return !(_397_suite.dtor_signature().is_None() != _pat_let_tv3.dtor_signingKey().is_None() || _pat_let_tv4.dtor_plaintextDataKey().is_Some() && !Objects.equals(BigInteger.valueOf(AlgorithmSuites_Compile.__default.GetEncryptKeyLength(_397_suite)), BigInteger.valueOf(_pat_let_tv5.dtor_plaintextDataKey().dtor_value().length())) || _pat_let_tv6.dtor_plaintextDataKey().is_None() && BigInteger.valueOf(_pat_let_tv7.dtor_encryptedDataKeys().length()).signum() != 0 || !_397_suite.dtor_signature().is_None() != _pat_let_tv8.dtor_encryptionContext().contains(__default.EC__PUBLIC__KEY__FIELD()) || _397_suite.dtor_signature().is_ECDSA() != _pat_let_tv9.dtor_signingKey().is_Some() || !_397_suite.dtor_signature().is_None() != _pat_let_tv10.dtor_encryptionContext().contains(__default.EC__PUBLIC__KEY__FIELD()) || _397_suite.dtor_symmetricSignature().is_HMAC() && _pat_let_tv11.dtor_symmetricSigningKeys().is_Some() && !Objects.equals(BigInteger.valueOf(_pat_let_tv12.dtor_symmetricSigningKeys().dtor_value().length()), BigInteger.valueOf(_pat_let_tv13.dtor_encryptedDataKeys().length())) || _397_suite.dtor_symmetricSignature().is_HMAC() && !_pat_let_tv14.dtor_symmetricSigningKeys().is_Some() || _397_suite.dtor_symmetricSignature().is_None() && !_pat_let_tv15.dtor_symmetricSigningKeys().is_None() || ((Function<EncryptionMaterials, Boolean>)_398_encryptionMaterials -> Helpers.Quantifier((Iterable)_398_encryptionMaterials.dtor_requiredEncryptionContextKeys().UniqueElements(), (boolean)true, _forall_var_10_boxed0 -> {
                    DafnySequence _forall_var_10;
                    DafnySequence _399_key = _forall_var_10 = _forall_var_10_boxed0;
                    return !_398_encryptionMaterials.dtor_requiredEncryptionContextKeys().contains((Object)_399_key) || _398_encryptionMaterials.dtor_encryptionContext().contains((Object)_399_key);
                })).apply(_pat_let_tv16) == false);
            }));
        }) != false;
    }

    public static boolean EncryptionMaterialsHasPlaintextDataKey(EncryptionMaterials encryptionMaterials) {
        return encryptionMaterials.dtor_plaintextDataKey().is_Some() && BigInteger.valueOf(encryptionMaterials.dtor_encryptedDataKeys().length()).signum() == 1 && __default.ValidEncryptionMaterials(encryptionMaterials);
    }

    public static Result<EncryptionMaterials, Error> EncryptionMaterialAddEncryptedDataKeys(EncryptionMaterials encryptionMaterials, DafnySequence<? extends EncryptedDataKey> encryptedDataKeysToAdd, Option<DafnySequence<? extends DafnySequence<? extends Byte>>> symmetricSigningKeysToAdd) {
        Outcome<Error> _400_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), __default.ValidEncryptionMaterials(encryptionMaterials), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Attempt to modify invalid encryption material.")));
        if (_400_valueOrError0.IsFailure(Error._typeDescriptor())) {
            return _400_valueOrError0.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _401_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), encryptionMaterials.dtor_plaintextDataKey().is_Some(), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Adding encrypted data keys without a plaintext data key is not allowed.")));
        if (_401_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _401_valueOrError1.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _402_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), !symmetricSigningKeysToAdd.is_None() || encryptionMaterials.dtor_algorithmSuite().dtor_symmetricSignature().is_None(), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Adding encrypted data keys without a symmetric signing key when using symmetric signing is not allowed.")));
        if (_402_valueOrError2.IsFailure(Error._typeDescriptor())) {
            return _402_valueOrError2.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _403_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), !symmetricSigningKeysToAdd.is_Some() || !encryptionMaterials.dtor_algorithmSuite().dtor_symmetricSignature().is_None(), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Adding encrypted data keys with a symmetric signing key when not using symmetric signing is not allowed.")));
        if (_403_valueOrError3.IsFailure(Error._typeDescriptor())) {
            return _403_valueOrError3.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _404_symmetricSigningKeys = symmetricSigningKeysToAdd.is_None() ? encryptionMaterials.dtor_symmetricSigningKeys() : Option.create_Some(DafnySequence.concatenate(encryptionMaterials.dtor_symmetricSigningKeys().dtor_value(), symmetricSigningKeysToAdd.dtor_value()));
        return Result.create_Success(EncryptionMaterials.create(encryptionMaterials.dtor_algorithmSuite(), encryptionMaterials.dtor_encryptionContext(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.concatenate(encryptionMaterials.dtor_encryptedDataKeys(), encryptedDataKeysToAdd), encryptionMaterials.dtor_requiredEncryptionContextKeys(), encryptionMaterials.dtor_plaintextDataKey(), encryptionMaterials.dtor_signingKey(), _404_symmetricSigningKeys));
    }

    public static Result<EncryptionMaterials, Error> EncryptionMaterialAddDataKey(EncryptionMaterials encryptionMaterials, DafnySequence<? extends Byte> plaintextDataKey, DafnySequence<? extends EncryptedDataKey> encryptedDataKeysToAdd, Option<DafnySequence<? extends DafnySequence<? extends Byte>>> symmetricSigningKeysToAdd) {
        AlgorithmSuiteInfo _405_suite = encryptionMaterials.dtor_algorithmSuite();
        Outcome<Error> _406_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), __default.ValidEncryptionMaterials(encryptionMaterials), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Attempt to modify invalid encryption material.")));
        if (_406_valueOrError0.IsFailure(Error._typeDescriptor())) {
            return _406_valueOrError0.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _407_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), encryptionMaterials.dtor_plaintextDataKey().is_None(), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Attempt to modify plaintextDataKey.")));
        if (_407_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _407_valueOrError1.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _408_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Objects.equals(BigInteger.valueOf(AlgorithmSuites_Compile.__default.GetEncryptKeyLength(_405_suite)), BigInteger.valueOf(plaintextDataKey.length())), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"plaintextDataKey does not match Algorithm Suite specification.")));
        if (_408_valueOrError2.IsFailure(Error._typeDescriptor())) {
            return _408_valueOrError2.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _409_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), symmetricSigningKeysToAdd.is_None() == encryptionMaterials.dtor_algorithmSuite().dtor_symmetricSignature().is_None(), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Adding encrypted data keys without a symmetric signing key when using symmetric signing is not allowed.")));
        if (_409_valueOrError3.IsFailure(Error._typeDescriptor())) {
            return _409_valueOrError3.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _410_valueOrError4 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), symmetricSigningKeysToAdd.is_Some() == !encryptionMaterials.dtor_algorithmSuite().dtor_symmetricSignature().is_None(), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Adding encrypted data keys with a symmetric signing key when not using symmetric signing is not allowed.")));
        if (_410_valueOrError4.IsFailure(Error._typeDescriptor())) {
            return _410_valueOrError4.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _411_symmetricSigningKeys = symmetricSigningKeysToAdd.is_None() ? encryptionMaterials.dtor_symmetricSigningKeys() : Option.create_Some(DafnySequence.concatenate(encryptionMaterials.dtor_symmetricSigningKeys().dtor_value(), symmetricSigningKeysToAdd.dtor_value()));
        return Result.create_Success(EncryptionMaterials.create(encryptionMaterials.dtor_algorithmSuite(), encryptionMaterials.dtor_encryptionContext(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.concatenate(encryptionMaterials.dtor_encryptedDataKeys(), encryptedDataKeysToAdd), encryptionMaterials.dtor_requiredEncryptionContextKeys(), Option.create_Some(plaintextDataKey), encryptionMaterials.dtor_signingKey(), _411_symmetricSigningKeys));
    }

    public static boolean DecryptionMaterialsTransitionIsValid(DecryptionMaterials oldMat, DecryptionMaterials newMat) {
        return Objects.equals(newMat.dtor_algorithmSuite(), oldMat.dtor_algorithmSuite()) && newMat.dtor_encryptionContext().equals(oldMat.dtor_encryptionContext()) && newMat.dtor_requiredEncryptionContextKeys().equals(oldMat.dtor_requiredEncryptionContextKeys()) && Objects.equals(newMat.dtor_verificationKey(), oldMat.dtor_verificationKey()) && oldMat.dtor_plaintextDataKey().is_None() && newMat.dtor_plaintextDataKey().is_Some() && oldMat.dtor_symmetricSigningKey().is_None() && __default.ValidDecryptionMaterials(oldMat) && __default.ValidDecryptionMaterials(newMat);
    }

    public static boolean ValidDecryptionMaterials(DecryptionMaterials decryptionMaterials) {
        DecryptionMaterials _pat_let_tv17 = decryptionMaterials;
        DecryptionMaterials _pat_let_tv18 = decryptionMaterials;
        DecryptionMaterials _pat_let_tv19 = decryptionMaterials;
        DecryptionMaterials _pat_let_tv20 = decryptionMaterials;
        DecryptionMaterials _pat_let_tv21 = decryptionMaterials;
        DecryptionMaterials _pat_let_tv22 = decryptionMaterials;
        DecryptionMaterials _pat_let_tv23 = decryptionMaterials;
        DecryptionMaterials _pat_let_tv24 = decryptionMaterials;
        DecryptionMaterials _pat_let_tv25 = decryptionMaterials;
        return AlgorithmSuites_Compile.__default.AlgorithmSuite_q(decryptionMaterials.dtor_algorithmSuite()) && (Boolean)Helpers.Let((Object)decryptionMaterials.dtor_algorithmSuite(), boxed14 -> {
            AlgorithmSuiteInfo _pat_let7_0 = boxed14;
            return (boolean)((Boolean)Helpers.Let((Object)_pat_let7_0, boxed15 -> {
                AlgorithmSuiteInfo _412_suite = boxed15;
                return !(_pat_let_tv17.dtor_plaintextDataKey().is_Some() && !Objects.equals(BigInteger.valueOf(AlgorithmSuites_Compile.__default.GetEncryptKeyLength(_412_suite)), BigInteger.valueOf(_pat_let_tv18.dtor_plaintextDataKey().dtor_value().length())) || !_412_suite.dtor_signature().is_None() != _pat_let_tv19.dtor_encryptionContext().contains(__default.EC__PUBLIC__KEY__FIELD()) || _412_suite.dtor_signature().is_ECDSA() != _pat_let_tv20.dtor_verificationKey().is_Some() || !_412_suite.dtor_signature().is_None() != _pat_let_tv21.dtor_encryptionContext().contains(__default.EC__PUBLIC__KEY__FIELD()) || !_412_suite.dtor_symmetricSignature().is_None() && _pat_let_tv22.dtor_plaintextDataKey().is_Some() != _pat_let_tv23.dtor_symmetricSigningKey().is_Some() || _412_suite.dtor_symmetricSignature().is_None() && !_pat_let_tv24.dtor_symmetricSigningKey().is_None() || ((Function<DecryptionMaterials, Boolean>)_413_decryptionMaterials -> Helpers.Quantifier((Iterable)_413_decryptionMaterials.dtor_requiredEncryptionContextKeys().UniqueElements(), (boolean)true, _forall_var_11_boxed0 -> {
                    DafnySequence _forall_var_11;
                    DafnySequence _414_k = _forall_var_11 = _forall_var_11_boxed0;
                    return !_413_decryptionMaterials.dtor_requiredEncryptionContextKeys().contains((Object)_414_k) || _413_decryptionMaterials.dtor_encryptionContext().contains((Object)_414_k);
                })).apply(_pat_let_tv25) == false);
            }));
        }) != false;
    }

    public static Result<DecryptionMaterials, Error> DecryptionMaterialsAddDataKey(DecryptionMaterials decryptionMaterials, DafnySequence<? extends Byte> plaintextDataKey, Option<DafnySequence<? extends Byte>> symmetricSigningKey) {
        AlgorithmSuiteInfo _415_suite = decryptionMaterials.dtor_algorithmSuite();
        Outcome<Error> _416_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), __default.ValidDecryptionMaterials(decryptionMaterials), Error.create_InvalidDecryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Attempt to modify invalid decryption material.")));
        if (_416_valueOrError0.IsFailure(Error._typeDescriptor())) {
            return _416_valueOrError0.PropagateFailure(Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _417_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), decryptionMaterials.dtor_plaintextDataKey().is_None(), Error.create_InvalidDecryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Attempt to modify plaintextDataKey.")));
        if (_417_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _417_valueOrError1.PropagateFailure(Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _418_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Objects.equals(BigInteger.valueOf(AlgorithmSuites_Compile.__default.GetEncryptKeyLength(_415_suite)), BigInteger.valueOf(plaintextDataKey.length())), Error.create_InvalidDecryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"plaintextDataKey does not match Algorithm Suite specification.")));
        if (_418_valueOrError2.IsFailure(Error._typeDescriptor())) {
            return _418_valueOrError2.PropagateFailure(Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _419_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), symmetricSigningKey.is_Some() == !decryptionMaterials.dtor_algorithmSuite().dtor_symmetricSignature().is_None(), Error.create_InvalidDecryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"symmetric signature key must be added with plaintextDataKey if using an algorithm suite with symmetric signing.")));
        if (_419_valueOrError3.IsFailure(Error._typeDescriptor())) {
            return _419_valueOrError3.PropagateFailure(Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _420_valueOrError4 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), symmetricSigningKey.is_None() == decryptionMaterials.dtor_algorithmSuite().dtor_symmetricSignature().is_None(), Error.create_InvalidDecryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"symmetric signature key cannot be added with plaintextDataKey if using an algorithm suite without symmetric signing.")));
        if (_420_valueOrError4.IsFailure(Error._typeDescriptor())) {
            return _420_valueOrError4.PropagateFailure(Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        return Result.create_Success(DecryptionMaterials.create(decryptionMaterials.dtor_algorithmSuite(), decryptionMaterials.dtor_encryptionContext(), decryptionMaterials.dtor_requiredEncryptionContextKeys(), Option.create_Some(plaintextDataKey), decryptionMaterials.dtor_verificationKey(), symmetricSigningKey));
    }

    public static boolean DecryptionMaterialsWithoutPlaintextDataKey(DecryptionMaterials decryptionMaterials) {
        return decryptionMaterials.dtor_plaintextDataKey().is_None() && __default.ValidDecryptionMaterials(decryptionMaterials);
    }

    public static boolean DecryptionMaterialsWithPlaintextDataKey(DecryptionMaterials decryptionMaterials) {
        return decryptionMaterials.dtor_plaintextDataKey().is_Some() && __default.ValidDecryptionMaterials(decryptionMaterials);
    }

    public static DafnySequence<? extends Byte> EC__PUBLIC__KEY__FIELD() {
        DafnySequence _421_s = DafnySequence.of((byte[])new byte[]{97, 119, 115, 45, 99, 114, 121, 112, 116, 111, 45, 112, 117, 98, 108, 105, 99, 45, 107, 101, 121});
        return _421_s;
    }

    public static DafnySet<? extends DafnySequence<? extends Byte>> RESERVED__KEY__VALUES() {
        return DafnySet.of((Object[])new DafnySequence[]{__default.EC__PUBLIC__KEY__FIELD()});
    }

    public String toString() {
        return "Materials._default";
    }
}

