/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsUtils_Compile;

import AwsArnParsing_Compile.AwsKmsIdentifier;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Function0;
import dafny.Helpers;
import dafny.Tuple0;
import dafny.Tuple2;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.cryptography.materialproviders.internaldafny.types.DiscoveryFilter;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;

public class __default {
    public static Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Character>>, Error> StringifyEncryptionContext(DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> utf8EncCtx) {
        if (BigInteger.valueOf(utf8EncCtx.size()).signum() == 0) {
            return Result.create_Success(DafnyMap.fromElements((Tuple2[])new Tuple2[0]));
        }
        DafnyMap _64_stringifyResults = ((Function<DafnyMap, DafnyMap>)_65_utf8EncCtx -> ((Function0<DafnyMap>)() -> {
            HashMap<DafnySequence, Result<Tuple2<DafnySequence<? extends Character>, DafnySequence<? extends Character>>, Error>> _coll0 = new HashMap<DafnySequence, Result<Tuple2<DafnySequence<? extends Character>, DafnySequence<? extends Character>>, Error>>();
            Iterator iterator = _65_utf8EncCtx.keySet().Elements().iterator();
            while (iterator.hasNext()) {
                DafnySequence _compr_0_boxed0;
                DafnySequence _compr_0;
                DafnySequence _66_utf8Key = _compr_0 = (_compr_0_boxed0 = (DafnySequence)iterator.next());
                if (!_65_utf8EncCtx.keySet().contains((Object)_66_utf8Key)) continue;
                _coll0.put(_66_utf8Key, __default.StringifyEncryptionContextPair((DafnySequence<? extends Byte>)_66_utf8Key, (DafnySequence<? extends Byte>)((DafnySequence)_65_utf8EncCtx.get((Object)_66_utf8Key))));
            }
            return new DafnyMap(_coll0);
        }).apply()).apply(utf8EncCtx);
        if (((Function<DafnyMap, Boolean>)_67_stringifyResults -> Helpers.Quantifier((Iterable)_67_stringifyResults.valueSet().Elements(), (boolean)false, _exists_var_0_boxed0 -> {
            Result _exists_var_0;
            Result _68_r = _exists_var_0 = _exists_var_0_boxed0;
            return _67_stringifyResults.valueSet().contains((Object)_68_r) && _68_r.is_Failure();
        })).apply(_64_stringifyResults).booleanValue()) {
            return Result.create_Failure(Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Encryption context contains invalid UTF8")));
        }
        boolean _69_stringKeysUnique = ((Function<DafnyMap, Boolean>)_70_stringifyResults -> Helpers.Quantifier((Iterable)_70_stringifyResults.keySet().Elements(), (boolean)true, _forall_var_0_boxed0 -> {
            DafnySequence _forall_var_0;
            DafnySequence _71_k = _forall_var_0 = _forall_var_0_boxed0;
            return Helpers.Quantifier((Iterable)_70_stringifyResults.keySet().Elements(), (boolean)true, _forall_var_1_boxed0 -> {
                DafnySequence _forall_var_1;
                DafnySequence _72_k_k = _forall_var_1 = _forall_var_1_boxed0;
                return !_70_stringifyResults.contains((Object)_71_k) || !_70_stringifyResults.contains((Object)_72_k_k) || _71_k.equals((Object)_72_k_k) || !((DafnySequence)((Tuple2)((Result)_70_stringifyResults.get((Object)_71_k)).dtor_value()).dtor__0()).equals(((Tuple2)((Result)_70_stringifyResults.get((Object)_72_k_k)).dtor_value()).dtor__0());
            });
        })).apply(_64_stringifyResults);
        if (!_69_stringKeysUnique) {
            return Result.create_Failure(Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Encryption context keys are not unique")));
        }
        return Result.create_Success(((Function<DafnyMap, DafnyMap>)_73_stringifyResults -> ((Function0<DafnyMap>)() -> {
            HashMap<Object, Object> _coll1 = new HashMap<Object, Object>();
            Iterator iterator = _73_stringifyResults.valueSet().Elements().iterator();
            while (iterator.hasNext()) {
                Result _compr_1_boxed0;
                Result _compr_1;
                Result _74_r = _compr_1 = (_compr_1_boxed0 = (Result)iterator.next());
                if (!_73_stringifyResults.valueSet().contains((Object)_74_r)) continue;
                _coll1.put(((Tuple2)_74_r.dtor_value()).dtor__0(), ((Tuple2)_74_r.dtor_value()).dtor__1());
            }
            return new DafnyMap(_coll1);
        }).apply()).apply(_64_stringifyResults));
    }

    public static Result<Tuple2<DafnySequence<? extends Character>, DafnySequence<? extends Character>>, Error> StringifyEncryptionContextPair(DafnySequence<? extends Byte> utf8Key, DafnySequence<? extends Byte> utf8Value) {
        Result<DafnySequence<? extends Character>, Error> _75_valueOrError0 = UTF8.__default.Decode(utf8Key).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), __default::WrapStringToError);
        if (_75_valueOrError0.IsFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
            return _75_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        }
        DafnySequence<? extends Character> _76_key = _75_valueOrError0.Extract((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
        Result<DafnySequence<? extends Character>, Error> _77_valueOrError1 = UTF8.__default.Decode(utf8Value).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), __default::WrapStringToError);
        if (_77_valueOrError1.IsFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
            return _77_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        }
        DafnySequence<? extends Character> _78_value = _77_valueOrError1.Extract((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
        return Result.create_Success(Tuple2.create(_76_key, _78_value));
    }

    public static Error WrapStringToError(DafnySequence<? extends Character> e) {
        return Error.create_AwsCryptographicMaterialProvidersException(e);
    }

    public static Result<Tuple0, Error> ValidateKmsKeyId(DafnySequence<? extends Character> keyId) {
        Result<AwsKmsIdentifier, Error> _79_valueOrError0 = AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(keyId).MapFailure(AwsKmsIdentifier._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), __default::WrapStringToError);
        if (_79_valueOrError0.IsFailure(AwsKmsIdentifier._typeDescriptor(), Error._typeDescriptor())) {
            return _79_valueOrError0.PropagateFailure(AwsKmsIdentifier._typeDescriptor(), Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        AwsKmsIdentifier _80___v0 = _79_valueOrError0.Extract(AwsKmsIdentifier._typeDescriptor(), Error._typeDescriptor());
        Outcome<Error> _81_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), UTF8.__default.IsASCIIString(keyId), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Key identifier is not ASCII")));
        if (_81_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _81_valueOrError1.PropagateFailure(Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        Outcome<Error> _82_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(keyId.length()).signum() == 1 && BigInteger.valueOf(keyId.length()).compareTo(AwsArnParsing_Compile.__default.MAX__AWS__KMS__IDENTIFIER__LENGTH()) <= 0, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Key identifier is too long")));
        if (_82_valueOrError2.IsFailure(Error._typeDescriptor())) {
            return _82_valueOrError2.PropagateFailure(Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        return Result.create_Success(Tuple0.create());
    }

    public static Result<DafnySequence<? extends DafnySequence<? extends Character>>, Error> GetValidGrantTokens(Option<DafnySequence<? extends DafnySequence<? extends Character>>> grantTokens) {
        DafnySequence<? extends DafnySequence<? extends Character>> _83_tokens = grantTokens.UnwrapOr((TypeDescriptor<DafnySequence<? extends DafnySequence<? extends Character>>>)DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), (DafnySequence<? extends DafnySequence<? extends Character>>)DafnySequence.empty((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        Outcome<Error> _84_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_83_tokens.length()).signum() != -1 && BigInteger.valueOf(_83_tokens.length()).compareTo(BigInteger.valueOf(10L)) <= 0, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Grant token list can have no more than 10 tokens")));
        if (_84_valueOrError0.IsFailure(Error._typeDescriptor())) {
            return _84_valueOrError0.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        }
        Outcome<Error> _85_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), ((Function<DafnySequence, Boolean>)_86_tokens -> Helpers.Quantifier((Iterable)_86_tokens.UniqueElements(), (boolean)true, _forall_var_2_boxed0 -> {
            DafnySequence _forall_var_2 = _forall_var_2_boxed0;
            DafnySequence _87_token = _forall_var_2;
            return !_86_tokens.contains((Object)_87_token) || BigInteger.ONE.compareTo(BigInteger.valueOf(_87_token.length())) <= 0 && BigInteger.valueOf(_87_token.length()).compareTo(BigInteger.valueOf(8192L)) <= 0;
        })).apply(_83_tokens), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Grant token list contains a grant token with invalid length")));
        if (_85_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _85_valueOrError1.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        }
        return Result.create_Success(_83_tokens);
    }

    public static Result<Tuple2<DafnySequence<? extends Byte>, DafnySequence<? extends Byte>>, Error> ParseKeyNamespaceAndName(DafnySequence<? extends Character> keyNamespace, DafnySequence<? extends Character> keyName) {
        Result<DafnySequence<? extends Byte>, Error> _88_valueOrError0 = UTF8.__default.Encode(keyNamespace).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _89_e_boxed0 -> {
            DafnySequence _89_e = _89_e_boxed0;
            return Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Key namespace could not be UTF8-encoded"), (DafnySequence)_89_e));
        });
        if (_88_valueOrError0.IsFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor())) {
            return _88_valueOrError0.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor(), Tuple2._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()));
        }
        DafnySequence<? extends Byte> _90_namespace = _88_valueOrError0.Extract(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor());
        Outcome<Error> _91_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_90_namespace.length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Key namespace too long")));
        if (_91_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _91_valueOrError1.PropagateFailure(Error._typeDescriptor(), Tuple2._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()));
        }
        Result<DafnySequence<? extends Byte>, Error> _92_valueOrError2 = UTF8.__default.Encode(keyName).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _93_e_boxed0 -> {
            DafnySequence _93_e = _93_e_boxed0;
            return Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Key name could not be UTF8-encoded"), (DafnySequence)_93_e));
        });
        if (_92_valueOrError2.IsFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor())) {
            return _92_valueOrError2.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor(), Tuple2._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()));
        }
        DafnySequence<? extends Byte> _94_name = _92_valueOrError2.Extract(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor());
        Outcome<Error> _95_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_94_name.length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Key name too long")));
        if (_95_valueOrError3.IsFailure(Error._typeDescriptor())) {
            return _95_valueOrError3.PropagateFailure(Error._typeDescriptor(), Tuple2._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()));
        }
        return Result.create_Success(Tuple2.create(_90_namespace, _94_name));
    }

    public static Result<Tuple0, Error> ValidateDiscoveryFilter(DiscoveryFilter filter) {
        Outcome<Error> _96_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(filter.dtor_accountIds().length()).signum() == 1, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Discovery filter must have at least one account ID")));
        if (_96_valueOrError0.IsFailure(Error._typeDescriptor())) {
            return _96_valueOrError0.PropagateFailure(Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        Outcome<Error> _97_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), ((Function<DiscoveryFilter, Boolean>)_98_filter -> Helpers.Quantifier((Iterable)_98_filter.dtor_accountIds().UniqueElements(), (boolean)true, _forall_var_3_boxed0 -> {
            DafnySequence _forall_var_3;
            DafnySequence _99_accountId = _forall_var_3 = _forall_var_3_boxed0;
            return !_98_filter.dtor_accountIds().contains((Object)_99_accountId) || BigInteger.valueOf(_99_accountId.length()).signum() == 1;
        })).apply(filter), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Discovery filter account IDs cannot be blank")));
        if (_97_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _97_valueOrError1.PropagateFailure(Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        Outcome<Error> _100_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(filter.dtor_partition().length()).signum() == 1, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Discovery filter partition cannot be blank")));
        if (_100_valueOrError2.IsFailure(Error._typeDescriptor())) {
            return _100_valueOrError2.PropagateFailure(Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        return Result.create_Success(Tuple0.create());
    }

    public String toString() {
        return "AwsKmsUtils._default";
    }
}

