/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsMrkDiscoveryKeyring_Compile;

import Actions_Compile.__default;
import AwsKmsMrkDiscoveryKeyring_Compile.AwsKmsEncryptedDataKeyDecryptor;
import AwsKmsMrkDiscoveryKeyring_Compile.AwsKmsEncryptedDataKeyFilterTransform;
import Constants_Compile.AwsKmsEdkHelper;
import Keyring_Compile.VerifiableInterface;
import Materials_Compile.SealedDecryptionMaterials;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.Result_Failure;
import Wrappers_Compile.Result_Success;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.function.Function;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.DiscoveryFilter;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class AwsKmsMrkDiscoveryKeyring
implements VerifiableInterface,
IKeyring {
    public IKMSClient _client = null;
    public DafnySequence<? extends Character> _region = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public Option<DiscoveryFilter> _discoveryFilter = Option.Default();
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    private static final TypeDescriptor<AwsKmsMrkDiscoveryKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsMrkDiscoveryKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out101 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out101;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out102 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out102;
    }

    public void __ctor(IKMSClient client, DafnySequence<? extends Character> region, Option<DiscoveryFilter> discoveryFilter, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        this._client = client;
        this._region = region;
        this._discoveryFilter = discoveryFilter;
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> output = null;
        output = Result.create_Failure(Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Encryption is not supported with a Discovery Keyring.")));
        return output;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<Error>> _out104;
        Result<OnDecryptOutput, Error> output = null;
        DecryptionMaterials _747_materials = input.dtor_materials();
        DafnySequence<? extends EncryptedDataKey> _748_encryptedDataKeys = input.dtor_encryptedDataKeys();
        AlgorithmSuiteInfo _749_suite = input.dtor_materials().dtor_algorithmSuite();
        Outcome<Object> _750_valueOrError0 = Outcome.Default();
        _750_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_747_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_750_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _750_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        AwsKmsEncryptedDataKeyFilterTransform _nw15 = new AwsKmsEncryptedDataKeyFilterTransform();
        _nw15.__ctor(this.region(), this.discoveryFilter());
        AwsKmsEncryptedDataKeyFilterTransform _751_edkFilterTransform = _nw15;
        Result<Object, Object> _753_valueOrError1 = Result.Default(DafnySequence.empty(AwsKmsEdkHelper._typeDescriptor()));
        Result<DafnySequence<? extends AwsKmsEdkHelper>, Error> _out103 = __default.DeterministicFlatMapWithResult(EncryptedDataKey._typeDescriptor(), AwsKmsEdkHelper._typeDescriptor(), Error._typeDescriptor(), _751_edkFilterTransform, _748_encryptedDataKeys);
        _753_valueOrError1 = _out103;
        if (_753_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()), Error._typeDescriptor())) {
            output = _753_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        DafnySequence _752_edksToAttempt = (DafnySequence)_753_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()), Error._typeDescriptor());
        if (BigInteger.valueOf(_752_edksToAttempt.length()).signum() == 0) {
            Result<Object, Object> _755_valueOrError2 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _755_valueOrError2 = ErrorMessages_Compile.__default.IncorrectDataKeys(input.dtor_encryptedDataKeys(), input.dtor_materials().dtor_algorithmSuite(), (DafnySequence<? extends Character>)DafnySequence.asString((String)""));
            if (_755_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                output = _755_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                return output;
            }
            DafnySequence _754_errorMessage = (DafnySequence)_755_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
            output = Result.create_Failure(Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_754_errorMessage));
            return output;
        }
        AwsKmsEncryptedDataKeyDecryptor _nw16 = new AwsKmsEncryptedDataKeyDecryptor();
        _nw16.__ctor(_747_materials, this.client(), this.region(), this.grantTokens());
        AwsKmsEncryptedDataKeyDecryptor _756_decryptAction = _nw16;
        Result<DecryptionMaterials, DafnySequence<Error>> _757_outcome = _out104 = __default.ReduceToSuccess(AwsKmsEdkHelper._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _756_decryptAction, _752_edksToAttempt);
        output = ((Function<Result, Result>)_source28_boxed0 -> {
            Result _source28 = _source28_boxed0;
            if (_source28.is_Success()) {
                DecryptionMaterials _758___mcc_h0 = (DecryptionMaterials)((Result_Success)_source28)._value;
                return (Result)Helpers.Let((Object)_758___mcc_h0, boxed34 -> {
                    DecryptionMaterials _pat_let17_0 = boxed34;
                    return (Result)Helpers.Let((Object)_pat_let17_0, boxed35 -> {
                        DecryptionMaterials _759_mat = boxed35;
                        return Result.create_Success(OnDecryptOutput.create(_759_mat));
                    });
                });
            }
            DafnySequence _760___mcc_h1 = (DafnySequence)((Result_Failure)_source28)._error;
            return (Result)Helpers.Let((Object)_760___mcc_h1, boxed36 -> {
                DafnySequence _pat_let18_0 = boxed36;
                return (Result)Helpers.Let((Object)_pat_let18_0, boxed37 -> {
                    DafnySequence _761_errors = boxed37;
                    return Result.create_Failure(Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_761_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured KMS Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`.")));
                });
            });
        }).apply(_757_outcome);
        return output;
    }

    public IKMSClient client() {
        return this._client;
    }

    public DafnySequence<? extends Character> region() {
        return this._region;
    }

    public Option<DiscoveryFilter> discoveryFilter() {
        return this._discoveryFilter;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public static TypeDescriptor<AwsKmsMrkDiscoveryKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsMrkDiscoveryKeyring.AwsKmsMrkDiscoveryKeyring";
    }
}

