/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsDiscoveryKeyring_Compile;

import Actions_Compile.__default;
import AwsKmsDiscoveryKeyring_Compile.AwsKmsEncryptedDataKeyDecryptor;
import AwsKmsDiscoveryKeyring_Compile.AwsKmsEncryptedDataKeyFilter;
import AwsKmsDiscoveryKeyring_Compile.AwsKmsEncryptedDataKeyTransformer;
import Constants_Compile.AwsKmsEdkHelper;
import Keyring_Compile.VerifiableInterface;
import Materials_Compile.SealedDecryptionMaterials;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.Result_Failure;
import Wrappers_Compile.Result_Success;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.function.Function;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.DiscoveryFilter;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class AwsKmsDiscoveryKeyring
implements VerifiableInterface,
IKeyring {
    public IKMSClient _client = null;
    public Option<DiscoveryFilter> _discoveryFilter = Option.Default();
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    private static final TypeDescriptor<AwsKmsDiscoveryKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsDiscoveryKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out94 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out94;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out95 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out95;
    }

    public void __ctor(IKMSClient client, Option<DiscoveryFilter> discoveryFilter, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        this._client = client;
        this._discoveryFilter = discoveryFilter;
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> output = null;
        output = Result.create_Failure(Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Encryption is not supported with a Discovery Keyring.")));
        return output;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<Error>> _out98;
        Result<OnDecryptOutput, Error> res = null;
        DecryptionMaterials _697_materials = input.dtor_materials();
        DafnySequence<? extends EncryptedDataKey> _698_encryptedDataKeys = input.dtor_encryptedDataKeys();
        AlgorithmSuiteInfo _699_suite = input.dtor_materials().dtor_algorithmSuite();
        Outcome<Object> _700_valueOrError0 = Outcome.Default();
        _700_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_697_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_700_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _700_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        AwsKmsEncryptedDataKeyFilter _nw9 = new AwsKmsEncryptedDataKeyFilter();
        _nw9.__ctor(this.discoveryFilter());
        AwsKmsEncryptedDataKeyFilter _701_edkFilter = _nw9;
        Result<Object, Object> _703_valueOrError1 = Result.Default(DafnySequence.empty(EncryptedDataKey._typeDescriptor()));
        Result<DafnySequence<? extends EncryptedDataKey>, Error> _out96 = __default.FilterWithResult(EncryptedDataKey._typeDescriptor(), Error._typeDescriptor(), _701_edkFilter, _698_encryptedDataKeys);
        _703_valueOrError1 = _out96;
        if (_703_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor())) {
            res = _703_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _702_matchingEdks = (DafnySequence)_703_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor());
        AwsKmsEncryptedDataKeyTransformer _nw10 = new AwsKmsEncryptedDataKeyTransformer();
        _nw10.__ctor();
        AwsKmsEncryptedDataKeyTransformer _704_edkTransform = _nw10;
        Result<Object, Object> _706_valueOrError2 = Result.Default(DafnySequence.empty(AwsKmsEdkHelper._typeDescriptor()));
        Result<DafnySequence<? extends AwsKmsEdkHelper>, Error> _out97 = __default.DeterministicFlatMapWithResult(EncryptedDataKey._typeDescriptor(), AwsKmsEdkHelper._typeDescriptor(), Error._typeDescriptor(), _704_edkTransform, _702_matchingEdks);
        _706_valueOrError2 = _out97;
        if (_706_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()), Error._typeDescriptor())) {
            res = _706_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _705_edksToAttempt = (DafnySequence)_706_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()), Error._typeDescriptor());
        if (BigInteger.valueOf(_705_edksToAttempt.length()).signum() == 0) {
            Result<Object, Object> _708_valueOrError3 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _708_valueOrError3 = ErrorMessages_Compile.__default.IncorrectDataKeys(input.dtor_encryptedDataKeys(), input.dtor_materials().dtor_algorithmSuite(), (DafnySequence<? extends Character>)DafnySequence.asString((String)""));
            if (_708_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                res = _708_valueOrError3.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                return res;
            }
            DafnySequence _707_errorMessage = (DafnySequence)_708_valueOrError3.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
            res = Result.create_Failure(Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_707_errorMessage));
            return res;
        }
        AwsKmsEncryptedDataKeyDecryptor _nw11 = new AwsKmsEncryptedDataKeyDecryptor();
        _nw11.__ctor(_697_materials, this.client(), this.grantTokens());
        AwsKmsEncryptedDataKeyDecryptor _709_decryptAction = _nw11;
        Result<DecryptionMaterials, DafnySequence<Error>> _710_outcome = _out98 = __default.ReduceToSuccess(AwsKmsEdkHelper._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _709_decryptAction, _705_edksToAttempt);
        res = ((Function<Result, Result>)_source26_boxed0 -> {
            Result _source26 = _source26_boxed0;
            if (_source26.is_Success()) {
                DecryptionMaterials _711___mcc_h0 = (DecryptionMaterials)((Result_Success)_source26)._value;
                return (Result)Helpers.Let((Object)_711___mcc_h0, boxed28 -> {
                    DecryptionMaterials _pat_let14_0 = boxed28;
                    return (Result)Helpers.Let((Object)_pat_let14_0, boxed29 -> {
                        DecryptionMaterials _712_mat = boxed29;
                        return Result.create_Success(OnDecryptOutput.create(_712_mat));
                    });
                });
            }
            DafnySequence _713___mcc_h1 = (DafnySequence)((Result_Failure)_source26)._error;
            return (Result)Helpers.Let((Object)_713___mcc_h1, boxed30 -> {
                DafnySequence _pat_let15_0 = boxed30;
                return (Result)Helpers.Let((Object)_pat_let15_0, boxed31 -> {
                    DafnySequence _714_errors = boxed31;
                    return Result.create_Failure(Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_714_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured KMS Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`.")));
                });
            });
        }).apply(_710_outcome);
        return res;
    }

    public IKMSClient client() {
        return this._client;
    }

    public Option<DiscoveryFilter> discoveryFilter() {
        return this._discoveryFilter;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public static TypeDescriptor<AwsKmsDiscoveryKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsDiscoveryKeyring.AwsKmsDiscoveryKeyring";
    }
}

