/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.internaldafny.types;

import Wrappers_Compile.Option;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;

public class StormTrackingCache {
    public int _entryCapacity;
    public Option<Integer> _entryPruningTailSize;
    public int _gracePeriod;
    public int _graceInterval;
    public int _fanOut;
    public int _inFlightTTL;
    public int _sleepMilli;
    private static final StormTrackingCache theDefault = StormTrackingCache.create(0, Option.Default(), 0, 0, 0, 0, 0);
    private static final TypeDescriptor<StormTrackingCache> _TYPE = TypeDescriptor.referenceWithInitializer(StormTrackingCache.class, () -> StormTrackingCache.Default());

    public StormTrackingCache(int entryCapacity, Option<Integer> entryPruningTailSize, int gracePeriod, int graceInterval, int fanOut, int inFlightTTL, int sleepMilli) {
        this._entryCapacity = entryCapacity;
        this._entryPruningTailSize = entryPruningTailSize;
        this._gracePeriod = gracePeriod;
        this._graceInterval = graceInterval;
        this._fanOut = fanOut;
        this._inFlightTTL = inFlightTTL;
        this._sleepMilli = sleepMilli;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        StormTrackingCache o = (StormTrackingCache)other;
        return this._entryCapacity == o._entryCapacity && Objects.equals(this._entryPruningTailSize, o._entryPruningTailSize) && this._gracePeriod == o._gracePeriod && this._graceInterval == o._graceInterval && this._fanOut == o._fanOut && this._inFlightTTL == o._inFlightTTL && this._sleepMilli == o._sleepMilli;
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Integer.hashCode(this._entryCapacity);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._entryPruningTailSize);
        hash = (hash << 5) + hash + (long)Integer.hashCode(this._gracePeriod);
        hash = (hash << 5) + hash + (long)Integer.hashCode(this._graceInterval);
        hash = (hash << 5) + hash + (long)Integer.hashCode(this._fanOut);
        hash = (hash << 5) + hash + (long)Integer.hashCode(this._inFlightTTL);
        hash = (hash << 5) + hash + (long)Integer.hashCode(this._sleepMilli);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("AwsCryptographyMaterialProvidersTypes.StormTrackingCache.StormTrackingCache");
        s.append("(");
        s.append(this._entryCapacity);
        s.append(", ");
        s.append(Helpers.toString(this._entryPruningTailSize));
        s.append(", ");
        s.append(this._gracePeriod);
        s.append(", ");
        s.append(this._graceInterval);
        s.append(", ");
        s.append(this._fanOut);
        s.append(", ");
        s.append(this._inFlightTTL);
        s.append(", ");
        s.append(this._sleepMilli);
        s.append(")");
        return s.toString();
    }

    public static StormTrackingCache Default() {
        return theDefault;
    }

    public static TypeDescriptor<StormTrackingCache> _typeDescriptor() {
        return _TYPE;
    }

    public static StormTrackingCache create(int entryCapacity, Option<Integer> entryPruningTailSize, int gracePeriod, int graceInterval, int fanOut, int inFlightTTL, int sleepMilli) {
        return new StormTrackingCache(entryCapacity, entryPruningTailSize, gracePeriod, graceInterval, fanOut, inFlightTTL, sleepMilli);
    }

    public static StormTrackingCache create_StormTrackingCache(int entryCapacity, Option<Integer> entryPruningTailSize, int gracePeriod, int graceInterval, int fanOut, int inFlightTTL, int sleepMilli) {
        return StormTrackingCache.create(entryCapacity, entryPruningTailSize, gracePeriod, graceInterval, fanOut, inFlightTTL, sleepMilli);
    }

    public boolean is_StormTrackingCache() {
        return true;
    }

    public int dtor_entryCapacity() {
        return this._entryCapacity;
    }

    public Option<Integer> dtor_entryPruningTailSize() {
        return this._entryPruningTailSize;
    }

    public int dtor_gracePeriod() {
        return this._gracePeriod;
    }

    public int dtor_graceInterval() {
        return this._graceInterval;
    }

    public int dtor_fanOut() {
        return this._fanOut;
    }

    public int dtor_inFlightTTL() {
        return this._inFlightTTL;
    }

    public int dtor_sleepMilli() {
        return this._sleepMilli;
    }
}

