/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.internaldafny.types;

import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;

public class HKDF {
    public DigestAlgorithm _hmac;
    public int _saltLength;
    public int _inputKeyLength;
    public int _outputKeyLength;
    private static final HKDF theDefault = HKDF.create(DigestAlgorithm.Default(), 0, 0, 0);
    private static final TypeDescriptor<HKDF> _TYPE = TypeDescriptor.referenceWithInitializer(HKDF.class, () -> HKDF.Default());

    public HKDF(DigestAlgorithm hmac, int saltLength, int inputKeyLength, int outputKeyLength) {
        this._hmac = hmac;
        this._saltLength = saltLength;
        this._inputKeyLength = inputKeyLength;
        this._outputKeyLength = outputKeyLength;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        HKDF o = (HKDF)other;
        return Objects.equals(this._hmac, o._hmac) && this._saltLength == o._saltLength && this._inputKeyLength == o._inputKeyLength && this._outputKeyLength == o._outputKeyLength;
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._hmac);
        hash = (hash << 5) + hash + (long)Integer.hashCode(this._saltLength);
        hash = (hash << 5) + hash + (long)Integer.hashCode(this._inputKeyLength);
        hash = (hash << 5) + hash + (long)Integer.hashCode(this._outputKeyLength);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("AwsCryptographyMaterialProvidersTypes.HKDF.HKDF");
        s.append("(");
        s.append(Helpers.toString((Object)this._hmac));
        s.append(", ");
        s.append(this._saltLength);
        s.append(", ");
        s.append(this._inputKeyLength);
        s.append(", ");
        s.append(this._outputKeyLength);
        s.append(")");
        return s.toString();
    }

    public static HKDF Default() {
        return theDefault;
    }

    public static TypeDescriptor<HKDF> _typeDescriptor() {
        return _TYPE;
    }

    public static HKDF create(DigestAlgorithm hmac, int saltLength, int inputKeyLength, int outputKeyLength) {
        return new HKDF(hmac, saltLength, inputKeyLength, outputKeyLength);
    }

    public static HKDF create_HKDF(DigestAlgorithm hmac, int saltLength, int inputKeyLength, int outputKeyLength) {
        return HKDF.create(hmac, saltLength, inputKeyLength, outputKeyLength);
    }

    public boolean is_HKDF() {
        return true;
    }

    public DigestAlgorithm dtor_hmac() {
        return this._hmac;
    }

    public int dtor_saltLength() {
        return this._saltLength;
    }

    public int dtor_inputKeyLength() {
        return this._inputKeyLength;
    }

    public int dtor_outputKeyLength() {
        return this._outputKeyLength;
    }
}

