/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.internaldafny.types;

import Wrappers_Compile.Option;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.services.kms.internaldafny.types.EncryptionAlgorithmSpec;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class CreateAwsKmsRsaKeyringInput {
    public Option<DafnySequence<? extends Byte>> _publicKey;
    public DafnySequence<? extends Character> _kmsKeyId;
    public EncryptionAlgorithmSpec _encryptionAlgorithm;
    public Option<IKMSClient> _kmsClient;
    public Option<DafnySequence<? extends DafnySequence<? extends Character>>> _grantTokens;
    private static final CreateAwsKmsRsaKeyringInput theDefault = CreateAwsKmsRsaKeyringInput.create(Option.Default(), (DafnySequence<? extends Character>)DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR), EncryptionAlgorithmSpec.Default(), Option.Default(), Option.Default());
    private static final TypeDescriptor<CreateAwsKmsRsaKeyringInput> _TYPE = TypeDescriptor.referenceWithInitializer(CreateAwsKmsRsaKeyringInput.class, () -> CreateAwsKmsRsaKeyringInput.Default());

    public CreateAwsKmsRsaKeyringInput(Option<DafnySequence<? extends Byte>> publicKey, DafnySequence<? extends Character> kmsKeyId, EncryptionAlgorithmSpec encryptionAlgorithm, Option<IKMSClient> kmsClient, Option<DafnySequence<? extends DafnySequence<? extends Character>>> grantTokens) {
        this._publicKey = publicKey;
        this._kmsKeyId = kmsKeyId;
        this._encryptionAlgorithm = encryptionAlgorithm;
        this._kmsClient = kmsClient;
        this._grantTokens = grantTokens;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        CreateAwsKmsRsaKeyringInput o = (CreateAwsKmsRsaKeyringInput)other;
        return Objects.equals(this._publicKey, o._publicKey) && Objects.equals(this._kmsKeyId, o._kmsKeyId) && Objects.equals(this._encryptionAlgorithm, o._encryptionAlgorithm) && Objects.equals(this._kmsClient, o._kmsClient) && Objects.equals(this._grantTokens, o._grantTokens);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._publicKey);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._kmsKeyId);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._encryptionAlgorithm);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._kmsClient);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._grantTokens);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("AwsCryptographyMaterialProvidersTypes.CreateAwsKmsRsaKeyringInput.CreateAwsKmsRsaKeyringInput");
        s.append("(");
        s.append(Helpers.toString(this._publicKey));
        s.append(", ");
        s.append(Helpers.toString(this._kmsKeyId));
        s.append(", ");
        s.append(Helpers.toString((Object)this._encryptionAlgorithm));
        s.append(", ");
        s.append(Helpers.toString(this._kmsClient));
        s.append(", ");
        s.append(Helpers.toString(this._grantTokens));
        s.append(")");
        return s.toString();
    }

    public static CreateAwsKmsRsaKeyringInput Default() {
        return theDefault;
    }

    public static TypeDescriptor<CreateAwsKmsRsaKeyringInput> _typeDescriptor() {
        return _TYPE;
    }

    public static CreateAwsKmsRsaKeyringInput create(Option<DafnySequence<? extends Byte>> publicKey, DafnySequence<? extends Character> kmsKeyId, EncryptionAlgorithmSpec encryptionAlgorithm, Option<IKMSClient> kmsClient, Option<DafnySequence<? extends DafnySequence<? extends Character>>> grantTokens) {
        return new CreateAwsKmsRsaKeyringInput(publicKey, kmsKeyId, encryptionAlgorithm, kmsClient, grantTokens);
    }

    public static CreateAwsKmsRsaKeyringInput create_CreateAwsKmsRsaKeyringInput(Option<DafnySequence<? extends Byte>> publicKey, DafnySequence<? extends Character> kmsKeyId, EncryptionAlgorithmSpec encryptionAlgorithm, Option<IKMSClient> kmsClient, Option<DafnySequence<? extends DafnySequence<? extends Character>>> grantTokens) {
        return CreateAwsKmsRsaKeyringInput.create(publicKey, kmsKeyId, encryptionAlgorithm, kmsClient, grantTokens);
    }

    public boolean is_CreateAwsKmsRsaKeyringInput() {
        return true;
    }

    public Option<DafnySequence<? extends Byte>> dtor_publicKey() {
        return this._publicKey;
    }

    public DafnySequence<? extends Character> dtor_kmsKeyId() {
        return this._kmsKeyId;
    }

    public EncryptionAlgorithmSpec dtor_encryptionAlgorithm() {
        return this._encryptionAlgorithm;
    }

    public Option<IKMSClient> dtor_kmsClient() {
        return this._kmsClient;
    }

    public Option<DafnySequence<? extends DafnySequence<? extends Character>>> dtor_grantTokens() {
        return this._grantTokens;
    }
}

