/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders;

import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Tuple0;
import java.nio.ByteBuffer;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.ClientSupplier;
import software.amazon.cryptography.materialproviders.CryptographicMaterialsCache;
import software.amazon.cryptography.materialproviders.CryptographicMaterialsManager;
import software.amazon.cryptography.materialproviders.IClientSupplier;
import software.amazon.cryptography.materialproviders.ICryptographicMaterialsCache;
import software.amazon.cryptography.materialproviders.ICryptographicMaterialsManager;
import software.amazon.cryptography.materialproviders.IKeyring;
import software.amazon.cryptography.materialproviders.Keyring;
import software.amazon.cryptography.materialproviders.ToDafny;
import software.amazon.cryptography.materialproviders.ToNative;
import software.amazon.cryptography.materialproviders.internaldafny.MaterialProvidersClient;
import software.amazon.cryptography.materialproviders.internaldafny.__default;
import software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsDiscoveryKeyringInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsDiscoveryMultiKeyringInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsHierarchicalKeyringInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsKeyringInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsMrkDiscoveryKeyringInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsMrkDiscoveryMultiKeyringInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsMultiKeyringInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.CreateDefaultCryptographicMaterialsManagerInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.CreateMultiKeyringInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.CreateRequiredEncryptionContextCMMInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IAwsCryptographicMaterialProvidersClient;
import software.amazon.cryptography.materialproviders.internaldafny.types.InitializeDecryptionMaterialsInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.MaterialProvidersConfig;
import software.amazon.cryptography.materialproviders.internaldafny.types.ValidateCommitmentPolicyOnEncryptInput;
import software.amazon.cryptography.materialproviders.model.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.model.CreateAwsKmsMrkKeyringInput;
import software.amazon.cryptography.materialproviders.model.CreateAwsKmsMrkMultiKeyringInput;
import software.amazon.cryptography.materialproviders.model.CreateAwsKmsRsaKeyringInput;
import software.amazon.cryptography.materialproviders.model.CreateCryptographicMaterialsCacheInput;
import software.amazon.cryptography.materialproviders.model.CreateDefaultClientSupplierInput;
import software.amazon.cryptography.materialproviders.model.CreateRawAesKeyringInput;
import software.amazon.cryptography.materialproviders.model.CreateRawRsaKeyringInput;
import software.amazon.cryptography.materialproviders.model.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.model.InitializeEncryptionMaterialsInput;
import software.amazon.cryptography.materialproviders.model.ValidDecryptionMaterialsTransitionInput;
import software.amazon.cryptography.materialproviders.model.ValidEncryptionMaterialsTransitionInput;
import software.amazon.cryptography.materialproviders.model.ValidateCommitmentPolicyOnDecryptInput;

public class MaterialProviders {
    private final IAwsCryptographicMaterialProvidersClient _impl;

    protected MaterialProviders(BuilderImpl builder) {
        software.amazon.cryptography.materialproviders.model.MaterialProvidersConfig input = builder.MaterialProvidersConfig();
        MaterialProvidersConfig dafnyValue = ToDafny.MaterialProvidersConfig(input);
        Result<MaterialProvidersClient, Error> result = __default.MaterialProviders(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        this._impl = result.dtor_value();
    }

    MaterialProviders(IAwsCryptographicMaterialProvidersClient impl) {
        this._impl = impl;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public IKeyring CreateAwsKmsDiscoveryKeyring(software.amazon.cryptography.materialproviders.model.CreateAwsKmsDiscoveryKeyringInput input) {
        CreateAwsKmsDiscoveryKeyringInput dafnyValue = ToDafny.CreateAwsKmsDiscoveryKeyringInput(input);
        Result<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring, Error> result = this._impl.CreateAwsKmsDiscoveryKeyring(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return Keyring.wrap(result.dtor_value());
    }

    public IKeyring CreateAwsKmsDiscoveryMultiKeyring(software.amazon.cryptography.materialproviders.model.CreateAwsKmsDiscoveryMultiKeyringInput input) {
        CreateAwsKmsDiscoveryMultiKeyringInput dafnyValue = ToDafny.CreateAwsKmsDiscoveryMultiKeyringInput(input);
        Result<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring, Error> result = this._impl.CreateAwsKmsDiscoveryMultiKeyring(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return Keyring.wrap(result.dtor_value());
    }

    public IKeyring CreateAwsKmsHierarchicalKeyring(software.amazon.cryptography.materialproviders.model.CreateAwsKmsHierarchicalKeyringInput input) {
        CreateAwsKmsHierarchicalKeyringInput dafnyValue = ToDafny.CreateAwsKmsHierarchicalKeyringInput(input);
        Result<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring, Error> result = this._impl.CreateAwsKmsHierarchicalKeyring(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return Keyring.wrap(result.dtor_value());
    }

    public IKeyring CreateAwsKmsKeyring(software.amazon.cryptography.materialproviders.model.CreateAwsKmsKeyringInput input) {
        CreateAwsKmsKeyringInput dafnyValue = ToDafny.CreateAwsKmsKeyringInput(input);
        Result<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring, Error> result = this._impl.CreateAwsKmsKeyring(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return Keyring.wrap(result.dtor_value());
    }

    public IKeyring CreateAwsKmsMrkDiscoveryKeyring(software.amazon.cryptography.materialproviders.model.CreateAwsKmsMrkDiscoveryKeyringInput input) {
        CreateAwsKmsMrkDiscoveryKeyringInput dafnyValue = ToDafny.CreateAwsKmsMrkDiscoveryKeyringInput(input);
        Result<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring, Error> result = this._impl.CreateAwsKmsMrkDiscoveryKeyring(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return Keyring.wrap(result.dtor_value());
    }

    public IKeyring CreateAwsKmsMrkDiscoveryMultiKeyring(software.amazon.cryptography.materialproviders.model.CreateAwsKmsMrkDiscoveryMultiKeyringInput input) {
        CreateAwsKmsMrkDiscoveryMultiKeyringInput dafnyValue = ToDafny.CreateAwsKmsMrkDiscoveryMultiKeyringInput(input);
        Result<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring, Error> result = this._impl.CreateAwsKmsMrkDiscoveryMultiKeyring(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return Keyring.wrap(result.dtor_value());
    }

    public IKeyring CreateAwsKmsMrkKeyring(CreateAwsKmsMrkKeyringInput input) {
        software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsMrkKeyringInput dafnyValue = ToDafny.CreateAwsKmsMrkKeyringInput(input);
        Result<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring, Error> result = this._impl.CreateAwsKmsMrkKeyring(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return Keyring.wrap(result.dtor_value());
    }

    public IKeyring CreateAwsKmsMrkMultiKeyring(CreateAwsKmsMrkMultiKeyringInput input) {
        software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsMrkMultiKeyringInput dafnyValue = ToDafny.CreateAwsKmsMrkMultiKeyringInput(input);
        Result<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring, Error> result = this._impl.CreateAwsKmsMrkMultiKeyring(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return Keyring.wrap(result.dtor_value());
    }

    public IKeyring CreateAwsKmsMultiKeyring(software.amazon.cryptography.materialproviders.model.CreateAwsKmsMultiKeyringInput input) {
        CreateAwsKmsMultiKeyringInput dafnyValue = ToDafny.CreateAwsKmsMultiKeyringInput(input);
        Result<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring, Error> result = this._impl.CreateAwsKmsMultiKeyring(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return Keyring.wrap(result.dtor_value());
    }

    public IKeyring CreateAwsKmsRsaKeyring(CreateAwsKmsRsaKeyringInput input) {
        software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsRsaKeyringInput dafnyValue = ToDafny.CreateAwsKmsRsaKeyringInput(input);
        Result<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring, Error> result = this._impl.CreateAwsKmsRsaKeyring(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return Keyring.wrap(result.dtor_value());
    }

    public ICryptographicMaterialsCache CreateCryptographicMaterialsCache(CreateCryptographicMaterialsCacheInput input) {
        software.amazon.cryptography.materialproviders.internaldafny.types.CreateCryptographicMaterialsCacheInput dafnyValue = ToDafny.CreateCryptographicMaterialsCacheInput(input);
        Result<software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache, Error> result = this._impl.CreateCryptographicMaterialsCache(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return CryptographicMaterialsCache.wrap(result.dtor_value());
    }

    public IClientSupplier CreateDefaultClientSupplier(CreateDefaultClientSupplierInput input) {
        software.amazon.cryptography.materialproviders.internaldafny.types.CreateDefaultClientSupplierInput dafnyValue = ToDafny.CreateDefaultClientSupplierInput(input);
        Result<software.amazon.cryptography.materialproviders.internaldafny.types.IClientSupplier, Error> result = this._impl.CreateDefaultClientSupplier(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ClientSupplier.wrap(result.dtor_value());
    }

    public ICryptographicMaterialsManager CreateDefaultCryptographicMaterialsManager(software.amazon.cryptography.materialproviders.model.CreateDefaultCryptographicMaterialsManagerInput input) {
        CreateDefaultCryptographicMaterialsManagerInput dafnyValue = ToDafny.CreateDefaultCryptographicMaterialsManagerInput(input);
        Result<software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager, Error> result = this._impl.CreateDefaultCryptographicMaterialsManager(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return CryptographicMaterialsManager.wrap(result.dtor_value());
    }

    public IKeyring CreateMultiKeyring(software.amazon.cryptography.materialproviders.model.CreateMultiKeyringInput input) {
        CreateMultiKeyringInput dafnyValue = ToDafny.CreateMultiKeyringInput(input);
        Result<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring, Error> result = this._impl.CreateMultiKeyring(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return Keyring.wrap(result.dtor_value());
    }

    public IKeyring CreateRawAesKeyring(CreateRawAesKeyringInput input) {
        software.amazon.cryptography.materialproviders.internaldafny.types.CreateRawAesKeyringInput dafnyValue = ToDafny.CreateRawAesKeyringInput(input);
        Result<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring, Error> result = this._impl.CreateRawAesKeyring(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return Keyring.wrap(result.dtor_value());
    }

    public IKeyring CreateRawRsaKeyring(CreateRawRsaKeyringInput input) {
        software.amazon.cryptography.materialproviders.internaldafny.types.CreateRawRsaKeyringInput dafnyValue = ToDafny.CreateRawRsaKeyringInput(input);
        Result<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring, Error> result = this._impl.CreateRawRsaKeyring(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return Keyring.wrap(result.dtor_value());
    }

    public ICryptographicMaterialsManager CreateRequiredEncryptionContextCMM(software.amazon.cryptography.materialproviders.model.CreateRequiredEncryptionContextCMMInput input) {
        CreateRequiredEncryptionContextCMMInput dafnyValue = ToDafny.CreateRequiredEncryptionContextCMMInput(input);
        Result<software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager, Error> result = this._impl.CreateRequiredEncryptionContextCMM(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return CryptographicMaterialsManager.wrap(result.dtor_value());
    }

    public void DecryptionMaterialsWithPlaintextDataKey(DecryptionMaterials input) {
        software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials dafnyValue = ToDafny.DecryptionMaterials(input);
        Result<Tuple0, Error> result = this._impl.DecryptionMaterialsWithPlaintextDataKey(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
    }

    public void EncryptionMaterialsHasPlaintextDataKey(software.amazon.cryptography.materialproviders.model.EncryptionMaterials input) {
        EncryptionMaterials dafnyValue = ToDafny.EncryptionMaterials(input);
        Result<Tuple0, Error> result = this._impl.EncryptionMaterialsHasPlaintextDataKey(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
    }

    public AlgorithmSuiteInfo GetAlgorithmSuiteInfo(ByteBuffer input) {
        DafnySequence<? extends Byte> dafnyValue = ToDafny.GetAlgorithmSuiteInfoInput(input);
        Result<software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo, Error> result = this._impl.GetAlgorithmSuiteInfo(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.AlgorithmSuiteInfo(result.dtor_value());
    }

    public DecryptionMaterials InitializeDecryptionMaterials(software.amazon.cryptography.materialproviders.model.InitializeDecryptionMaterialsInput input) {
        InitializeDecryptionMaterialsInput dafnyValue = ToDafny.InitializeDecryptionMaterialsInput(input);
        Result<software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials, Error> result = this._impl.InitializeDecryptionMaterials(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.DecryptionMaterials(result.dtor_value());
    }

    public software.amazon.cryptography.materialproviders.model.EncryptionMaterials InitializeEncryptionMaterials(InitializeEncryptionMaterialsInput input) {
        software.amazon.cryptography.materialproviders.internaldafny.types.InitializeEncryptionMaterialsInput dafnyValue = ToDafny.InitializeEncryptionMaterialsInput(input);
        Result<EncryptionMaterials, Error> result = this._impl.InitializeEncryptionMaterials(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.EncryptionMaterials(result.dtor_value());
    }

    public void ValidAlgorithmSuiteInfo(AlgorithmSuiteInfo input) {
        software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo dafnyValue = ToDafny.AlgorithmSuiteInfo(input);
        Result<Tuple0, Error> result = this._impl.ValidAlgorithmSuiteInfo(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
    }

    public void ValidateCommitmentPolicyOnDecrypt(ValidateCommitmentPolicyOnDecryptInput input) {
        software.amazon.cryptography.materialproviders.internaldafny.types.ValidateCommitmentPolicyOnDecryptInput dafnyValue = ToDafny.ValidateCommitmentPolicyOnDecryptInput(input);
        Result<Tuple0, Error> result = this._impl.ValidateCommitmentPolicyOnDecrypt(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
    }

    public void ValidateCommitmentPolicyOnEncrypt(software.amazon.cryptography.materialproviders.model.ValidateCommitmentPolicyOnEncryptInput input) {
        ValidateCommitmentPolicyOnEncryptInput dafnyValue = ToDafny.ValidateCommitmentPolicyOnEncryptInput(input);
        Result<Tuple0, Error> result = this._impl.ValidateCommitmentPolicyOnEncrypt(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
    }

    public void ValidDecryptionMaterialsTransition(ValidDecryptionMaterialsTransitionInput input) {
        software.amazon.cryptography.materialproviders.internaldafny.types.ValidDecryptionMaterialsTransitionInput dafnyValue = ToDafny.ValidDecryptionMaterialsTransitionInput(input);
        Result<Tuple0, Error> result = this._impl.ValidDecryptionMaterialsTransition(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
    }

    public void ValidEncryptionMaterialsTransition(ValidEncryptionMaterialsTransitionInput input) {
        software.amazon.cryptography.materialproviders.internaldafny.types.ValidEncryptionMaterialsTransitionInput dafnyValue = ToDafny.ValidEncryptionMaterialsTransitionInput(input);
        Result<Tuple0, Error> result = this._impl.ValidEncryptionMaterialsTransition(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
    }

    protected IAwsCryptographicMaterialProvidersClient impl() {
        return this._impl;
    }

    static class BuilderImpl
    implements Builder {
        protected software.amazon.cryptography.materialproviders.model.MaterialProvidersConfig MaterialProvidersConfig;

        protected BuilderImpl() {
        }

        @Override
        public Builder MaterialProvidersConfig(software.amazon.cryptography.materialproviders.model.MaterialProvidersConfig MaterialProvidersConfig2) {
            this.MaterialProvidersConfig = MaterialProvidersConfig2;
            return this;
        }

        @Override
        public software.amazon.cryptography.materialproviders.model.MaterialProvidersConfig MaterialProvidersConfig() {
            return this.MaterialProvidersConfig;
        }

        @Override
        public MaterialProviders build() {
            if (Objects.isNull(this.MaterialProvidersConfig())) {
                throw new IllegalArgumentException("Missing value for required field `MaterialProvidersConfig`");
            }
            return new MaterialProviders(this);
        }
    }

    public static interface Builder {
        public Builder MaterialProvidersConfig(software.amazon.cryptography.materialproviders.model.MaterialProvidersConfig var1);

        public software.amazon.cryptography.materialproviders.model.MaterialProvidersConfig MaterialProvidersConfig();

        public MaterialProviders build();
    }
}

