/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.keystore.internaldafny;

import AwsArnParsing_Compile.AwsKmsIdentifier;
import AwsCryptographyKeyStoreOperations_Compile.Config;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import software.amazon.cryptography.keystore.internaldafny.KeyStoreClient;
import software.amazon.cryptography.keystore.internaldafny.types.Error;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration;
import software.amazon.cryptography.keystore.internaldafny.types.KeyStoreConfig;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.IDynamoDBClient;
import software.amazon.cryptography.services.dynamodb.internaldafny.types._Companion_IDynamoDBClient;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.__default;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;
import software.amazon.cryptography.services.kms.internaldafny.types._Companion_IKMSClient;

public abstract class _ExternBase___default {
    public static KeyStoreConfig DefaultKeyStoreConfig() {
        return KeyStoreConfig.create((DafnySequence<? extends Character>)DafnySequence.asString((String)"None"), KMSConfiguration.create((DafnySequence<? extends Character>)DafnySequence.asString((String)"1234abcd-12ab-34cd-56ef-1234567890ab")), (DafnySequence<? extends Character>)DafnySequence.asString((String)"None"), Option.create_None(), Option.create_None(), Option.create_None(), Option.create_None());
    }

    public static Result<KeyStoreClient, Error> KeyStore(KeyStoreConfig config) {
        Result<KeyStoreClient, Error> res = null;
        Outcome<Object> _285_valueOrError0 = Outcome.Default();
        _285_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__KeyIdType(config.dtor_kmsConfiguration().dtor_kmsKeyArn()) && AwsArnParsing_Compile.__default.ParseAwsKmsArn(config.dtor_kmsConfiguration().dtor_kmsKeyArn()).is_Success(), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid AWS KMS Key Arn")));
        if (_285_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _285_valueOrError0.PropagateFailure(Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
            return res;
        }
        Result<DafnySequence<? extends DafnySequence<? extends Character>>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _286_grantTokens = AwsKmsUtils_Compile.__default.GetValidGrantTokens(config.dtor_grantTokens());
        Outcome<Object> _287_valueOrError1 = Outcome.Default();
        _287_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _286_grantTokens.is_Success(), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"CreateKey received invalid grant tokens")));
        if (_287_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _287_valueOrError1.PropagateFailure(Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
            return res;
        }
        DafnySequence _288_keyStoreId = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
        if (config.dtor_id().is_Some()) {
            _288_keyStoreId = config.dtor_id().dtor_value();
        } else {
            DafnySequence _290_uuid;
            Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> _out44;
            Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> _289_maybeUuid = _out44 = UUID.__default.GenerateUUID();
            Result<Object, Object> _291_valueOrError2 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _291_valueOrError2 = _289_maybeUuid.MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _292_e_boxed0 -> {
                DafnySequence _292_e = _292_e_boxed0;
                return Error.create_KeyStoreException((DafnySequence<? extends Character>)_292_e);
            });
            if (_291_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                res = _291_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _288_keyStoreId = _290_uuid = (DafnySequence)_291_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
        }
        IKMSClient _293_kmsClient = null;
        IDynamoDBClient _294_ddbClient = null;
        Result<AwsKmsIdentifier, DafnySequence<? extends Character>> _295_keyArn = AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(config.dtor_kmsConfiguration().dtor_kmsKeyArn());
        Option<DafnySequence<? extends Character>> _296_kmsRegion = AwsArnParsing_Compile.__default.GetRegion(_295_keyArn.dtor_value());
        if (config.dtor_kmsClient().is_None()) {
            Result<IKMSClient, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out45;
            Result<IKMSClient, software.amazon.cryptography.services.kms.internaldafny.types.Error> _297_maybeKmsClient = _out45 = software.amazon.cryptography.services.kms.internaldafny.__default.KMSClientForRegion(_296_kmsRegion.dtor_value());
            Result<IKMSClient, Error> _298_valueOrError3 = null;
            _298_valueOrError3 = _297_maybeKmsClient.MapFailure(_Companion_IKMSClient._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _299_e_boxed0 -> {
                software.amazon.cryptography.services.kms.internaldafny.types.Error _299_e = _299_e_boxed0;
                return Error.create_ComAmazonawsKms(_299_e);
            });
            if (_298_valueOrError3.IsFailure(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor())) {
                res = _298_valueOrError3.PropagateFailure(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _293_kmsClient = _298_valueOrError3.Extract(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor());
        } else {
            _293_kmsClient = config.dtor_kmsClient().dtor_value();
        }
        if (config.dtor_ddbClient().is_None()) {
            Result<IDynamoDBClient, software.amazon.cryptography.services.dynamodb.internaldafny.types.Error> _out46;
            Result<IDynamoDBClient, software.amazon.cryptography.services.dynamodb.internaldafny.types.Error> _300_maybeDdbClient = _out46 = software.amazon.cryptography.services.dynamodb.internaldafny.__default.DDBClientForRegion(_296_kmsRegion.dtor_value());
            Result<IDynamoDBClient, Error> _301_valueOrError4 = null;
            _301_valueOrError4 = _300_maybeDdbClient.MapFailure(_Companion_IDynamoDBClient._typeDescriptor(), software.amazon.cryptography.services.dynamodb.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _302_e_boxed0 -> {
                software.amazon.cryptography.services.dynamodb.internaldafny.types.Error _302_e = _302_e_boxed0;
                return Error.create_ComAmazonawsDynamodb(_302_e);
            });
            if (_301_valueOrError4.IsFailure(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor())) {
                res = _301_valueOrError4.PropagateFailure(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _294_ddbClient = _301_valueOrError4.Extract(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor());
        } else {
            _294_ddbClient = config.dtor_ddbClient().dtor_value();
        }
        Outcome<Object> _303_valueOrError5 = Outcome.Default();
        _303_valueOrError5 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), __default.IsValid__TableName(config.dtor_ddbTableName()), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Amazon DynamoDB Table Name")));
        if (_303_valueOrError5.IsFailure(Error._typeDescriptor())) {
            res = _303_valueOrError5.PropagateFailure(Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
            return res;
        }
        KeyStoreClient _nw0 = new KeyStoreClient();
        _nw0.__ctor(Config.create((DafnySequence<? extends Character>)_288_keyStoreId, config.dtor_ddbTableName(), config.dtor_logicalKeyStoreName(), config.dtor_kmsConfiguration(), _286_grantTokens.dtor_value(), _293_kmsClient, _294_ddbClient));
        KeyStoreClient _304_client = _nw0;
        res = Result.create_Success(_304_client);
        return res;
    }

    public String toString() {
        return "KeyStore._default";
    }
}

