/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsKeyring_Compile;

import Actions_Compile.Action;
import Actions_Compile.ActionWithResult;
import AwsKmsKeyring_Compile.KmsWrapInfo;
import MaterialWrapping_Compile.WrapInput;
import MaterialWrapping_Compile.WrapMaterial;
import MaterialWrapping_Compile.WrapOutput;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.__default;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.services.kms.internaldafny.types.EncryptRequest;
import software.amazon.cryptography.services.kms.internaldafny.types.EncryptResponse;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class KmsWrapKeyMaterial
implements WrapMaterial<KmsWrapInfo>,
ActionWithResult<WrapInput, WrapOutput<KmsWrapInfo>, Error>,
Action<WrapInput, Result<WrapOutput<KmsWrapInfo>, Error>> {
    public IKMSClient _client = null;
    public DafnySequence<? extends Character> _awsKmsKey = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    private static final TypeDescriptor<KmsWrapKeyMaterial> _TYPE = TypeDescriptor.referenceWithInitializer(KmsWrapKeyMaterial.class, () -> null);

    public void __ctor(IKMSClient client, DafnySequence<? extends Character> awsKmsKey, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        this._client = client;
        this._awsKmsKey = awsKmsKey;
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<WrapOutput<KmsWrapInfo>, Error> Invoke(WrapInput input) {
        Result<EncryptResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out89;
        Result<WrapOutput<KmsWrapInfo>, Error> res = Result.Default(WrapOutput.Default(KmsWrapInfo.Default()));
        AlgorithmSuiteInfo _586_suite = input.dtor_algorithmSuite();
        Result<Object, Object> _588_valueOrError0 = Result.Default(DafnyMap.empty());
        _588_valueOrError0 = AwsKmsUtils_Compile.__default.StringifyEncryptionContext(input.dtor_encryptionContext());
        if (_588_valueOrError0.IsFailure((TypeDescriptor<DafnyMap>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor())) {
            res = _588_valueOrError0.PropagateFailure((TypeDescriptor<Object>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), WrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        DafnyMap _587_stringifiedEncCtx = (DafnyMap)_588_valueOrError0.Extract((TypeDescriptor<Object>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor());
        Outcome<Object> _589_valueOrError1 = Outcome.Default();
        _589_valueOrError1 = __default.Need(Error._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__PlaintextType(input.dtor_plaintextMaterial()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Plaintext on KMS Encrypt")));
        if (_589_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _589_valueOrError1.PropagateFailure(Error._typeDescriptor(), WrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        EncryptRequest _590_encryptRequest = EncryptRequest.create(this.awsKmsKey(), input.dtor_plaintextMaterial(), Option.create_Some(_587_stringifiedEncCtx), Option.create_Some(this.grantTokens()), Option.create_None());
        Result<EncryptResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _591_maybeEncryptResponse = _out89 = this.client().Encrypt(_590_encryptRequest);
        Result<EncryptResponse, Object> _593_valueOrError2 = Result.Default(EncryptResponse.Default());
        _593_valueOrError2 = _591_maybeEncryptResponse.MapFailure(EncryptResponse._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _594_e_boxed0 -> {
            software.amazon.cryptography.services.kms.internaldafny.types.Error _594_e = _594_e_boxed0;
            return Error.create_ComAmazonawsKms(_594_e);
        });
        if (_593_valueOrError2.IsFailure(EncryptResponse._typeDescriptor(), Error._typeDescriptor())) {
            res = _593_valueOrError2.PropagateFailure(EncryptResponse._typeDescriptor(), Error._typeDescriptor(), WrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        EncryptResponse _592_encryptResponse = _593_valueOrError2.Extract(EncryptResponse._typeDescriptor(), Error._typeDescriptor());
        Outcome<Object> _595_valueOrError3 = Outcome.Default();
        _595_valueOrError3 = __default.Need(Error._typeDescriptor(), _592_encryptResponse.dtor_KeyId().is_Some() && AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(_592_encryptResponse.dtor_KeyId().dtor_value()).is_Success(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS Encrypt:: Invalid Key Id")));
        if (_595_valueOrError3.IsFailure(Error._typeDescriptor())) {
            res = _595_valueOrError3.PropagateFailure(Error._typeDescriptor(), WrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        Outcome<Object> _596_valueOrError4 = Outcome.Default();
        _596_valueOrError4 = __default.Need(Error._typeDescriptor(), _592_encryptResponse.dtor_CiphertextBlob().is_Some(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS Encrypt: Invalid Ciphertext Blob")));
        if (_596_valueOrError4.IsFailure(Error._typeDescriptor())) {
            res = _596_valueOrError4.PropagateFailure(Error._typeDescriptor(), WrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        WrapOutput<KmsWrapInfo> _597_output = WrapOutput.create(_592_encryptResponse.dtor_CiphertextBlob().dtor_value(), KmsWrapInfo.create(_592_encryptResponse.dtor_KeyId().dtor_value()));
        res = Result.create_Success(_597_output);
        return res;
    }

    public IKMSClient client() {
        return this._client;
    }

    public DafnySequence<? extends Character> awsKmsKey() {
        return this._awsKmsKey;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public static TypeDescriptor<KmsWrapKeyMaterial> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsKeyring.KmsWrapKeyMaterial";
    }
}

