/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsKeyring_Compile;

import Actions_Compile.Action;
import Actions_Compile.ActionWithResult;
import AwsKmsKeyring_Compile.KmsUnwrapInfo;
import MaterialWrapping_Compile.UnwrapInput;
import MaterialWrapping_Compile.UnwrapMaterial;
import MaterialWrapping_Compile.UnwrapOutput;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.__default;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.services.kms.internaldafny.types.DecryptRequest;
import software.amazon.cryptography.services.kms.internaldafny.types.DecryptResponse;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class KmsUnwrapKeyMaterial
implements UnwrapMaterial<KmsUnwrapInfo>,
ActionWithResult<UnwrapInput, UnwrapOutput<KmsUnwrapInfo>, Error>,
Action<UnwrapInput, Result<UnwrapOutput<KmsUnwrapInfo>, Error>> {
    public IKMSClient _client = null;
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    public DafnySequence<? extends Character> _awsKmsKey = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    private static final TypeDescriptor<KmsUnwrapKeyMaterial> _TYPE = TypeDescriptor.referenceWithInitializer(KmsUnwrapKeyMaterial.class, () -> null);

    public void __ctor(IKMSClient client, DafnySequence<? extends Character> awsKmsKey, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        this._client = client;
        this._awsKmsKey = awsKmsKey;
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<UnwrapOutput<KmsUnwrapInfo>, Error> Invoke(UnwrapInput input) {
        Result<DecryptResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out87;
        Result<UnwrapOutput<KmsUnwrapInfo>, Error> res = Result.Default(UnwrapOutput.Default(KmsUnwrapInfo.Default()));
        Outcome<Object> _564_valueOrError0 = Outcome.Default();
        _564_valueOrError0 = __default.Need(Error._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__CiphertextType(input.dtor_wrappedMaterial()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Ciphertext length invalid")));
        if (_564_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _564_valueOrError0.PropagateFailure(Error._typeDescriptor(), UnwrapOutput._typeDescriptor(KmsUnwrapInfo._typeDescriptor()));
            return res;
        }
        Result<Object, Object> _566_valueOrError1 = Result.Default(DafnyMap.empty());
        _566_valueOrError1 = AwsKmsUtils_Compile.__default.StringifyEncryptionContext(input.dtor_encryptionContext());
        if (_566_valueOrError1.IsFailure((TypeDescriptor<DafnyMap>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor())) {
            res = _566_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), UnwrapOutput._typeDescriptor(KmsUnwrapInfo._typeDescriptor()));
            return res;
        }
        DafnyMap _565_stringifiedEncCtx = (DafnyMap)_566_valueOrError1.Extract((TypeDescriptor<Object>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor());
        DecryptRequest _567_decryptRequest = DecryptRequest.create(input.dtor_wrappedMaterial(), Option.create_Some(_565_stringifiedEncCtx), Option.create_Some(this.grantTokens()), Option.create_Some(this.awsKmsKey()), Option.create_None());
        Result<DecryptResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _568_maybeDecryptResponse = _out87 = this.client().Decrypt(_567_decryptRequest);
        Result<DecryptResponse, Object> _570_valueOrError2 = Result.Default(DecryptResponse.Default());
        _570_valueOrError2 = _568_maybeDecryptResponse.MapFailure(DecryptResponse._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _571_e_boxed0 -> {
            software.amazon.cryptography.services.kms.internaldafny.types.Error _571_e = _571_e_boxed0;
            return Error.create_ComAmazonawsKms(_571_e);
        });
        if (_570_valueOrError2.IsFailure(DecryptResponse._typeDescriptor(), Error._typeDescriptor())) {
            res = _570_valueOrError2.PropagateFailure(DecryptResponse._typeDescriptor(), Error._typeDescriptor(), UnwrapOutput._typeDescriptor(KmsUnwrapInfo._typeDescriptor()));
            return res;
        }
        DecryptResponse _569_decryptResponse = _570_valueOrError2.Extract(DecryptResponse._typeDescriptor(), Error._typeDescriptor());
        Outcome<Object> _572_valueOrError3 = Outcome.Default();
        _572_valueOrError3 = __default.Need(Error._typeDescriptor(), _569_decryptResponse.dtor_KeyId().is_Some() && _569_decryptResponse.dtor_KeyId().dtor_value().equals(this.awsKmsKey()) && _569_decryptResponse.dtor_Plaintext().is_Some() && Objects.equals(BigInteger.valueOf(AlgorithmSuites_Compile.__default.GetEncryptKeyLength(input.dtor_algorithmSuite())), BigInteger.valueOf(_569_decryptResponse.dtor_Plaintext().dtor_value().length())), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from KMS Decrypt")));
        if (_572_valueOrError3.IsFailure(Error._typeDescriptor())) {
            res = _572_valueOrError3.PropagateFailure(Error._typeDescriptor(), UnwrapOutput._typeDescriptor(KmsUnwrapInfo._typeDescriptor()));
            return res;
        }
        UnwrapOutput<KmsUnwrapInfo> _573_output = UnwrapOutput.create(_569_decryptResponse.dtor_Plaintext().dtor_value(), KmsUnwrapInfo.create());
        res = Result.create_Success(_573_output);
        return res;
    }

    public IKMSClient client() {
        return this._client;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public DafnySequence<? extends Character> awsKmsKey() {
        return this._awsKmsKey;
    }

    public static TypeDescriptor<KmsUnwrapKeyMaterial> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsKeyring.KmsUnwrapKeyMaterial";
    }
}

